/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.montecarlo.interestrate.modelplugins.TermStructureTenorTimeScalingInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class TermStructureTenorTimeScalingPicewiseConstant
implements TermStructureTenorTimeScalingInterface {
    private final TimeDiscretizationInterface timeDiscretization;
    private final double[] timesIntegrated;
    private final double floor = -0.9;
    private final double cap = 9.0;
    private final double parameterScaling = 100.0;

    public TermStructureTenorTimeScalingPicewiseConstant(TimeDiscretizationInterface timeDiscretization, double[] parameters) {
        this.timeDiscretization = timeDiscretization;
        this.timesIntegrated = new double[timeDiscretization.getNumberOfTimes()];
        for (int timeIntervallIndex = 0; timeIntervallIndex < timeDiscretization.getNumberOfTimeSteps(); ++timeIntervallIndex) {
            this.timesIntegrated[timeIntervallIndex + 1] = this.timesIntegrated[timeIntervallIndex] + (1.0 + Math.min(Math.max(100.0 * parameters[timeIntervallIndex], -0.9), 9.0)) * timeDiscretization.getTimeStep(timeIntervallIndex);
        }
    }

    @Override
    public double getScaledTenorTime(double periodStart, double periodEnd) {
        int timeStartIndex = this.timeDiscretization.getTimeIndexNearestLessOrEqual(periodStart);
        int timeEndIndex = this.timeDiscretization.getTimeIndexNearestLessOrEqual(periodEnd);
        if (this.timeDiscretization.getTime(timeStartIndex) != periodStart) {
            System.out.println("*****S" + periodStart);
        }
        if (this.timeDiscretization.getTime(timeEndIndex) != periodEnd) {
            System.out.println("*****E" + periodStart);
        }
        double timeScaled = this.timesIntegrated[timeEndIndex] - this.timesIntegrated[timeStartIndex];
        return timeScaled;
    }

    @Override
    public TermStructureTenorTimeScalingInterface getCloneWithModifiedParameters(double[] parameters) {
        return new TermStructureTenorTimeScalingPicewiseConstant(this.timeDiscretization, parameters);
    }

    @Override
    public double[] getParameter() {
        double[] parameter = new double[this.timeDiscretization.getNumberOfTimeSteps()];
        for (int timeIntervallIndex = 0; timeIntervallIndex < this.timeDiscretization.getNumberOfTimeSteps(); ++timeIntervallIndex) {
            parameter[timeIntervallIndex] = ((this.timesIntegrated[timeIntervallIndex + 1] - this.timesIntegrated[timeIntervallIndex]) / this.timeDiscretization.getTimeStep(timeIntervallIndex) - 1.0) / 100.0;
        }
        return parameter;
    }

    @Override
    public TermStructureTenorTimeScalingInterface clone() {
        return this;
    }
}

