/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.finmath.montecarlo.AbstractRandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModel;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORVolatilityModelPiecewiseConstant
extends LIBORVolatilityModel {
    private final AbstractRandomVariableFactory randomVariableFactory;
    private final TimeDiscretizationInterface simulationTimeDiscretization;
    private final TimeDiscretizationInterface timeToMaturityDiscretization;
    private Map<Integer, HashMap<Integer, Integer>> indexMap = new HashMap<Integer, HashMap<Integer, Integer>>();
    private double[] volatility;
    private final boolean isCalibrateable;

    public LIBORVolatilityModelPiecewiseConstant(AbstractRandomVariableFactory randomVariableFactory, TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, TimeDiscretizationInterface simulationTimeDiscretization, TimeDiscretizationInterface timeToMaturityDiscretization, double[] volatility, boolean isCalibrateable) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.randomVariableFactory = randomVariableFactory;
        double maxMaturity = timeToMaturityDiscretization.getTime(timeToMaturityDiscretization.getNumberOfTimes() - 1);
        int volatilityIndex = 0;
        for (int simulationTime = 0; simulationTime < simulationTimeDiscretization.getNumberOfTimes(); ++simulationTime) {
            HashMap<Integer, Integer> timeToMaturityIndexing = new HashMap<Integer, Integer>();
            for (int timeToMaturity = 0; timeToMaturity < timeToMaturityDiscretization.getNumberOfTimes(); ++timeToMaturity) {
                if (simulationTimeDiscretization.getTime(simulationTime) + timeToMaturityDiscretization.getTime(timeToMaturity) > maxMaturity) continue;
                timeToMaturityIndexing.put(timeToMaturity, volatilityIndex++);
            }
            this.indexMap.put(simulationTime, timeToMaturityIndexing);
        }
        if (volatility.length == 1) {
            this.volatility = new double[volatilityIndex];
            Arrays.fill(this.volatility, volatility[0]);
        } else {
            this.volatility = volatility;
        }
        if (volatilityIndex != this.volatility.length) {
            throw new IllegalArgumentException("volatility.length should equal simulationTimeDiscretization.getNumberOfTimes()*timeToMaturityDiscretization.getNumberOfTimes().");
        }
        this.simulationTimeDiscretization = simulationTimeDiscretization;
        this.timeToMaturityDiscretization = timeToMaturityDiscretization;
        this.isCalibrateable = isCalibrateable;
    }

    public LIBORVolatilityModelPiecewiseConstant(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, TimeDiscretizationInterface simulationTimeDiscretization, TimeDiscretizationInterface timeToMaturityDiscretization, double[] volatility, boolean isCalibrateable) {
        this(new RandomVariableFactory(), timeDiscretization, liborPeriodDiscretization, simulationTimeDiscretization, timeToMaturityDiscretization, volatility, isCalibrateable);
    }

    public LIBORVolatilityModelPiecewiseConstant(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, TimeDiscretizationInterface simulationTimeDiscretization, TimeDiscretizationInterface timeToMaturityDiscretization, double volatility, boolean isCalibrateable) {
        this(timeDiscretization, liborPeriodDiscretization, simulationTimeDiscretization, timeToMaturityDiscretization, new double[]{volatility}, isCalibrateable);
    }

    public LIBORVolatilityModelPiecewiseConstant(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, TimeDiscretizationInterface simulationTimeDiscretization, TimeDiscretizationInterface timeToMaturityDiscretization, double[] volatility) {
        this(timeDiscretization, liborPeriodDiscretization, simulationTimeDiscretization, timeToMaturityDiscretization, volatility, true);
    }

    public LIBORVolatilityModelPiecewiseConstant(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, TimeDiscretizationInterface simulationTimeDiscretization, TimeDiscretizationInterface timeToMaturityDiscretization, double volatility) {
        this(timeDiscretization, liborPeriodDiscretization, simulationTimeDiscretization, timeToMaturityDiscretization, new double[]{volatility});
    }

    @Override
    public double[] getParameter() {
        if (this.isCalibrateable) {
            return this.volatility;
        }
        return null;
    }

    @Override
    public void setParameter(double[] parameter) {
        if (this.isCalibrateable) {
            this.volatility = parameter;
        }
    }

    @Override
    public RandomVariableInterface getVolatility(int timeIndex, int liborIndex) {
        double volatilityInstanteaneous;
        double time = this.getTimeDiscretization().getTime(timeIndex);
        double maturity = this.getLiborPeriodDiscretization().getTime(liborIndex);
        double timeToMaturity = maturity - time;
        if (timeToMaturity <= 0.0) {
            volatilityInstanteaneous = 0.0;
        } else {
            int timeIndexTimeToMaturity;
            int timeIndexSimulationTime = this.simulationTimeDiscretization.getTimeIndex(time);
            if (timeIndexSimulationTime < 0) {
                timeIndexSimulationTime = -timeIndexSimulationTime - 1 - 1;
            }
            if (timeIndexSimulationTime < 0) {
                timeIndexSimulationTime = 0;
            }
            if (timeIndexSimulationTime >= this.simulationTimeDiscretization.getNumberOfTimes()) {
                --timeIndexSimulationTime;
            }
            if ((timeIndexTimeToMaturity = this.timeToMaturityDiscretization.getTimeIndex(timeToMaturity)) < 0) {
                timeIndexTimeToMaturity = -timeIndexTimeToMaturity - 1 - 1;
            }
            if (timeIndexTimeToMaturity < 0) {
                timeIndexTimeToMaturity = 0;
            }
            if (timeIndexTimeToMaturity >= this.timeToMaturityDiscretization.getNumberOfTimes()) {
                --timeIndexTimeToMaturity;
            }
            volatilityInstanteaneous = this.volatility[this.indexMap.get(timeIndexSimulationTime).get(timeIndexTimeToMaturity)];
        }
        if (volatilityInstanteaneous < 0.0) {
            volatilityInstanteaneous = Math.max(volatilityInstanteaneous, 0.0);
        }
        return this.randomVariableFactory.createRandomVariable(time, volatilityInstanteaneous);
    }

    @Override
    public Object clone() {
        return new LIBORVolatilityModelPiecewiseConstant(super.getTimeDiscretization(), super.getLiborPeriodDiscretization(), this.simulationTimeDiscretization, this.timeToMaturityDiscretization, (double[])this.volatility.clone(), this.isCalibrateable);
    }
}

