/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.modelplugins;

import net.finmath.marketdata.model.volatilities.CapletVolatilitiesParametric;
import net.finmath.marketdata.model.volatilities.VolatilitySurfaceInterface;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.interestrate.modelplugins.LIBORVolatilityModel;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class LIBORVolatilityModelFourParameterExponentialFormIntegrated
extends LIBORVolatilityModel {
    private double a;
    private double b;
    private double c;
    private double d;
    private boolean isCalibrateable = false;
    private transient CapletVolatilitiesParametric cap;

    public LIBORVolatilityModelFourParameterExponentialFormIntegrated(TimeDiscretizationInterface timeDiscretization, TimeDiscretizationInterface liborPeriodDiscretization, double a, double b, double c, double d, boolean isCalibrateable) {
        super(timeDiscretization, liborPeriodDiscretization);
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.isCalibrateable = isCalibrateable;
        this.cap = new CapletVolatilitiesParametric("", null, a, b, c, d);
    }

    @Override
    public double[] getParameter() {
        if (!this.isCalibrateable) {
            return null;
        }
        double[] parameter = new double[]{this.a, this.b, this.c, this.d};
        return parameter;
    }

    @Override
    public void setParameter(double[] parameter) {
        if (!this.isCalibrateable) {
            return;
        }
        this.a = parameter[0];
        this.b = parameter[1];
        this.c = parameter[2];
        this.d = parameter[3];
        this.cap = new CapletVolatilitiesParametric("", null, this.a, this.b, this.c, this.d);
    }

    @Override
    public RandomVariableInterface getVolatility(int timeIndex, int liborIndex) {
        double timeStart = this.getTimeDiscretization().getTime(timeIndex);
        double timeEnd = this.getTimeDiscretization().getTime(timeIndex + 1);
        double maturity = this.getLiborPeriodDiscretization().getTime(liborIndex);
        double volStart = this.cap.getValue(maturity - timeStart, 0.0, VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL);
        double volEnd = this.cap.getValue(maturity - timeEnd, 0.0, VolatilitySurfaceInterface.QuotingConvention.VOLATILITYLOGNORMAL);
        double varianceInstantaneous = (volStart * volStart * (maturity - timeStart) - volEnd * volEnd * (maturity - timeEnd)) / (timeEnd - timeStart);
        varianceInstantaneous = Math.max(varianceInstantaneous, 0.0);
        return new RandomVariable(Math.sqrt(varianceInstantaneous));
    }

    @Override
    public Object clone() {
        return new LIBORVolatilityModelFourParameterExponentialFormIntegrated(super.getTimeDiscretization(), super.getLiborPeriodDiscretization(), this.a, this.b, this.c, this.d, this.isCalibrateable);
    }
}

