/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate;

import java.util.HashMap;
import java.util.Map;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.interestrate.TermStructureModelInterface;
import net.finmath.montecarlo.interestrate.TermStructureModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.model.AbstractModelInterface;
import net.finmath.montecarlo.process.AbstractProcess;
import net.finmath.montecarlo.process.AbstractProcessInterface;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class TermStructureModelMonteCarloSimulation
implements LIBORModelMonteCarloSimulationInterface {
    private final TermStructureModelInterface model;

    public TermStructureModelMonteCarloSimulation(TermStructureModelInterface model, AbstractProcess process) {
        this.model = model;
        this.model.setProcess(process);
        process.setModel(model);
    }

    public TermStructureModelMonteCarloSimulation(TermStructureModelInterface model) {
        this.model = model;
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(int timeIndex) throws CalculationException {
        return this.model.getProcess().getMonteCarloWeights(timeIndex);
    }

    @Override
    public RandomVariableInterface getMonteCarloWeights(double time) throws CalculationException {
        int timeIndex = this.getTimeIndex(time);
        if (timeIndex < 0) {
            timeIndex = -timeIndex - 1 - 1;
        }
        return this.model.getProcess().getMonteCarloWeights(timeIndex);
    }

    @Override
    public int getNumberOfFactors() {
        return this.model.getProcess().getNumberOfFactors();
    }

    @Override
    public int getNumberOfPaths() {
        return this.model.getProcess().getNumberOfPaths();
    }

    @Override
    public double getTime(int timeIndex) {
        return this.model.getProcess().getTime(timeIndex);
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.model.getProcess().getTimeDiscretization();
    }

    @Override
    public int getTimeIndex(double time) {
        return this.model.getProcess().getTimeIndex(time);
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.model.getProcess().getStochasticDriver().getRandomVariableForConstant(value);
    }

    @Override
    public BrownianMotionInterface getBrownianMotion() {
        return (BrownianMotionInterface)this.model.getProcess().getStochasticDriver();
    }

    @Override
    public RandomVariableInterface getLIBOR(int timeIndex, int liborIndex) throws CalculationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RandomVariableInterface[] getLIBORs(int timeIndex) throws CalculationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RandomVariableInterface getLIBOR(double time, double periodStart, double periodEnd) throws CalculationException {
        return this.model.getLIBOR(time, periodStart, periodEnd);
    }

    @Override
    public double getLiborPeriod(int timeIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TimeDiscretizationInterface getLiborPeriodDiscretization() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLiborPeriodIndex(double time) {
        throw new UnsupportedOperationException();
    }

    public int getNumberOfComponents() {
        return this.model.getNumberOfComponents();
    }

    @Override
    public int getNumberOfLibors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RandomVariableInterface getNumeraire(double time) throws CalculationException {
        return this.model.getNumeraire(time);
    }

    @Override
    public TermStructureModelInterface getModel() {
        return this.model;
    }

    @Override
    public AbstractProcessInterface getProcess() {
        return this.model.getProcess();
    }

    @Override
    public Object getCloneWithModifiedSeed(int seed) {
        AbstractProcess process = (AbstractProcess)((AbstractProcess)this.getProcess()).getCloneWithModifiedSeed(seed);
        return new TermStructureModelMonteCarloSimulation(this.model, process);
    }

    @Override
    public LIBORModelMonteCarloSimulationInterface getCloneWithModifiedData(Map<String, Object> dataModified) throws CalculationException {
        AbstractModelInterface modelClone = this.model.getCloneWithModifiedData((Map)dataModified);
        if (dataModified.containsKey("discountCurve") && dataModified.size() == 1) {
            TermStructureModelMonteCarloSimulation lmmSimClone = new TermStructureModelMonteCarloSimulation((TermStructureModelInterface)modelClone);
            modelClone.setProcess(this.getProcess());
            return lmmSimClone;
        }
        return new TermStructureModelMonteCarloSimulation((TermStructureModelInterface)modelClone, (AbstractProcess)this.getProcess().clone());
    }

    public TermStructureModelMonteCarloSimulationInterface getCloneWithModifiedData(String entityKey, Object dataModified) throws CalculationException {
        HashMap<String, Object> dataModifiedMap = new HashMap<String, Object>();
        dataModifiedMap.put(entityKey, dataModified);
        return this.getCloneWithModifiedData(dataModifiedMap);
    }
}

