/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import java.util.ArrayList;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.montecarlo.conditionalexpectation.MonteCarloConditionalExpectationRegression;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationInterface;

public class LocalRiskMinimizingHedgePortfolio
extends AbstractAssetMonteCarloProduct {
    private final AbstractAssetMonteCarloProduct productToHedge;
    private final AssetModelMonteCarloSimulationInterface modelUsedForHedging;
    private final TimeDiscretizationInterface timeDiscretizationForRebalancing;
    private final int numberOfBins;

    public LocalRiskMinimizingHedgePortfolio(AbstractAssetMonteCarloProduct productToHedge, AssetModelMonteCarloSimulationInterface modelUsedForHedging, TimeDiscretizationInterface timeDiscretizationForRebalancing, int numberOfBins) {
        this.productToHedge = productToHedge;
        this.modelUsedForHedging = modelUsedForHedging;
        this.timeDiscretizationForRebalancing = timeDiscretizationForRebalancing;
        this.numberOfBins = numberOfBins;
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, AssetModelMonteCarloSimulationInterface model) throws CalculationException {
        int timeIndexEvaluationTime = model.getTimeIndex(evaluationTime);
        int numberOfPath = model.getNumberOfPaths();
        RandomVariableInterface numeraireToday = model.getNumeraire(0.0);
        double valueOfOptionAccordingHedgeModel = this.productToHedge.getValue(this.modelUsedForHedging);
        RandomVariableInterface amountOfNumeraireAsset = numeraireToday.invert().mult(valueOfOptionAccordingHedgeModel);
        RandomVariableInterface amountOfUderlyingAsset = model.getRandomVariableForConstant(0.0);
        for (int timeIndex = 0; timeIndex < this.timeDiscretizationForRebalancing.getNumberOfTimes() - 1; ++timeIndex) {
            RandomVariableInterface newNumberOfNumeraireAsset;
            double time = this.timeDiscretizationForRebalancing.getTime(timeIndex);
            double timeNext = this.timeDiscretizationForRebalancing.getTime(timeIndex + 1);
            if (time > evaluationTime) break;
            RandomVariableInterface underlyingAtTime = this.modelUsedForHedging.getAssetValue(time, 0);
            RandomVariableInterface numeraireAtTime = this.modelUsedForHedging.getNumeraire(time);
            RandomVariableInterface underlyingAtTimeNext = this.modelUsedForHedging.getAssetValue(timeNext, 0);
            RandomVariableInterface numeraireAtTimeNext = this.modelUsedForHedging.getNumeraire(timeNext);
            RandomVariableInterface productAtTime = this.productToHedge.getValue(time, this.modelUsedForHedging);
            RandomVariableInterface productAtTimeNext = this.productToHedge.getValue(timeNext, this.modelUsedForHedging);
            RandomVariableInterface[] basisFunctionsEstimator = this.getBasisFunctions(this.modelUsedForHedging.getAssetValue(time, 0));
            RandomVariableInterface[] basisFunctionsPredictor = this.getBasisFunctions(model.getAssetValue(time, 0));
            MonteCarloConditionalExpectationRegression condExpectationHedging = new MonteCarloConditionalExpectationRegression(basisFunctionsEstimator, basisFunctionsEstimator);
            MonteCarloConditionalExpectationRegression condExpectationValuation = new MonteCarloConditionalExpectationRegression(basisFunctionsEstimator, basisFunctionsPredictor);
            RandomVariableInterface S = underlyingAtTimeNext.div(numeraireAtTimeNext);
            RandomVariableInterface ES = condExpectationHedging.getConditionalExpectation(S);
            S = S.sub(ES);
            RandomVariableInterface V = productAtTimeNext.div(numeraireAtTimeNext);
            RandomVariableInterface EV = condExpectationHedging.getConditionalExpectation(V);
            V = V.sub(EV);
            RandomVariableInterface SV = V.mult(S);
            RandomVariableInterface ESV = condExpectationValuation.getConditionalExpectation(SV);
            RandomVariableInterface S2 = S.mult(S);
            RandomVariableInterface ES2 = condExpectationValuation.getConditionalExpectation(S2);
            RandomVariableInterface delta = ESV.div(ES2);
            RandomVariableInterface underlyingValue = model.getAssetValue(time, 0);
            RandomVariableInterface numeraireValue = model.getNumeraire(time);
            RandomVariableInterface newNumberOfStocks = delta;
            RandomVariableInterface stocksToBuy = newNumberOfStocks.sub(amountOfUderlyingAsset);
            RandomVariableInterface numeraireAssetsToBuy = stocksToBuy.mult(underlyingValue).div(numeraireValue).mult(-1.0);
            amountOfNumeraireAsset = newNumberOfNumeraireAsset = amountOfNumeraireAsset.add(numeraireAssetsToBuy);
            amountOfUderlyingAsset = newNumberOfStocks;
        }
        RandomVariableInterface underlyingAtEvaluationTime = model.getAssetValue(evaluationTime, 0);
        RandomVariableInterface numeraireAtEvaluationTime = model.getNumeraire(evaluationTime);
        RandomVariableInterface portfolioValue = amountOfNumeraireAsset.mult(numeraireAtEvaluationTime).add(amountOfUderlyingAsset.mult(underlyingAtEvaluationTime));
        return portfolioValue;
    }

    private RandomVariableInterface[] getBasisFunctions(RandomVariableInterface underlying) {
        double[] discretization;
        double min = underlying.getMin();
        double max = underlying.getMax();
        ArrayList<RandomVariableInterface> basisFunctionList = new ArrayList<RandomVariableInterface>();
        for (double discretizationStep : discretization = new TimeDiscretization(min, this.numberOfBins, (max - min) / (double)this.numberOfBins).getAsDoubleArray()) {
            RandomVariableInterface indicator = underlying.barrier(underlying.sub(discretizationStep), (RandomVariableInterface)new RandomVariable(1.0), 0.0);
            basisFunctionList.add(indicator);
        }
        return basisFunctionList.toArray(new RandomVariableInterface[0]);
    }
}

