/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.assetderivativevaluation.products;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationInterface;
import net.finmath.montecarlo.assetderivativevaluation.products.AbstractAssetMonteCarloProduct;
import net.finmath.stochastic.RandomVariableInterface;

public class EuropeanOption
extends AbstractAssetMonteCarloProduct {
    private final double maturity;
    private final double strike;
    private final Integer underlyingIndex;
    private final String nameOfUnderliyng;

    public EuropeanOption(double maturity, double strike, int underlyingIndex) {
        this.maturity = maturity;
        this.strike = strike;
        this.underlyingIndex = underlyingIndex;
        this.nameOfUnderliyng = null;
    }

    public EuropeanOption(double maturity, double strike) {
        this(maturity, strike, 0);
    }

    @Override
    public RandomVariableInterface getValue(double evaluationTime, AssetModelMonteCarloSimulationInterface model) throws CalculationException {
        RandomVariableInterface underlyingAtMaturity = model.getAssetValue(this.maturity, (int)this.underlyingIndex);
        RandomVariableInterface values = underlyingAtMaturity.sub(this.strike).floor(0.0);
        RandomVariableInterface numeraireAtMaturity = model.getNumeraire(this.maturity);
        RandomVariableInterface monteCarloWeights = model.getMonteCarloWeights(this.maturity);
        values = values.div(numeraireAtMaturity).mult(monteCarloWeights);
        RandomVariableInterface numeraireAtEvalTime = model.getNumeraire(evaluationTime);
        RandomVariableInterface monteCarloProbabilitiesAtEvalTime = model.getMonteCarloWeights(evaluationTime);
        values = values.mult(numeraireAtEvalTime).div(monteCarloProbabilitiesAtEvalTime);
        return values;
    }
}

