/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.RandomVariable;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class CorrelatedBrownianMotion
implements BrownianMotionInterface {
    private BrownianMotionInterface uncollelatedFactors;
    private double[][] factorLoadings;

    public CorrelatedBrownianMotion(BrownianMotionInterface uncollelatedFactors, double[][] factorLoadings) {
        this.uncollelatedFactors = uncollelatedFactors;
        this.factorLoadings = factorLoadings;
    }

    @Override
    public RandomVariableInterface getBrownianIncrement(int timeIndex, int factor) {
        RandomVariableInterface brownianIncrement = new RandomVariable(0.0);
        for (int factorIndex = 0; factorIndex < this.factorLoadings[factor].length; ++factorIndex) {
            if (this.factorLoadings[factor][factorIndex] == 0.0) continue;
            RandomVariableInterface independentFactor = this.uncollelatedFactors.getBrownianIncrement(timeIndex, factorIndex);
            brownianIncrement = brownianIncrement.addProduct(independentFactor, this.factorLoadings[factor][factorIndex]);
        }
        return brownianIncrement;
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.uncollelatedFactors.getTimeDiscretization();
    }

    @Override
    public int getNumberOfFactors() {
        return this.factorLoadings.length;
    }

    @Override
    public int getNumberOfPaths() {
        return this.uncollelatedFactors.getNumberOfPaths();
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.uncollelatedFactors.getRandomVariableForConstant(value);
    }

    @Override
    public BrownianMotionInterface getCloneWithModifiedSeed(int seed) {
        return new CorrelatedBrownianMotion(this.uncollelatedFactors.getCloneWithModifiedSeed(seed), this.factorLoadings);
    }

    @Override
    public BrownianMotionInterface getCloneWithModifiedTimeDiscretization(TimeDiscretizationInterface newTimeDiscretization) {
        return new CorrelatedBrownianMotion(this.uncollelatedFactors.getCloneWithModifiedTimeDiscretization(newTimeDiscretization), this.factorLoadings);
    }

    @Override
    public RandomVariableInterface getIncrement(int timeIndex, int factor) {
        return this.getBrownianIncrement(timeIndex, factor);
    }
}

