/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo;

import java.util.Arrays;
import net.finmath.montecarlo.AbstractRandomVariableFactory;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionInterface;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.stochastic.RandomVariableInterface;
import net.finmath.time.TimeDiscretizationInterface;

public class BrownianBridge
implements BrownianMotionInterface {
    private final TimeDiscretizationInterface timeDiscretization;
    private final int numberOfFactors;
    private final int numberOfPaths;
    private final int seed;
    private RandomVariableInterface[] start;
    private RandomVariableInterface[] end;
    private AbstractRandomVariableFactory randomVariableFactory = new RandomVariableFactory();
    private transient RandomVariableInterface[][] brownianIncrements;
    private final Object brownianIncrementsLazyInitLock = new Object();

    public BrownianBridge(TimeDiscretizationInterface timeDiscretization, int numberOfPaths, int seed, RandomVariableInterface[] start, RandomVariableInterface[] end) {
        this.timeDiscretization = timeDiscretization;
        this.numberOfFactors = start.length;
        this.numberOfPaths = numberOfPaths;
        this.seed = seed;
        this.start = start;
        this.end = end;
    }

    public BrownianBridge(TimeDiscretizationInterface timeDiscretization, int numberOfPaths, int seed, RandomVariableInterface start, RandomVariableInterface end) {
        this(timeDiscretization, numberOfPaths, seed, new RandomVariableInterface[]{start}, new RandomVariableInterface[]{end});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariableInterface getBrownianIncrement(int timeIndex, int factor) {
        Object object = this.brownianIncrementsLazyInitLock;
        synchronized (object) {
            if (this.brownianIncrements == null) {
                this.doGenerateBrownianMotion();
            }
        }
        return this.brownianIncrements[timeIndex][factor];
    }

    private void doGenerateBrownianMotion() {
        if (this.brownianIncrements != null) {
            return;
        }
        BrownianMotion generator = new BrownianMotion(this.timeDiscretization, this.numberOfFactors, this.numberOfPaths, this.seed);
        this.brownianIncrements = new RandomVariableInterface[generator.getTimeDiscretization().getNumberOfTimeSteps()][generator.getNumberOfFactors()];
        double endTime = this.getTimeDiscretization().getTime(this.getTimeDiscretization().getNumberOfTimeSteps());
        for (int factor = 0; factor < generator.getNumberOfFactors(); ++factor) {
            RandomVariableInterface endOfFactor = this.end[factor];
            RandomVariableInterface brownianBridge = this.start[factor];
            for (int timeIndex = 0; timeIndex < this.getTimeDiscretization().getNumberOfTimeSteps(); ++timeIndex) {
                double currentTime = this.getTimeDiscretization().getTime(timeIndex);
                double nextTime = this.getTimeDiscretization().getTime(timeIndex + 1);
                double alpha = (nextTime - currentTime) / (endTime - currentTime);
                RandomVariableInterface nextRealization = brownianBridge.mult(1.0 - alpha).add(endOfFactor.mult(alpha)).add(generator.getBrownianIncrement(timeIndex, factor).mult(Math.sqrt(1.0 - alpha)));
                this.brownianIncrements[timeIndex][factor] = nextRealization.sub(brownianBridge);
                brownianBridge = nextRealization;
            }
        }
    }

    @Override
    public TimeDiscretizationInterface getTimeDiscretization() {
        return this.timeDiscretization;
    }

    @Override
    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }

    @Override
    public int getNumberOfPaths() {
        return this.numberOfPaths;
    }

    @Override
    public RandomVariableInterface getRandomVariableForConstant(double value) {
        return this.randomVariableFactory.createRandomVariable(value);
    }

    @Override
    public BrownianMotionInterface getCloneWithModifiedSeed(int seed) {
        return new BrownianBridge(this.timeDiscretization, this.numberOfPaths, seed, this.start, this.end);
    }

    @Override
    public BrownianMotionInterface getCloneWithModifiedTimeDiscretization(TimeDiscretizationInterface newTimeDiscretization) {
        return new BrownianBridge(newTimeDiscretization, this.getNumberOfFactors(), this.seed, this.start, this.end);
    }

    @Override
    public RandomVariableInterface getIncrement(int timeIndex, int factor) {
        return this.getBrownianIncrement(timeIndex, factor);
    }

    public String toString() {
        return "BrownianBridge [timeDiscretization=" + this.timeDiscretization + ", numberOfFactors=" + this.numberOfFactors + ", numberOfPaths=" + this.numberOfPaths + ", seed=" + this.seed + ", start=" + Arrays.toString(this.start) + ", end=" + Arrays.toString(this.end) + "]";
    }
}

