/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProductInterface;
import net.finmath.time.ScheduleInterface;

public class SwapLegWithResetting
extends AbstractAnalyticProduct
implements AnalyticProductInterface {
    private final ScheduleInterface legSchedule;
    private final String forwardCurveName;
    private final double spread;
    private final String discountCurveName;
    private final String discountCurveForNotionalResetName;
    private boolean isNotionalExchanged = false;

    public SwapLegWithResetting(ScheduleInterface legSchedule, String forwardCurveName, double spread, String discountCurveName, String discountCurveForNotionalResetName, boolean isNotionalExchanged) {
        this.legSchedule = legSchedule;
        this.forwardCurveName = forwardCurveName;
        this.spread = spread;
        this.discountCurveName = discountCurveName;
        this.discountCurveForNotionalResetName = discountCurveForNotionalResetName;
        this.isNotionalExchanged = isNotionalExchanged;
    }

    public SwapLegWithResetting(ScheduleInterface legSchedule, String forwardCurveName, double spread, String discountCurveName, String discountCurveForNotionalResetName) {
        this(legSchedule, forwardCurveName, spread, discountCurveName, discountCurveForNotionalResetName, true);
    }

    @Override
    public double getValue(double evaluationTime, AnalyticModelInterface model) {
        ForwardCurveInterface forwardCurve = model.getForwardCurve(this.forwardCurveName);
        DiscountCurveInterface discountCurve = model.getDiscountCurve(this.discountCurveName);
        DiscountCurveInterface discountCurveForNotionalReset = model.getDiscountCurve(this.discountCurveForNotionalResetName);
        DiscountCurveInterface discountCurveForForward = null;
        if (forwardCurve == null && this.forwardCurveName != null && this.forwardCurveName.length() > 0 && (discountCurveForForward = model.getDiscountCurve(this.forwardCurveName)) == null) {
            throw new IllegalArgumentException("No curve of the name " + this.forwardCurveName + " was found in the model.");
        }
        double value = 0.0;
        for (int periodIndex = 0; periodIndex < this.legSchedule.getNumberOfPeriods(); ++periodIndex) {
            double fixingDate = this.legSchedule.getFixing(periodIndex);
            double paymentDate = this.legSchedule.getPayment(periodIndex);
            double periodLength = this.legSchedule.getPeriodLength(periodIndex);
            if (periodLength == 0.0) continue;
            double forward = this.spread;
            if (forwardCurve != null) {
                forward += forwardCurve.getForward(model, fixingDate, paymentDate - fixingDate);
            } else if (discountCurveForForward != null && fixingDate != paymentDate) {
                forward += (discountCurveForForward.getDiscountFactor(fixingDate) / discountCurveForForward.getDiscountFactor(paymentDate) - 1.0) / (paymentDate - fixingDate);
            }
            if (discountCurve == null) {
                throw new IllegalArgumentException("No curve of the name " + this.discountCurveName + " was found in the model.");
            }
            double periodStart = this.legSchedule.getPeriodStart(periodIndex);
            double notional = discountCurveForNotionalReset.getDiscountFactor(model, periodStart) / discountCurve.getDiscountFactor(model, periodStart);
            double discountFactor = paymentDate > evaluationTime ? discountCurve.getDiscountFactor(model, paymentDate) : 0.0;
            value += notional * forward * periodLength * discountFactor;
            if (!this.isNotionalExchanged) continue;
            double periodEnd = this.legSchedule.getPeriodEnd(periodIndex);
            value += periodEnd > evaluationTime ? notional * discountCurve.getDiscountFactor(model, periodEnd) : 0.0;
            value -= periodStart > evaluationTime ? notional * discountCurve.getDiscountFactor(model, periodStart) : 0.0;
        }
        return value / discountCurve.getDiscountFactor(model, evaluationTime);
    }

    public ScheduleInterface getSchedule() {
        return this.legSchedule;
    }

    public String getForwardCurveName() {
        return this.forwardCurveName;
    }

    public double getSpread() {
        return this.spread;
    }

    public String getDiscountCurveName() {
        return this.discountCurveName;
    }

    public boolean isNotionalExchanged() {
        return this.isNotionalExchanged;
    }

    public String toString() {
        return "SwapLeg [legSchedule=" + this.legSchedule + ", forwardCurveName=" + this.forwardCurveName + ", spread=" + this.spread + ", discountCurveName=" + this.discountCurveName + ", isNotionalExchanged=" + this.isNotionalExchanged + "]";
    }
}

