/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProductInterface;

public class Forward
extends AbstractAnalyticProduct
implements AnalyticProductInterface {
    private final double maturity;
    private final double paymentOffset;
    private final String forwardCurveName;
    private final double spread;
    private final String discountCurveName;

    public Forward(double maturity, double paymentOffset, String forwardCurveName, double spread, String discountCurveName) {
        this.maturity = maturity;
        this.paymentOffset = paymentOffset;
        this.forwardCurveName = forwardCurveName;
        this.spread = spread;
        this.discountCurveName = discountCurveName;
    }

    @Override
    public double getValue(double evaluationTime, AnalyticModelInterface model) {
        ForwardCurveInterface forwardCurve = model.getForwardCurve(this.forwardCurveName);
        DiscountCurveInterface discountCurve = model.getDiscountCurve(this.discountCurveName);
        DiscountCurveInterface discountCurveForForward = null;
        if (forwardCurve == null && this.forwardCurveName != null && this.forwardCurveName.length() > 0 && (discountCurveForForward = model.getDiscountCurve(this.forwardCurveName)) == null) {
            throw new IllegalArgumentException("No curve of the name " + this.forwardCurveName + " was found in the model.");
        }
        double forward = this.spread;
        if (forwardCurve != null) {
            forward += forwardCurve.getForward(model, this.maturity);
        } else if (discountCurveForForward != null) {
            forward += (discountCurveForForward.getDiscountFactor(this.maturity) / discountCurveForForward.getDiscountFactor(this.maturity + this.paymentOffset) - 1.0) / this.paymentOffset;
        }
        double discountFactor = this.maturity + this.paymentOffset > evaluationTime ? discountCurve.getDiscountFactor(model, this.maturity + this.paymentOffset) : 0.0;
        return forward * discountFactor / discountCurve.getDiscountFactor(model, evaluationTime);
    }
}

