/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.time.LocalDate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarInterface;

public abstract class AbstractForwardCurve
extends Curve
implements ForwardCurveInterface {
    private static final long serialVersionUID = 3735595267579329042L;
    protected final String discountCurveName;
    private final Map<Double, Double> paymentOffsets = new ConcurrentHashMap<Double, Double>();
    protected final String paymentOffsetCode;
    protected final BusinessdayCalendarInterface paymentBusinessdayCalendar;
    protected final BusinessdayCalendarInterface.DateRollConvention paymentDateRollConvention;
    private final double paymentOffset;

    public AbstractForwardCurve(String name, LocalDate referenceDate, String paymentOffsetCode, BusinessdayCalendarInterface paymentBusinessdayCalendar, BusinessdayCalendarInterface.DateRollConvention paymentDateRollConvention, Curve.InterpolationMethod interpolationMethod, Curve.ExtrapolationMethod extrapolationMethod, Curve.InterpolationEntity interpolationEntity, String discountCurveName) {
        super(name, referenceDate, interpolationMethod, extrapolationMethod, interpolationEntity);
        this.paymentOffsetCode = paymentOffsetCode;
        this.paymentBusinessdayCalendar = paymentBusinessdayCalendar;
        this.paymentDateRollConvention = paymentDateRollConvention;
        this.paymentOffset = Double.NaN;
        this.discountCurveName = discountCurveName;
    }

    public AbstractForwardCurve(String name, LocalDate referenceDate, String paymentOffsetCode, BusinessdayCalendarInterface paymentBusinessdayCalendar, BusinessdayCalendarInterface.DateRollConvention paymentDateRollConvention, String discountCurveName) {
        this(name, referenceDate, paymentOffsetCode, paymentBusinessdayCalendar, paymentDateRollConvention, Curve.InterpolationMethod.LINEAR, Curve.ExtrapolationMethod.CONSTANT, Curve.InterpolationEntity.VALUE, discountCurveName);
    }

    public AbstractForwardCurve(String name, LocalDate referenceDate, double paymentOffset, String discountCurveName) {
        super(name, referenceDate, Curve.InterpolationMethod.LINEAR, Curve.ExtrapolationMethod.CONSTANT, Curve.InterpolationEntity.VALUE);
        this.paymentOffset = paymentOffset;
        this.discountCurveName = discountCurveName;
        this.paymentOffsetCode = null;
        this.paymentBusinessdayCalendar = null;
        this.paymentDateRollConvention = null;
    }

    @Override
    public String getDiscountCurveName() {
        return this.discountCurveName;
    }

    @Override
    public double getPaymentOffset(double fixingTime) {
        if (this.paymentOffsetCode == null) {
            return this.paymentOffset;
        }
        if (this.paymentOffsets.containsKey(fixingTime)) {
            return this.paymentOffsets.get(fixingTime);
        }
        LocalDate referenceDate = this.getReferenceDate();
        LocalDate fixingDate = FloatingpointDate.getDateFromFloatingPointDate(referenceDate, fixingTime);
        LocalDate paymentDate = this.paymentBusinessdayCalendar.getAdjustedDate(fixingDate, this.paymentOffsetCode, this.paymentDateRollConvention);
        double paymentTime = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, paymentDate);
        this.paymentOffsets.put(fixingTime, paymentTime - fixingTime);
        return paymentTime - fixingTime;
    }

    public double[] getForwards(AnalyticModelInterface model, double[] fixingTimes) {
        double[] values = new double[fixingTimes.length];
        for (int i = 0; i < fixingTimes.length; ++i) {
            values[i] = this.getForward(model, fixingTimes[i]);
        }
        return values;
    }

    @Override
    public String toString() {
        return "AbstractForwardCurve [" + super.toString() + ", discountCurveName=" + this.discountCurveName + ", paymentOffsetCode=" + this.paymentOffsetCode + ", paymentBusinessdayCalendar=" + this.paymentBusinessdayCalendar + ", paymentDateRollConvention=" + (Object)((Object)this.paymentDateRollConvention) + "]";
    }
}

