/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.calibration;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.finmath.marketdata.calibration.ParameterAggregation;
import net.finmath.marketdata.calibration.ParameterObjectInterface;
import net.finmath.marketdata.calibration.ParameterTransformation;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.products.AnalyticProductInterface;
import net.finmath.optimizer.OptimizerFactoryInterface;
import net.finmath.optimizer.OptimizerFactoryLevenbergMarquardt;
import net.finmath.optimizer.OptimizerInterface;
import net.finmath.optimizer.SolverException;

public class Solver {
    private final AnalyticModelInterface model;
    private final List<AnalyticProductInterface> calibrationProducts;
    private final List<Double> calibrationTargetValues;
    private final double calibrationAccuracy;
    private final ParameterTransformation parameterTransformation;
    private OptimizerFactoryInterface optimizerFactory;
    private final double evaluationTime;
    private final int maxIterations = 1000;
    private int iterations = 0;
    private double accuracy = Double.POSITIVE_INFINITY;

    public Solver(AnalyticModelInterface model, Vector<AnalyticProductInterface> calibrationProducts, List<Double> calibrationTargetValues, ParameterTransformation parameterTransformation, double evaluationTime, OptimizerFactoryInterface optimizerFactory) {
        this.model = model;
        this.calibrationProducts = calibrationProducts;
        this.calibrationTargetValues = calibrationTargetValues;
        this.parameterTransformation = parameterTransformation;
        this.evaluationTime = evaluationTime;
        this.optimizerFactory = optimizerFactory;
        this.calibrationAccuracy = 0.0;
    }

    public Solver(AnalyticModelInterface model, Vector<AnalyticProductInterface> calibrationProducts, List<Double> calibrationTargetValues, ParameterTransformation parameterTransformation, double evaluationTime, double calibrationAccuracy) {
        this.model = model;
        this.calibrationProducts = calibrationProducts;
        this.calibrationTargetValues = calibrationTargetValues;
        this.parameterTransformation = parameterTransformation;
        this.evaluationTime = evaluationTime;
        this.calibrationAccuracy = calibrationAccuracy;
        this.optimizerFactory = null;
    }

    public Solver(AnalyticModelInterface model, Vector<AnalyticProductInterface> calibrationProducts, List<Double> calibrationTargetValues, double evaluationTime, double calibrationAccuracy) {
        this(model, calibrationProducts, calibrationTargetValues, null, evaluationTime, calibrationAccuracy);
    }

    public Solver(AnalyticModelInterface model, Vector<AnalyticProductInterface> calibrationProducts, double evaluationTime, double calibrationAccuracy) {
        this(model, calibrationProducts, null, null, evaluationTime, calibrationAccuracy);
    }

    public Solver(AnalyticModelInterface model, Vector<AnalyticProductInterface> calibrationProducts) {
        this(model, calibrationProducts, 0.0, 0.0);
    }

    public AnalyticModelInterface getCalibratedModel(Set<ParameterObjectInterface> objectsToCalibrate) throws SolverException {
        final ParameterAggregation<ParameterObjectInterface> parameterAggregate = new ParameterAggregation<ParameterObjectInterface>(objectsToCalibrate);
        double[] initialParameters = this.parameterTransformation != null ? this.parameterTransformation.getSolverParameter(parameterAggregate.getParameter()) : parameterAggregate.getParameter();
        double[] zeros = new double[this.calibrationProducts.size()];
        double[] ones = new double[this.calibrationProducts.size()];
        double[] lowerBound = new double[initialParameters.length];
        double[] upperBound = new double[initialParameters.length];
        Arrays.fill(zeros, 0.0);
        Arrays.fill(ones, 1.0);
        Arrays.fill(lowerBound, Double.NEGATIVE_INFINITY);
        Arrays.fill(upperBound, Double.POSITIVE_INFINITY);
        OptimizerInterface.ObjectiveFunction objectiveFunction = new OptimizerInterface.ObjectiveFunction(){

            @Override
            public void setValues(double[] parameters, double[] values) throws SolverException {
                double[] modelParameters = parameters;
                try {
                    int i;
                    if (Solver.this.parameterTransformation != null) {
                        modelParameters = Solver.this.parameterTransformation.getParameter(parameters);
                        System.arraycopy(Solver.this.parameterTransformation.getSolverParameter(modelParameters), 0, parameters, 0, parameters.length);
                    }
                    Map<ParameterObjectInterface, double[]> curvesParameterPairs = parameterAggregate.getObjectsToModifyForParameter(modelParameters);
                    AnalyticModelInterface modelClone = Solver.this.model.getCloneForParameter(curvesParameterPairs);
                    for (i = 0; i < Solver.this.calibrationProducts.size(); ++i) {
                        values[i] = ((AnalyticProductInterface)Solver.this.calibrationProducts.get(i)).getValue(Solver.this.evaluationTime, modelClone);
                    }
                    if (Solver.this.calibrationTargetValues != null) {
                        for (i = 0; i < Solver.this.calibrationTargetValues.size(); ++i) {
                            int n = i;
                            values[n] = values[n] - (Double)Solver.this.calibrationTargetValues.get(i);
                        }
                    }
                }
                catch (CloneNotSupportedException e) {
                    throw new SolverException(e);
                }
            }
        };
        if (this.optimizerFactory == null) {
            int maxThreads = Math.min(2 * Math.max(Runtime.getRuntime().availableProcessors(), 1), initialParameters.length);
            this.optimizerFactory = new OptimizerFactoryLevenbergMarquardt(1000, this.calibrationAccuracy, maxThreads);
        }
        OptimizerInterface optimizer = this.optimizerFactory.getOptimizer(objectiveFunction, initialParameters, lowerBound, upperBound, zeros);
        optimizer.run();
        this.iterations = optimizer.getIterations();
        double[] bestParameters = optimizer.getBestFitParameters();
        if (this.parameterTransformation != null) {
            bestParameters = this.parameterTransformation.getParameter(bestParameters);
        }
        AnalyticModelInterface calibratedModel = null;
        try {
            Map<ParameterObjectInterface, double[]> curvesParameterPairs = parameterAggregate.getObjectsToModifyForParameter(bestParameters);
            calibratedModel = this.model.getCloneForParameter(curvesParameterPairs);
        }
        catch (CloneNotSupportedException e) {
            throw new SolverException(e);
        }
        this.accuracy = 0.0;
        for (int i = 0; i < this.calibrationProducts.size(); ++i) {
            double error = this.calibrationProducts.get(i).getValue(this.evaluationTime, calibratedModel);
            if (this.calibrationTargetValues != null) {
                error -= this.calibrationTargetValues.get(i).doubleValue();
            }
            this.accuracy += error * error;
        }
        this.accuracy = Math.sqrt(this.accuracy / (double)this.calibrationProducts.size());
        return calibratedModel;
    }

    public int getIterations() {
        return this.iterations;
    }

    public double getAccuracy() {
        return this.accuracy;
    }
}

