/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.calibration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.finmath.marketdata.calibration.ParameterObjectInterface;
import net.finmath.marketdata.calibration.Solver;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.AnalyticModelInterface;
import net.finmath.marketdata.model.curves.CurveInterface;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterface;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurveFromDiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurveInterface;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProductInterface;
import net.finmath.marketdata.products.Deposit;
import net.finmath.marketdata.products.ForwardRateAgreement;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapLeg;
import net.finmath.marketdata.products.SwapLegWithResetting;
import net.finmath.optimizer.SolverException;
import net.finmath.time.RegularSchedule;
import net.finmath.time.ScheduleInterface;
import net.finmath.time.TimeDiscretization;

public class CalibratedCurves {
    private static final boolean isUseForwardCurve = Boolean.parseBoolean(System.getProperty("net.finmath.marketdata.calibration.CalibratedCurves.isUseForwardCurve", "true"));
    private static final boolean isCreateDefaultCurvesForMissingCurves = Boolean.parseBoolean(System.getProperty("net.finmath.marketdata.calibration.CalibratedCurves.isCreateDefaultCurvesForMissingCurves", "false"));
    private AnalyticModelInterface model = new AnalyticModel();
    private Set<ParameterObjectInterface> objectsToCalibrate = new LinkedHashSet<ParameterObjectInterface>();
    private Vector<AnalyticProductInterface> calibrationProducts = new Vector();
    private Vector<String> calibrationProductsSymbols = new Vector();
    private List<CalibrationSpec> calibrationSpecs = new ArrayList<CalibrationSpec>();
    private final double evaluationTime;
    private final double calibrationAccuracy;
    private int lastNumberOfInterations;
    private double lastAccuracy;

    public CalibratedCurves(List<CalibrationSpec> calibrationSpecs, AnalyticModelInterface calibrationModel, double evaluationTime, double calibrationAccuracy) throws SolverException, CloneNotSupportedException {
        if (calibrationModel != null) {
            this.model = calibrationModel.getCloneForParameter(null);
        }
        this.evaluationTime = evaluationTime;
        this.calibrationAccuracy = calibrationAccuracy;
        for (CalibrationSpec calibrationSpec : calibrationSpecs) {
            this.add(calibrationSpec);
        }
        this.lastNumberOfInterations = this.calibrate(calibrationAccuracy);
    }

    public CalibratedCurves(CalibrationSpec[] calibrationSpecs, AnalyticModel calibrationModel, double evaluationTime, double calibrationAccuracy) throws SolverException, CloneNotSupportedException {
        if (calibrationModel != null) {
            this.model = calibrationModel.getCloneForParameter(null);
        }
        this.evaluationTime = evaluationTime;
        this.calibrationAccuracy = calibrationAccuracy;
        for (CalibrationSpec calibrationSpec : calibrationSpecs) {
            this.add(calibrationSpec);
        }
        this.lastNumberOfInterations = this.calibrate(calibrationAccuracy);
    }

    public CalibratedCurves(CalibrationSpec[] calibrationSpecs, AnalyticModel calibrationModel, double calibrationAccuracy) throws SolverException, CloneNotSupportedException {
        this(calibrationSpecs, calibrationModel, 0.0, calibrationAccuracy);
    }

    public CalibratedCurves(CalibrationSpec[] calibrationSpecs, AnalyticModel calibrationModel) throws SolverException, CloneNotSupportedException {
        this(calibrationSpecs, calibrationModel, 0.0);
    }

    public CalibratedCurves(Collection<CalibrationSpec> calibrationSpecs) throws SolverException, CloneNotSupportedException {
        this(calibrationSpecs.toArray(new CalibrationSpec[calibrationSpecs.size()]), null);
    }

    public CalibratedCurves(CalibrationSpec[] calibrationSpecs) throws SolverException, CloneNotSupportedException {
        this(calibrationSpecs, null, 0.0);
    }

    public AnalyticProductInterface getCalibrationProductForSpec(CalibrationSpec calibrationSpec) {
        String forwardCurveReceiverName = calibrationSpec.forwardCurveReceiverName;
        String forwardCurvePayerName = calibrationSpec.forwardCurvePayerName;
        if (isCreateDefaultCurvesForMissingCurves) {
            this.createDiscountCurve(calibrationSpec.discountCurveReceiverName);
            this.createDiscountCurve(calibrationSpec.discountCurvePayerName);
            forwardCurveReceiverName = this.createForwardCurve(calibrationSpec.swapTenorDefinitionReceiver, calibrationSpec.forwardCurveReceiverName);
            forwardCurvePayerName = this.createForwardCurve(calibrationSpec.swapTenorDefinitionPayer, calibrationSpec.forwardCurvePayerName);
        } else {
            Predicate<String> discountCurveMissing = curveName -> curveName != null && curveName.length() > 0 && this.model.getDiscountCurve((String)curveName) == null;
            Predicate<String> forwardCurveMissing = curveName -> curveName != null && curveName.length() > 0 && this.model.getForwardCurve((String)curveName) == null;
            if (discountCurveMissing.test(calibrationSpec.discountCurveReceiverName)) {
                throw new IllegalArgumentException("Discount curve " + calibrationSpec.discountCurveReceiverName + " missing. Needs to be part of model " + this.model + ".");
            }
            if (discountCurveMissing.test(calibrationSpec.discountCurvePayerName)) {
                throw new IllegalArgumentException("Discount curve " + calibrationSpec.discountCurvePayerName + " missing. Needs to be part of model " + this.model + ".");
            }
            if (forwardCurveMissing.test(calibrationSpec.forwardCurveReceiverName)) {
                throw new IllegalArgumentException("Forward curve " + calibrationSpec.forwardCurveReceiverName + " missing. Needs to be part of model " + this.model + ".");
            }
            if (forwardCurveMissing.test(calibrationSpec.forwardCurvePayerName)) {
                throw new IllegalArgumentException("Forward curve " + calibrationSpec.forwardCurvePayerName + " missing. Needs to be part of model " + this.model + ".");
            }
        }
        ScheduleInterface tenorReceiver = calibrationSpec.swapTenorDefinitionReceiver;
        ScheduleInterface tenorPayer = calibrationSpec.swapTenorDefinitionPayer;
        AbstractAnalyticProduct product = null;
        if (calibrationSpec.type.toLowerCase().equals("deposit")) {
            product = new Deposit(tenorReceiver, calibrationSpec.spreadReceiver, calibrationSpec.discountCurveReceiverName);
        } else if (calibrationSpec.type.toLowerCase().equals("fra")) {
            product = new ForwardRateAgreement(tenorReceiver, calibrationSpec.spreadReceiver, forwardCurveReceiverName, calibrationSpec.discountCurveReceiverName);
        } else if (calibrationSpec.type.toLowerCase().equals("future")) {
            product = new ForwardRateAgreement(calibrationSpec.swapTenorDefinitionReceiver, 1.0 - calibrationSpec.spreadReceiver / 100.0, forwardCurveReceiverName, calibrationSpec.discountCurveReceiverName);
        } else if (calibrationSpec.type.toLowerCase().equals("swapleg")) {
            product = new SwapLeg(tenorReceiver, forwardCurveReceiverName, calibrationSpec.spreadReceiver, calibrationSpec.discountCurveReceiverName, true);
        } else if (calibrationSpec.type.toLowerCase().equals("swap")) {
            SwapLeg legReceiver = new SwapLeg(tenorReceiver, forwardCurveReceiverName, calibrationSpec.spreadReceiver, calibrationSpec.discountCurveReceiverName, true);
            SwapLeg legPayer = new SwapLeg(tenorPayer, forwardCurvePayerName, calibrationSpec.spreadPayer, calibrationSpec.discountCurvePayerName, true);
            product = new Swap(legReceiver, legPayer);
        } else if (calibrationSpec.type.toLowerCase().equals("swapwithresetonreceiver")) {
            String discountCurveForNotionalResetName = calibrationSpec.discountCurvePayerName;
            SwapLegWithResetting legReceiver = new SwapLegWithResetting(tenorReceiver, forwardCurveReceiverName, calibrationSpec.spreadReceiver, calibrationSpec.discountCurveReceiverName, discountCurveForNotionalResetName, true);
            SwapLeg legPayer = new SwapLeg(tenorPayer, forwardCurvePayerName, calibrationSpec.spreadPayer, calibrationSpec.discountCurvePayerName, true);
            product = new Swap(legReceiver, legPayer);
        } else if (calibrationSpec.type.toLowerCase().equals("swapwithresetonpayer")) {
            String discountCurveForNotionalResetName = calibrationSpec.discountCurveReceiverName;
            SwapLeg legReceiver = new SwapLeg(tenorReceiver, forwardCurveReceiverName, calibrationSpec.spreadReceiver, calibrationSpec.discountCurveReceiverName, true);
            SwapLegWithResetting legPayer = new SwapLegWithResetting(tenorPayer, forwardCurvePayerName, calibrationSpec.spreadPayer, calibrationSpec.discountCurvePayerName, discountCurveForNotionalResetName, true);
            product = new Swap(legReceiver, legPayer);
        } else {
            throw new RuntimeException("Product of type " + calibrationSpec.type + " unknown.");
        }
        return product;
    }

    public AnalyticModelInterface getModel() {
        return this.model;
    }

    public CurveInterface getCurve(String name) {
        return this.model.getCurve(name);
    }

    public int getLastNumberOfInterations() {
        return this.lastNumberOfInterations;
    }

    public CalibratedCurves getCloneShifted(String symbol, double shift) throws SolverException, CloneNotSupportedException {
        ArrayList<CalibrationSpec> calibrationSpecsShifted = new ArrayList<CalibrationSpec>();
        for (CalibrationSpec calibrationSpec : this.calibrationSpecs) {
            if (calibrationSpec.symbol.equals(symbol)) {
                calibrationSpecsShifted.add(calibrationSpec.getCloneShifted(shift));
                continue;
            }
            calibrationSpecsShifted.add(calibrationSpec);
        }
        return new CalibratedCurves(calibrationSpecsShifted, this.model, this.evaluationTime, this.calibrationAccuracy);
    }

    public CalibratedCurves getCloneShifted(Map<String, Double> shifts) throws SolverException, CloneNotSupportedException {
        ArrayList<CalibrationSpec> calibrationSpecsShifted = new ArrayList<CalibrationSpec>();
        for (CalibrationSpec calibrationSpec : this.calibrationSpecs) {
            if (shifts.containsKey(calibrationSpec)) {
                calibrationSpecsShifted.add(calibrationSpec.getCloneShifted(shifts.get(calibrationSpec)));
                continue;
            }
            calibrationSpecsShifted.add(calibrationSpec);
        }
        return new CalibratedCurves(calibrationSpecsShifted, this.model, this.evaluationTime, this.calibrationAccuracy);
    }

    public CalibratedCurves getCloneShifted(Pattern symbolRegExp, double shift) throws SolverException, CloneNotSupportedException {
        ArrayList<CalibrationSpec> calibrationSpecsShifted = new ArrayList<CalibrationSpec>();
        for (CalibrationSpec calibrationSpec : this.calibrationSpecs) {
            Matcher matcher = symbolRegExp.matcher(calibrationSpec.symbol);
            if (matcher.matches()) {
                calibrationSpecsShifted.add(calibrationSpec.getCloneShifted(shift));
                continue;
            }
            calibrationSpecsShifted.add(calibrationSpec);
        }
        return new CalibratedCurves(calibrationSpecsShifted, this.model, this.evaluationTime, this.calibrationAccuracy);
    }

    public CalibratedCurves getCloneShiftedForRegExp(String symbolRegExp, double shift) throws SolverException, CloneNotSupportedException {
        return this.getCloneShifted(Pattern.compile(symbolRegExp), shift);
    }

    public double getLastAccuracy() {
        return this.lastAccuracy;
    }

    public AnalyticProductInterface getCalibrationProductForSymbol(String symbol) {
        for (int i = 0; i < this.calibrationProductsSymbols.size(); ++i) {
            String calibrationProductSymbol = this.calibrationProductsSymbols.get(i);
            if (!calibrationProductSymbol.equals(symbol)) continue;
            return this.calibrationProducts.get(i);
        }
        return null;
    }

    private int calibrate(double accuracy) throws SolverException {
        Solver solver = new Solver(this.model, this.calibrationProducts, this.evaluationTime, accuracy);
        this.model = solver.getCalibratedModel(this.objectsToCalibrate);
        this.lastAccuracy = solver.getAccuracy();
        return solver.getIterations();
    }

    private String add(CalibrationSpec calibrationSpec) throws CloneNotSupportedException {
        this.calibrationSpecs.add(calibrationSpec);
        this.calibrationProducts.add(this.getCalibrationProductForSpec(calibrationSpec));
        this.calibrationProductsSymbols.add(calibrationSpec.symbol);
        CurveInterface calibrationCurveOld = this.model.getCurve(calibrationSpec.calibrationCurveName);
        if (calibrationCurveOld == null) {
            throw new IllegalArgumentException("Calibration curve " + calibrationSpec.calibrationCurveName + " does not exist. This should not happen. Possible reason: The given calibration product does not depend on the given calibration curve.");
        }
        this.objectsToCalibrate.remove(calibrationCurveOld);
        CurveInterface calibrationCurve = null;
        if (DiscountCurveInterface.class.isInstance(calibrationCurveOld)) {
            double paymentTime = calibrationSpec.swapTenorDefinitionReceiver.getPayment(calibrationSpec.swapTenorDefinitionReceiver.getNumberOfPeriods() - 1);
            calibrationCurve = calibrationCurveOld.getCloneBuilder().addPoint(calibrationSpec.calibrationTime, 1.0, true).build();
        } else {
            calibrationCurve = ForwardCurveInterface.class.isInstance(calibrationCurveOld) ? calibrationCurveOld.getCloneBuilder().addPoint(calibrationSpec.calibrationTime, 0.1, true).build() : calibrationCurveOld.getCloneBuilder().addPoint(calibrationSpec.calibrationTime, 1.0, true).build();
        }
        this.model = this.model.addCurves(calibrationCurve);
        this.objectsToCalibrate.add(calibrationCurve);
        return calibrationSpec.type;
    }

    private DiscountCurveInterface createDiscountCurve(String discountCurveName) {
        DiscountCurveInterface discountCurve = this.model.getDiscountCurve(discountCurveName);
        if (discountCurve == null) {
            discountCurve = DiscountCurve.createDiscountCurveFromDiscountFactors(discountCurveName, new double[]{0.0}, new double[]{1.0});
            this.model = this.model.addCurves(discountCurve);
        }
        return discountCurve;
    }

    private String createForwardCurve(ScheduleInterface swapTenorDefinition, String forwardCurveName) {
        String indexMaturityCode = null;
        if (forwardCurveName.contains("_12M") || forwardCurveName.contains("-12M") || forwardCurveName.contains(" 12M")) {
            indexMaturityCode = "12M";
        }
        if (forwardCurveName.contains("_1M") || forwardCurveName.contains("-1M") || forwardCurveName.contains(" 1M")) {
            indexMaturityCode = "1M";
        }
        if (forwardCurveName.contains("_6M") || forwardCurveName.contains("-6M") || forwardCurveName.contains(" 6M")) {
            indexMaturityCode = "6M";
        }
        if (forwardCurveName.contains("_3M") || forwardCurveName.contains("-3M") || forwardCurveName.contains(" 3M")) {
            indexMaturityCode = "3M";
        }
        if (forwardCurveName == null || forwardCurveName.isEmpty()) {
            return null;
        }
        CurveInterface curve = this.model.getCurve(forwardCurveName);
        CurveInterface forwardCurve = null;
        if (curve == null) {
            if (isUseForwardCurve) {
                curve = new ForwardCurve(forwardCurveName, swapTenorDefinition.getReferenceDate(), indexMaturityCode, ForwardCurve.InterpolationEntityForward.FORWARD, null);
            } else {
                curve = DiscountCurve.createDiscountCurveFromDiscountFactors(forwardCurveName, new double[]{0.0}, new double[]{1.0});
                this.model = this.model.addCurves(curve);
            }
        }
        forwardCurve = DiscountCurveInterface.class.isInstance(curve) ? new ForwardCurveFromDiscountCurve(curve.getName(), swapTenorDefinition.getReferenceDate(), indexMaturityCode) : curve;
        this.model = this.model.addCurves(forwardCurve);
        return forwardCurve.getName();
    }

    public static class CalibrationSpec {
        private String symbol;
        private String type;
        private ScheduleInterface swapTenorDefinitionReceiver;
        private String forwardCurveReceiverName;
        private double spreadReceiver;
        private String discountCurveReceiverName;
        private ScheduleInterface swapTenorDefinitionPayer;
        private String forwardCurvePayerName;
        private double spreadPayer;
        private String discountCurvePayerName;
        private String calibrationCurveName;
        private double calibrationTime;

        public CalibrationSpec(String symbol, String type, ScheduleInterface swapTenorDefinitionReceiver, String forwardCurveReceiverName, double spreadReceiver, String discountCurveReceiverName, ScheduleInterface swapTenorDefinitionPayer, String forwardCurvePayerName, double spreadPayer, String discountCurvePayerName, String calibrationCurveName, double calibrationTime) {
            this.symbol = symbol;
            this.type = type;
            this.swapTenorDefinitionReceiver = swapTenorDefinitionReceiver;
            this.forwardCurveReceiverName = forwardCurveReceiverName;
            this.spreadReceiver = spreadReceiver;
            this.discountCurveReceiverName = discountCurveReceiverName;
            this.swapTenorDefinitionPayer = swapTenorDefinitionPayer;
            this.forwardCurvePayerName = forwardCurvePayerName;
            this.spreadPayer = spreadPayer;
            this.discountCurvePayerName = discountCurvePayerName;
            this.calibrationCurveName = calibrationCurveName;
            this.calibrationTime = calibrationTime;
        }

        public CalibrationSpec(String type, ScheduleInterface swapTenorDefinitionReceiver, String forwardCurveReceiverName, double spreadReceiver, String discountCurveReceiverName, ScheduleInterface swapTenorDefinitionPayer, String forwardCurvePayerName, double spreadPayer, String discountCurvePayerName, String calibrationCurveName, double calibrationTime) {
            this(null, type, swapTenorDefinitionReceiver, forwardCurveReceiverName, spreadReceiver, discountCurveReceiverName, swapTenorDefinitionPayer, forwardCurvePayerName, spreadPayer, discountCurvePayerName, calibrationCurveName, calibrationTime);
        }

        public CalibrationSpec(String type, double[] swapTenorDefinitionReceiver, String forwardCurveReceiverName, double spreadReceiver, String discountCurveReceiverName, double[] swapTenorDefinitionPayer, String forwardCurvePayerName, double spreadPayer, String discountCurvePayerName, String calibrationCurveName, double calibrationTime) {
            this.type = type;
            this.swapTenorDefinitionReceiver = new RegularSchedule(new TimeDiscretization(swapTenorDefinitionReceiver[0], swapTenorDefinitionReceiver[1], swapTenorDefinitionReceiver[2], TimeDiscretization.ShortPeriodLocation.SHORT_PERIOD_AT_START));
            this.forwardCurveReceiverName = forwardCurveReceiverName;
            this.spreadReceiver = spreadReceiver;
            this.discountCurveReceiverName = discountCurveReceiverName;
            this.swapTenorDefinitionPayer = new RegularSchedule(new TimeDiscretization(swapTenorDefinitionPayer[0], swapTenorDefinitionPayer[1], swapTenorDefinitionPayer[2], TimeDiscretization.ShortPeriodLocation.SHORT_PERIOD_AT_START));
            this.forwardCurvePayerName = forwardCurvePayerName;
            this.spreadPayer = spreadPayer;
            this.discountCurvePayerName = discountCurvePayerName;
            this.calibrationCurveName = calibrationCurveName;
            this.calibrationTime = calibrationTime;
        }

        public CalibrationSpec(String type, double[] swapTenorDefinitionReceiver, String forwardCurveReceiverName, double spreadReceiver, String discountCurveReceiverName, String calibrationCurveName, double calibrationTime) {
            this.type = type;
            this.swapTenorDefinitionReceiver = new RegularSchedule(new TimeDiscretization(swapTenorDefinitionReceiver[0], swapTenorDefinitionReceiver[1], swapTenorDefinitionReceiver[2], TimeDiscretization.ShortPeriodLocation.SHORT_PERIOD_AT_START));
            this.forwardCurveReceiverName = forwardCurveReceiverName;
            this.spreadReceiver = spreadReceiver;
            this.discountCurveReceiverName = discountCurveReceiverName;
            this.calibrationCurveName = calibrationCurveName;
            this.calibrationTime = calibrationTime;
        }

        public CalibrationSpec getCloneShifted(double shift) {
            if (this.discountCurvePayerName == null || this.type.toLowerCase().equals("swapleg") || this.type.toLowerCase().equals("deposit") || this.type.toLowerCase().equals("fra")) {
                return new CalibrationSpec(this.symbol, this.type, this.swapTenorDefinitionReceiver, this.forwardCurveReceiverName, this.spreadReceiver + shift, this.discountCurveReceiverName, this.swapTenorDefinitionPayer, this.forwardCurvePayerName, this.spreadPayer, this.discountCurvePayerName, this.calibrationCurveName, this.calibrationTime);
            }
            return new CalibrationSpec(this.symbol, this.type, this.swapTenorDefinitionReceiver, this.forwardCurveReceiverName, this.spreadReceiver, this.discountCurveReceiverName, this.swapTenorDefinitionPayer, this.forwardCurvePayerName, this.spreadPayer + shift, this.discountCurvePayerName, this.calibrationCurveName, this.calibrationTime);
        }

        public String toString() {
            return "CalibrationSpec [symbol=" + this.symbol + ", type=" + this.type + ", swapTenorDefinitionReceiver=" + this.swapTenorDefinitionReceiver + ", forwardCurveReceiverName=" + this.forwardCurveReceiverName + ", spreadReceiver=" + this.spreadReceiver + ", discountCurveReceiverName=" + this.discountCurveReceiverName + ", swapTenorDefinitionPayer=" + this.swapTenorDefinitionPayer + ", forwardCurvePayerName=" + this.forwardCurvePayerName + ", spreadPayer=" + this.spreadPayer + ", discountCurvePayerName=" + this.discountCurvePayerName + ", calibrationCurveName=" + this.calibrationCurveName + ", calibrationTime=" + this.calibrationTime + "]";
        }
    }
}

