/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.integration;

import java.util.function.DoubleUnaryOperator;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import net.finmath.integration.AbstractRealIntegral;
import net.finmath.randomnumbers.MersenneTwister;

public class MonteCarloIntegrator
extends AbstractRealIntegral {
    private int numberOfEvaluationPoints;
    private int seed = 3141;

    public MonteCarloIntegrator(double lowerBound, double upperBound, int numberOfEvaluationPoints, boolean useParallelEvaluation) {
        super(lowerBound, upperBound);
        if (numberOfEvaluationPoints < 3) {
            throw new IllegalArgumentException("Invalid numberOfEvaluationPoints.");
        }
        this.numberOfEvaluationPoints = numberOfEvaluationPoints;
    }

    public MonteCarloIntegrator(double lowerBound, double upperBound, int numberOfEvaluationPoints) {
        this(lowerBound, upperBound, numberOfEvaluationPoints, false);
    }

    @Override
    public double integrate(DoubleUnaryOperator integrand) {
        double lowerBound = this.getLowerBound();
        double upperBound = this.getUpperBound();
        double range = upperBound - lowerBound;
        MersenneTwister mersenneTwister = new MersenneTwister(this.seed);
        DoubleStream randomNumberSequence = IntStream.range(0, this.numberOfEvaluationPoints).sequential().mapToDouble(i -> mersenneTwister.nextDouble());
        return randomNumberSequence.map(x -> integrand.applyAsDouble(lowerBound + x * range)).sum() * range / (double)this.numberOfEvaluationPoints;
    }
}

