/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.models;

import net.finmath.fouriermethod.CharacteristicFunctionInterface;
import net.finmath.fouriermethod.models.ProcessCharacteristicFunctionInterface;
import org.apache.commons.math3.complex.Complex;

public class HestonModel
implements ProcessCharacteristicFunctionInterface {
    private final double initialValue;
    private final double riskFreeRate;
    private final double volatility;
    private final double discountRate;
    private final double theta;
    private final double kappa;
    private final double xi;
    private final double rho;

    public HestonModel(double initialValue, double riskFreeRate, double volatility, double discountRate, double theta, double kappa, double xi, double rho) {
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
        this.discountRate = discountRate;
        this.theta = theta;
        this.kappa = kappa;
        this.xi = xi;
        this.rho = rho;
    }

    public HestonModel(double initialValue, double riskFreeRate, double volatility, double theta, double kappa, double xi, double rho) {
        this(initialValue, riskFreeRate, volatility, riskFreeRate, theta, kappa, xi, rho);
    }

    @Override
    public CharacteristicFunctionInterface apply(final double time) {
        final double alpha = this.theta * this.kappa;
        final double beta = this.kappa;
        final double sigma = this.xi;
        return new CharacteristicFunctionInterface(){

            @Override
            public Complex apply(Complex argument) {
                Complex iargument = argument.multiply(Complex.I);
                Complex gamma = iargument.multiply(HestonModel.this.rho * sigma).subtract(beta).pow(2.0).subtract(iargument.multiply(iargument).add(iargument.multiply(-1)).multiply(0.5).multiply(2.0 * sigma * sigma)).sqrt();
                Complex A = iargument.multiply(HestonModel.this.rho * sigma).subtract(beta).subtract(gamma).multiply(-alpha * time / (sigma * sigma)).subtract(iargument.multiply(HestonModel.this.rho * sigma).subtract(beta).subtract(gamma).multiply(new Complex(1.0).divide(gamma.multiply(time).exp()).subtract(1.0).divide(gamma)).multiply(0.5).add(new Complex(1.0).divide(gamma.multiply(time).exp())).log().add(gamma.multiply(time)).multiply(2.0 * alpha / (sigma * sigma)));
                Complex B = iargument.multiply(iargument).add(iargument.multiply(-1)).multiply(-1).divide(iargument.multiply(HestonModel.this.rho * sigma).subtract(beta).add(gamma.multiply(new Complex(1.0).divide(gamma.multiply(time).exp()).add(1.0).divide(new Complex(1.0).divide(gamma.multiply(time).exp()).subtract(1.0)))));
                return A.add(B.multiply(HestonModel.this.volatility * HestonModel.this.volatility)).add(iargument.multiply(Math.log(HestonModel.this.initialValue) + time * HestonModel.this.riskFreeRate)).add(-HestonModel.this.discountRate * time).exp();
            }
        };
    }
}

