/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.iot.mqtt.core.server.serializer;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.dreamlu.iot.mqtt.core.server.enums.MessageType;
import net.dreamlu.iot.mqtt.core.server.model.Message;
import net.dreamlu.iot.mqtt.core.server.serializer.IMessageSerializer;

public enum DefaultMessageSerializer implements IMessageSerializer
{
    INSTANCE;

    private static final byte[] EMPTY_BYTES;
    private static final byte[] EMPTY_SHORT_BYTES;
    private static final byte[] EMPTY_INT_BYTES;
    private static final byte[] EMPTY_LONG_BYTES;

    @Override
    public byte[] serialize(Message message) {
        if (message == null) {
            return EMPTY_BYTES;
        }
        MessageType messageType = message.getMessageType();
        if (messageType == null) {
            throw new IllegalArgumentException("message type is null.");
        }
        switch (messageType) {
            case CONNECT: 
            case DISCONNECT: {
                return DefaultMessageSerializer.serializeConnect(messageType, message);
            }
            case SUBSCRIBE: {
                return DefaultMessageSerializer.serializeSubscribe(messageType, message);
            }
            case UNSUBSCRIBE: {
                return DefaultMessageSerializer.serializeUnsubscribe(messageType, message);
            }
            case UP_STREAM: {
                return DefaultMessageSerializer.serializeUpStream(messageType, message);
            }
            case DOWN_STREAM: {
                return DefaultMessageSerializer.serializeDownStream(messageType, message);
            }
        }
        throw new IllegalArgumentException("unknown message type: " + (Object)((Object)messageType));
    }

    private static byte[] serializeConnect(MessageType messageType, Message message) {
        int protocolLength = 16;
        String node = message.getNode();
        byte[] nodeBytes = null;
        if (node != null) {
            nodeBytes = node.getBytes(StandardCharsets.UTF_8);
            protocolLength += nodeBytes.length;
        }
        String clientId = message.getClientId();
        byte[] clientIdBytes = null;
        if (clientId != null) {
            clientIdBytes = clientId.getBytes(StandardCharsets.UTF_8);
            protocolLength += clientIdBytes.length;
        }
        String username = message.getUsername();
        byte[] usernameBytes = null;
        if (username != null) {
            usernameBytes = username.getBytes(StandardCharsets.UTF_8);
            protocolLength += usernameBytes.length;
        }
        String peerHost = message.getPeerHost();
        byte[] peerHostBytes = null;
        if (peerHost != null) {
            peerHostBytes = peerHost.getBytes(StandardCharsets.UTF_8);
            protocolLength += peerHostBytes.length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(protocolLength);
        buffer.put((byte)messageType.getValue());
        if (nodeBytes != null) {
            buffer.putShort((short)nodeBytes.length);
            buffer.put(nodeBytes);
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        if (clientIdBytes != null) {
            buffer.putShort((short)clientIdBytes.length);
            buffer.put(clientIdBytes);
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        if (usernameBytes != null) {
            buffer.putShort((short)usernameBytes.length);
            buffer.put(usernameBytes);
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        if (peerHostBytes != null) {
            buffer.put((byte)peerHostBytes.length);
            buffer.put(peerHostBytes);
        } else {
            buffer.put(EMPTY_BYTES);
        }
        buffer.putLong(message.getTimestamp());
        return buffer.array();
    }

    private static byte[] serializeSubscribe(MessageType messageType, Message message) {
        int protocolLength = 17;
        String node = message.getNode();
        byte[] nodeBytes = null;
        if (node != null) {
            nodeBytes = node.getBytes(StandardCharsets.UTF_8);
            protocolLength += nodeBytes.length;
        }
        String clientId = message.getClientId();
        byte[] clientIdBytes = null;
        if (clientId != null) {
            clientIdBytes = clientId.getBytes(StandardCharsets.UTF_8);
            protocolLength += clientIdBytes.length;
        }
        String topic = message.getTopic();
        byte[] topicBytes = null;
        if (topic != null) {
            topicBytes = topic.getBytes(StandardCharsets.UTF_8);
            protocolLength += topicBytes.length;
        }
        String peerHost = message.getPeerHost();
        byte[] peerHostBytes = null;
        if (peerHost != null) {
            peerHostBytes = peerHost.getBytes(StandardCharsets.UTF_8);
            protocolLength += peerHostBytes.length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(protocolLength);
        buffer.put((byte)messageType.getValue());
        if (nodeBytes != null) {
            buffer.putShort((short)nodeBytes.length);
            buffer.put(nodeBytes);
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        if (clientIdBytes != null) {
            buffer.putShort((short)clientIdBytes.length);
            buffer.put(clientIdBytes);
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        if (topicBytes != null) {
            buffer.putShort((short)topicBytes.length);
            buffer.put(topicBytes);
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        buffer.put((byte)message.getQos());
        if (peerHostBytes != null) {
            buffer.put((byte)peerHostBytes.length);
            buffer.put(peerHostBytes);
        } else {
            buffer.put(EMPTY_BYTES);
        }
        buffer.putLong(message.getTimestamp());
        return buffer.array();
    }

    private static byte[] serializeUnsubscribe(MessageType messageType, Message message) {
        int protocolLength = 16;
        String node = message.getNode();
        byte[] nodeBytes = null;
        if (node != null) {
            nodeBytes = node.getBytes(StandardCharsets.UTF_8);
            protocolLength += nodeBytes.length;
        }
        String clientId = message.getClientId();
        byte[] clientIdBytes = null;
        if (clientId != null) {
            clientIdBytes = clientId.getBytes(StandardCharsets.UTF_8);
            protocolLength += clientIdBytes.length;
        }
        String topic = message.getTopic();
        byte[] topicBytes = null;
        if (topic != null) {
            topicBytes = topic.getBytes(StandardCharsets.UTF_8);
            protocolLength += topicBytes.length;
        }
        String peerHost = message.getPeerHost();
        byte[] peerHostBytes = null;
        if (peerHost != null) {
            peerHostBytes = peerHost.getBytes(StandardCharsets.UTF_8);
            protocolLength += peerHostBytes.length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(protocolLength);
        buffer.put((byte)messageType.getValue());
        if (nodeBytes != null) {
            buffer.putShort((short)nodeBytes.length);
            buffer.put(nodeBytes);
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        if (clientIdBytes != null) {
            buffer.putShort((short)clientIdBytes.length);
            buffer.put(clientIdBytes);
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        if (topicBytes != null) {
            buffer.putShort((short)topicBytes.length);
            buffer.put(topicBytes);
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        if (peerHostBytes != null) {
            buffer.put((byte)peerHostBytes.length);
            buffer.put(peerHostBytes);
        } else {
            buffer.put(EMPTY_BYTES);
        }
        buffer.putLong(message.getTimestamp());
        return buffer.array();
    }

    private static byte[] serializeUpStream(MessageType messageType, Message message) {
        int protocolLength = 37;
        String fromClientId = message.getFromClientId();
        byte[] fromClientIdBytes = null;
        if (fromClientId != null) {
            fromClientIdBytes = fromClientId.getBytes(StandardCharsets.UTF_8);
            protocolLength += fromClientIdBytes.length;
        }
        String fromUsername = message.getFromUsername();
        byte[] fromUsernameBytes = null;
        if (fromUsername != null) {
            fromUsernameBytes = fromUsername.getBytes(StandardCharsets.UTF_8);
            protocolLength += fromUsernameBytes.length;
        }
        String clientId = message.getClientId();
        byte[] clientIdBytes = null;
        if (clientId != null) {
            clientIdBytes = clientId.getBytes(StandardCharsets.UTF_8);
            protocolLength += clientIdBytes.length;
        }
        String username = message.getUsername();
        byte[] usernameBytes = null;
        if (username != null) {
            usernameBytes = username.getBytes(StandardCharsets.UTF_8);
            protocolLength += usernameBytes.length;
        }
        String topic = message.getTopic();
        byte[] topicBytes = null;
        if (topic != null) {
            topicBytes = topic.getBytes(StandardCharsets.UTF_8);
            protocolLength += topicBytes.length;
        }
        ByteBuffer payload = message.getPayload();
        byte[] payloadBytes = null;
        if (payload != null) {
            payloadBytes = payload.array();
            protocolLength += payloadBytes.length;
        }
        String peerHost = message.getPeerHost();
        byte[] peerHostBytes = null;
        if (peerHost != null) {
            peerHostBytes = peerHost.getBytes(StandardCharsets.UTF_8);
            protocolLength += peerHostBytes.length;
        }
        String node = message.getNode();
        byte[] nodeBytes = null;
        if (node != null) {
            nodeBytes = node.getBytes(StandardCharsets.UTF_8);
            protocolLength += nodeBytes.length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(protocolLength);
        buffer.put((byte)messageType.getValue());
        if (nodeBytes != null) {
            buffer.putShort((short)nodeBytes.length);
            buffer.put(nodeBytes);
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        Integer messageId = message.getId();
        if (messageId != null) {
            buffer.putShort(messageId.shortValue());
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        if (fromClientIdBytes != null) {
            buffer.putShort((short)fromClientIdBytes.length);
            buffer.put(fromClientIdBytes);
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        if (fromUsernameBytes != null) {
            buffer.putShort((short)fromUsernameBytes.length);
            buffer.put(fromUsernameBytes);
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        if (clientIdBytes != null) {
            buffer.putShort((short)clientIdBytes.length);
            buffer.put(clientIdBytes);
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        if (usernameBytes != null) {
            buffer.putShort((short)usernameBytes.length);
            buffer.put(usernameBytes);
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        if (topicBytes != null) {
            buffer.putShort((short)topicBytes.length);
            buffer.put(topicBytes);
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        int byte1 = 0;
        if (message.isDup()) {
            byte1 |= 8;
        }
        byte1 |= message.getQos() << 1;
        if (message.isRetain()) {
            byte1 |= 1;
        }
        buffer.put((byte)byte1);
        if (payloadBytes != null) {
            buffer.putInt(payloadBytes.length);
            buffer.put(payloadBytes);
        } else {
            buffer.put(EMPTY_INT_BYTES);
        }
        if (peerHostBytes != null) {
            buffer.put((byte)peerHostBytes.length);
            buffer.put(peerHostBytes);
        } else {
            buffer.put(EMPTY_BYTES);
        }
        buffer.putLong(message.getTimestamp());
        Long publishReceivedAt = message.getPublishReceivedAt();
        if (publishReceivedAt != null) {
            buffer.putLong(publishReceivedAt);
        } else {
            buffer.put(EMPTY_LONG_BYTES);
        }
        return buffer.array();
    }

    private static byte[] serializeDownStream(MessageType messageType, Message message) {
        int protocolLength = 33;
        String node = message.getNode();
        byte[] nodeBytes = null;
        if (node != null) {
            nodeBytes = node.getBytes(StandardCharsets.UTF_8);
            protocolLength += nodeBytes.length;
        }
        String clientId = message.getClientId();
        byte[] clientIdBytes = null;
        if (clientId != null) {
            clientIdBytes = clientId.getBytes(StandardCharsets.UTF_8);
            protocolLength += clientIdBytes.length;
        }
        String username = message.getUsername();
        byte[] usernameBytes = null;
        if (username != null) {
            usernameBytes = username.getBytes(StandardCharsets.UTF_8);
            protocolLength += usernameBytes.length;
        }
        String topic = message.getTopic();
        byte[] topicBytes = null;
        if (topic != null) {
            topicBytes = topic.getBytes(StandardCharsets.UTF_8);
            protocolLength += topicBytes.length;
        }
        ByteBuffer payload = message.getPayload();
        byte[] payloadBytes = null;
        if (payload != null) {
            payloadBytes = payload.array();
            protocolLength += payloadBytes.length;
        }
        String peerHost = message.getPeerHost();
        byte[] peerHostBytes = null;
        if (peerHost != null) {
            peerHostBytes = peerHost.getBytes(StandardCharsets.UTF_8);
            protocolLength += peerHostBytes.length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(protocolLength);
        buffer.put((byte)messageType.getValue());
        if (nodeBytes != null) {
            buffer.putShort((short)nodeBytes.length);
            buffer.put(nodeBytes);
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        Integer messageId = message.getId();
        if (messageId != null) {
            buffer.putShort(messageId.shortValue());
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        if (clientIdBytes != null) {
            buffer.putShort((short)clientIdBytes.length);
            buffer.put(clientIdBytes);
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        if (usernameBytes != null) {
            buffer.putShort((short)usernameBytes.length);
            buffer.put(usernameBytes);
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        if (topicBytes != null) {
            buffer.putShort((short)topicBytes.length);
            buffer.put(topicBytes);
        } else {
            buffer.put(EMPTY_SHORT_BYTES);
        }
        int byte1 = 0;
        if (message.isDup()) {
            byte1 |= 8;
        }
        byte1 |= message.getQos() << 1;
        if (message.isRetain()) {
            byte1 |= 1;
        }
        buffer.put((byte)byte1);
        if (payloadBytes != null) {
            buffer.putInt(payloadBytes.length);
            buffer.put(payloadBytes);
        } else {
            buffer.put(EMPTY_INT_BYTES);
        }
        if (peerHostBytes != null) {
            buffer.put((byte)peerHostBytes.length);
            buffer.put(peerHostBytes);
        } else {
            buffer.put(EMPTY_BYTES);
        }
        buffer.putLong(message.getTimestamp());
        Long publishReceivedAt = message.getPublishReceivedAt();
        if (publishReceivedAt != null) {
            buffer.putLong(publishReceivedAt);
        } else {
            buffer.put(EMPTY_LONG_BYTES);
        }
        return buffer.array();
    }

    @Override
    public Message deserialize(byte[] data) {
        if (data == null || data.length < 1) {
            return null;
        }
        Message message = new Message();
        ByteBuffer buffer = ByteBuffer.wrap(data);
        byte messageTypeByte = buffer.get();
        MessageType messageType = MessageType.valueOf(messageTypeByte);
        message.setMessageType(messageType);
        switch (messageType) {
            case CONNECT: 
            case DISCONNECT: {
                return DefaultMessageSerializer.deserializeConnect(buffer, message);
            }
            case SUBSCRIBE: {
                return DefaultMessageSerializer.deserializeSubscribe(buffer, message);
            }
            case UNSUBSCRIBE: {
                return DefaultMessageSerializer.deserializeUnsubscribe(buffer, message);
            }
            case UP_STREAM: {
                return DefaultMessageSerializer.deserializeUpStream(buffer, message);
            }
            case DOWN_STREAM: {
                return DefaultMessageSerializer.deserializeDownStream(buffer, message);
            }
        }
        throw new IllegalArgumentException("unknown message type: " + (Object)((Object)messageType));
    }

    private static Message deserializeConnect(ByteBuffer buffer, Message message) {
        byte peerHostLen;
        short usernameLen;
        short clientIdLen;
        short nodeLength = buffer.getShort();
        if (nodeLength > 0) {
            byte[] nodeBytes = new byte[nodeLength];
            buffer.get(nodeBytes);
            message.setNode(new String(nodeBytes, StandardCharsets.UTF_8));
        }
        if ((clientIdLen = buffer.getShort()) > 0) {
            byte[] clientIdBytes = new byte[clientIdLen];
            buffer.get(clientIdBytes);
            message.setClientId(new String(clientIdBytes, StandardCharsets.UTF_8));
        }
        if ((usernameLen = buffer.getShort()) > 0) {
            byte[] usernameBytes = new byte[usernameLen];
            buffer.get(usernameBytes);
            message.setUsername(new String(usernameBytes, StandardCharsets.UTF_8));
        }
        if ((peerHostLen = buffer.get()) > 0) {
            byte[] peerHostBytes = new byte[peerHostLen];
            buffer.get(peerHostBytes);
            message.setPeerHost(new String(peerHostBytes, StandardCharsets.UTF_8));
        }
        long timestamp = buffer.getLong();
        message.setTimestamp(timestamp);
        return message;
    }

    private static Message deserializeSubscribe(ByteBuffer buffer, Message message) {
        short topicLength;
        short clientIdLen;
        short nodeLength = buffer.getShort();
        if (nodeLength > 0) {
            byte[] nodeBytes = new byte[nodeLength];
            buffer.get(nodeBytes);
            message.setNode(new String(nodeBytes, StandardCharsets.UTF_8));
        }
        if ((clientIdLen = buffer.getShort()) > 0) {
            byte[] clientIdBytes = new byte[clientIdLen];
            buffer.get(clientIdBytes);
            message.setClientId(new String(clientIdBytes, StandardCharsets.UTF_8));
        }
        if ((topicLength = buffer.getShort()) > 0) {
            byte[] topicBytes = new byte[topicLength];
            buffer.get(topicBytes);
            message.setTopic(new String(topicBytes, StandardCharsets.UTF_8));
        }
        byte qos = buffer.get();
        message.setQos(qos);
        byte peerHostLen = buffer.get();
        if (peerHostLen > 0) {
            byte[] peerHostBytes = new byte[peerHostLen];
            buffer.get(peerHostBytes);
            message.setPeerHost(new String(peerHostBytes, StandardCharsets.UTF_8));
        }
        long timestamp = buffer.getLong();
        message.setTimestamp(timestamp);
        return message;
    }

    private static Message deserializeUnsubscribe(ByteBuffer buffer, Message message) {
        byte peerHostLen;
        short topicLength;
        short clientIdLen;
        short nodeLength = buffer.getShort();
        if (nodeLength > 0) {
            byte[] nodeBytes = new byte[nodeLength];
            buffer.get(nodeBytes);
            message.setNode(new String(nodeBytes, StandardCharsets.UTF_8));
        }
        if ((clientIdLen = buffer.getShort()) > 0) {
            byte[] clientIdBytes = new byte[clientIdLen];
            buffer.get(clientIdBytes);
            message.setClientId(new String(clientIdBytes, StandardCharsets.UTF_8));
        }
        if ((topicLength = buffer.getShort()) > 0) {
            byte[] topicBytes = new byte[topicLength];
            buffer.get(topicBytes);
            message.setTopic(new String(topicBytes, StandardCharsets.UTF_8));
        }
        if ((peerHostLen = buffer.get()) > 0) {
            byte[] peerHostBytes = new byte[peerHostLen];
            buffer.get(peerHostBytes);
            message.setPeerHost(new String(peerHostBytes, StandardCharsets.UTF_8));
        }
        long timestamp = buffer.getLong();
        message.setTimestamp(timestamp);
        return message;
    }

    private static Message deserializeUpStream(ByteBuffer buffer, Message message) {
        byte peerHostLen;
        short byte1;
        short topicLength;
        short usernameLen;
        short clientIdLen;
        short fromUsernameLen;
        short fromClientIdLen;
        int messageId;
        short nodeLength = buffer.getShort();
        if (nodeLength > 0) {
            byte[] nodeBytes = new byte[nodeLength];
            buffer.get(nodeBytes);
            message.setNode(new String(nodeBytes, StandardCharsets.UTF_8));
        }
        if ((messageId = DefaultMessageSerializer.getMessageId(buffer)) > 0) {
            message.setId(messageId);
        }
        if ((fromClientIdLen = buffer.getShort()) > 0) {
            byte[] fromClientIdBytes = new byte[fromClientIdLen];
            buffer.get(fromClientIdBytes);
            message.setFromClientId(new String(fromClientIdBytes, StandardCharsets.UTF_8));
        }
        if ((fromUsernameLen = buffer.getShort()) > 0) {
            byte[] fromUsernameBytes = new byte[fromUsernameLen];
            buffer.get(fromUsernameBytes);
            message.setFromUsername(new String(fromUsernameBytes, StandardCharsets.UTF_8));
        }
        if ((clientIdLen = buffer.getShort()) > 0) {
            byte[] clientIdBytes = new byte[clientIdLen];
            buffer.get(clientIdBytes);
            message.setClientId(new String(clientIdBytes, StandardCharsets.UTF_8));
        }
        if ((usernameLen = buffer.getShort()) > 0) {
            byte[] usernameBytes = new byte[usernameLen];
            buffer.get(usernameBytes);
            message.setUsername(new String(usernameBytes, StandardCharsets.UTF_8));
        }
        if ((topicLength = buffer.getShort()) > 0) {
            byte[] topicBytes = new byte[topicLength];
            buffer.get(topicBytes);
            message.setTopic(new String(topicBytes, StandardCharsets.UTF_8));
        }
        boolean isDup = ((byte1 = DefaultMessageSerializer.readUnsignedByte(buffer)) & 8) == 8;
        message.setDup(isDup);
        int qosLevel = (byte1 & 6) >> 1;
        message.setQos(qosLevel);
        boolean retain = (byte1 & 1) != 0;
        message.setRetain(retain);
        int payloadLen = buffer.getInt();
        if (payloadLen > 0) {
            byte[] payloadBytes = new byte[payloadLen];
            buffer.get(payloadBytes);
            message.setPayload(ByteBuffer.wrap(payloadBytes));
        }
        if ((peerHostLen = buffer.get()) > 0) {
            byte[] peerHostBytes = new byte[peerHostLen];
            buffer.get(peerHostBytes);
            message.setPeerHost(new String(peerHostBytes, StandardCharsets.UTF_8));
        }
        long timestamp = buffer.getLong();
        message.setTimestamp(timestamp);
        long publishReceivedAt = buffer.getLong();
        if (publishReceivedAt > 0L) {
            message.setPublishReceivedAt(publishReceivedAt);
        }
        return message;
    }

    private static Message deserializeDownStream(ByteBuffer buffer, Message message) {
        byte peerHostLen;
        short byte1;
        short topicLength;
        short usernameLen;
        short clientIdLen;
        int messageId;
        short nodeLength = buffer.getShort();
        if (nodeLength > 0) {
            byte[] nodeBytes = new byte[nodeLength];
            buffer.get(nodeBytes);
            message.setNode(new String(nodeBytes, StandardCharsets.UTF_8));
        }
        if ((messageId = DefaultMessageSerializer.getMessageId(buffer)) > 0) {
            message.setId(messageId);
        }
        if ((clientIdLen = buffer.getShort()) > 0) {
            byte[] clientIdBytes = new byte[clientIdLen];
            buffer.get(clientIdBytes);
            message.setClientId(new String(clientIdBytes, StandardCharsets.UTF_8));
        }
        if ((usernameLen = buffer.getShort()) > 0) {
            byte[] usernameBytes = new byte[usernameLen];
            buffer.get(usernameBytes);
            message.setUsername(new String(usernameBytes, StandardCharsets.UTF_8));
        }
        if ((topicLength = buffer.getShort()) > 0) {
            byte[] topicBytes = new byte[topicLength];
            buffer.get(topicBytes);
            message.setTopic(new String(topicBytes, StandardCharsets.UTF_8));
        }
        boolean isDup = ((byte1 = DefaultMessageSerializer.readUnsignedByte(buffer)) & 8) == 8;
        message.setDup(isDup);
        int qosLevel = (byte1 & 6) >> 1;
        message.setQos(qosLevel);
        boolean retain = (byte1 & 1) != 0;
        message.setRetain(retain);
        int payloadLen = buffer.getInt();
        if (payloadLen > 0) {
            byte[] payloadBytes = new byte[payloadLen];
            buffer.get(payloadBytes);
            message.setPayload(ByteBuffer.wrap(payloadBytes));
        }
        if ((peerHostLen = buffer.get()) > 0) {
            byte[] peerHostBytes = new byte[peerHostLen];
            buffer.get(peerHostBytes);
            message.setPeerHost(new String(peerHostBytes, StandardCharsets.UTF_8));
        }
        long timestamp = buffer.getLong();
        message.setTimestamp(timestamp);
        long publishReceivedAt = buffer.getLong();
        if (publishReceivedAt > 0L) {
            message.setPublishReceivedAt(publishReceivedAt);
        }
        return message;
    }

    private static short readUnsignedByte(ByteBuffer buffer) {
        return (short)(buffer.get() & 0xFF);
    }

    private static int getMessageId(ByteBuffer buffer) {
        short lsbSize;
        int min = 0;
        int max = 65535;
        short msbSize = DefaultMessageSerializer.readUnsignedByte(buffer);
        int result = msbSize << 8 | (lsbSize = DefaultMessageSerializer.readUnsignedByte(buffer));
        if (result < min || result > max) {
            result = -1;
        }
        return result;
    }

    static {
        EMPTY_BYTES = new byte[0];
        EMPTY_SHORT_BYTES = new byte[2];
        EMPTY_INT_BYTES = new byte[4];
        EMPTY_LONG_BYTES = new byte[8];
    }
}

