/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.metric;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.function.Function;

class MetricCollectingServerCall<Q, A>
extends ForwardingServerCall.SimpleForwardingServerCall<Q, A> {
    private final Counter responseCounter;
    private final Function<Status.Code, Timer> timerFunction;
    private final Timer.Sample timerSample;

    public MetricCollectingServerCall(ServerCall<Q, A> delegate, MeterRegistry registry, Counter responseCounter, Function<Status.Code, Timer> timerFunction) {
        super(delegate);
        this.responseCounter = responseCounter;
        this.timerFunction = timerFunction;
        this.timerSample = Timer.start((MeterRegistry)registry);
    }

    public void close(Status status, Metadata responseHeaders) {
        this.timerSample.stop(this.timerFunction.apply(status.getCode()));
        super.close(status, responseHeaders);
    }

    public void sendMessage(A responseMessage) {
        this.responseCounter.increment();
        super.sendMessage(responseMessage);
    }
}

