/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.serverfactory;

import com.google.common.net.InetAddresses;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServerBuilder;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import net.devh.boot.grpc.server.config.ClientAuth;
import net.devh.boot.grpc.server.config.GrpcServerProperties;
import net.devh.boot.grpc.server.serverfactory.AbstractGrpcServerFactory;
import net.devh.boot.grpc.server.serverfactory.GrpcServerConfigurer;
import org.springframework.core.io.Resource;

public class NettyGrpcServerFactory
extends AbstractGrpcServerFactory<NettyServerBuilder> {
    public NettyGrpcServerFactory(GrpcServerProperties properties, List<GrpcServerConfigurer> serverConfigurers) {
        super(properties, serverConfigurers);
    }

    @Override
    protected NettyServerBuilder newServerBuilder() {
        String address = this.getAddress();
        int port = this.getPort();
        if ("*".equals(address)) {
            return NettyServerBuilder.forPort((int)port);
        }
        return NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(InetAddresses.forString((String)address), port));
    }

    @Override
    protected void configureKeepAlive(NettyServerBuilder builder) {
        if (this.properties.isEnableKeepAlive()) {
            builder.keepAliveTime(this.properties.getKeepAliveTime().toNanos(), TimeUnit.NANOSECONDS).keepAliveTimeout(this.properties.getKeepAliveTimeout().toNanos(), TimeUnit.NANOSECONDS);
        }
        builder.permitKeepAliveTime(this.properties.getPermitKeepAliveTime().toNanos(), TimeUnit.NANOSECONDS).permitKeepAliveWithoutCalls(this.properties.isPermitKeepAliveWithoutCalls());
    }

    @Override
    protected void configureSecurity(NettyServerBuilder builder) {
        GrpcServerProperties.Security security = this.properties.getSecurity();
        if (security.isEnabled()) {
            SslContextBuilder sslContextBuilder;
            Resource certificateChain = Objects.requireNonNull(security.getCertificateChain(), "certificateChain not configured");
            Resource privateKey = Objects.requireNonNull(security.getPrivateKey(), "privateKey not configured");
            try (InputStream certificateChainStream = certificateChain.getInputStream();
                 InputStream privateKeyStream = privateKey.getInputStream();){
                sslContextBuilder = GrpcSslContexts.forServer((InputStream)certificateChainStream, (InputStream)privateKeyStream, (String)security.getPrivateKeyPassword());
            }
            catch (IOException | RuntimeException e) {
                throw new IllegalArgumentException("Failed to create SSLContext (PK/Cert)", e);
            }
            if (security.getClientAuth() != ClientAuth.NONE) {
                sslContextBuilder.clientAuth(NettyGrpcServerFactory.of(security.getClientAuth()));
                Resource trustCertCollection = security.getTrustCertCollection();
                if (trustCertCollection != null) {
                    try (InputStream trustCertCollectionStream = trustCertCollection.getInputStream();){
                        sslContextBuilder.trustManager(trustCertCollectionStream);
                    }
                    catch (IOException | RuntimeException e) {
                        throw new IllegalArgumentException("Failed to create SSLContext (TrustStore)", e);
                    }
                }
            }
            if (security.getCiphers() != null && !security.getCiphers().isEmpty()) {
                sslContextBuilder.ciphers(security.getCiphers());
            }
            if (security.getProtocols() != null && security.getProtocols().length > 0) {
                sslContextBuilder.protocols(security.getProtocols());
            }
            try {
                builder.sslContext(sslContextBuilder.build());
            }
            catch (SSLException e) {
                throw new IllegalStateException("Failed to create ssl context for grpc server", e);
            }
        }
    }

    protected static io.netty.handler.ssl.ClientAuth of(ClientAuth clientAuth) {
        switch (clientAuth) {
            case NONE: {
                return io.netty.handler.ssl.ClientAuth.NONE;
            }
            case OPTIONAL: {
                return io.netty.handler.ssl.ClientAuth.OPTIONAL;
            }
            case REQUIRE: {
                return io.netty.handler.ssl.ClientAuth.REQUIRE;
            }
        }
        throw new IllegalArgumentException("Unsupported ClientAuth: " + (Object)((Object)clientAuth));
    }
}

