/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.interceptor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.grpc.ServerInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import net.devh.boot.grpc.server.interceptor.GlobalServerInterceptorConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class GlobalServerInterceptorRegistry
implements ApplicationContextAware {
    private final List<ServerInterceptor> serverInterceptors = Lists.newArrayList();
    private ImmutableList<ServerInterceptor> sortedServerInterceptors;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        Map map = this.applicationContext.getBeansOfType(GlobalServerInterceptorConfigurer.class);
        for (GlobalServerInterceptorConfigurer globalServerInterceptorConfigurerAdapter : map.values()) {
            globalServerInterceptorConfigurerAdapter.addServerInterceptors(this);
        }
    }

    public GlobalServerInterceptorRegistry addServerInterceptors(ServerInterceptor interceptor) {
        this.sortedServerInterceptors = null;
        this.serverInterceptors.add(interceptor);
        return this;
    }

    public ImmutableList<ServerInterceptor> getServerInterceptors() {
        if (this.sortedServerInterceptors == null) {
            ArrayList temp = Lists.newArrayList(this.serverInterceptors);
            this.sortInterceptors(temp);
            this.sortedServerInterceptors = ImmutableList.copyOf((Collection)temp);
        }
        return this.sortedServerInterceptors;
    }

    public void sortInterceptors(List<? extends ServerInterceptor> interceptors) {
        interceptors.sort((Comparator<? extends ServerInterceptor>)AnnotationAwareOrderComparator.INSTANCE);
    }
}

