/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.security.check;

import com.google.common.collect.ImmutableList;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServiceDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.devh.boot.grpc.server.security.check.AbstractGrpcSecurityMetadataSource;
import net.devh.boot.grpc.server.security.check.AccessPredicate;
import net.devh.boot.grpc.server.security.check.AccessPredicateConfigAttribute;
import net.devh.boot.grpc.server.security.check.AccessPredicates;
import org.springframework.security.access.ConfigAttribute;

public final class ManualGrpcSecurityMetadataSource
extends AbstractGrpcSecurityMetadataSource {
    private final Map<MethodDescriptor<?, ?>, Collection<ConfigAttribute>> accessMap = new HashMap();
    private Collection<ConfigAttribute> defaultAttributes = this.wrap(AccessPredicate.denyAll());

    private Collection<ConfigAttribute> getAttributes(MethodDescriptor<?, ?> method) {
        return this.accessMap.getOrDefault(method, this.defaultAttributes);
    }

    @Override
    public Collection<ConfigAttribute> getAttributes(ServerCall<?, ?> call) {
        return this.getAttributes(call.getMethodDescriptor());
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return this.accessMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public ManualGrpcSecurityMetadataSource set(ServiceDescriptor service, AccessPredicate predicate) {
        Objects.requireNonNull(service, "service");
        Collection<ConfigAttribute> wrappedPredicate = this.wrap(predicate);
        for (MethodDescriptor method : service.getMethods()) {
            this.accessMap.put(method, wrappedPredicate);
        }
        return this;
    }

    public ManualGrpcSecurityMetadataSource remove(ServiceDescriptor service) {
        Objects.requireNonNull(service, "service");
        for (MethodDescriptor method : service.getMethods()) {
            this.accessMap.remove(method);
        }
        return this;
    }

    public ManualGrpcSecurityMetadataSource set(MethodDescriptor<?, ?> method, AccessPredicate predicate) {
        Objects.requireNonNull(method, "method");
        this.accessMap.put(method, this.wrap(predicate));
        return this;
    }

    public ManualGrpcSecurityMetadataSource remove(MethodDescriptor<?, ?> method) {
        Objects.requireNonNull(method, "method");
        this.accessMap.remove(method);
        return this;
    }

    public ManualGrpcSecurityMetadataSource setDefault(AccessPredicate predicate) {
        this.defaultAttributes = this.wrap(predicate);
        return this;
    }

    private Collection<ConfigAttribute> wrap(AccessPredicate predicate) {
        Objects.requireNonNull(predicate, "predicate");
        if (predicate == AccessPredicates.PERMIT_ALL) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)new AccessPredicateConfigAttribute(predicate));
    }
}

