/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.security.authentication;

import java.security.Principal;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import net.devh.boot.grpc.server.security.authentication.X509CertificateAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class X509CertificateAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(X509CertificateAuthenticationProvider.class);
    public static final Function<Authentication, String> PRINCIPAL_USERNAME_EXTRACTOR = Principal::getName;
    public static final Function<X509CertificateAuthentication, String> CN_USERNAME_EXTRACTOR = X509CertificateAuthenticationProvider.patternExtractor("CN", PRINCIPAL_USERNAME_EXTRACTOR);
    public static final Function<Authentication, String> FAIL_FALLBACK = authentication -> null;
    private final Function<? super X509CertificateAuthentication, String> usernameExtractor;
    private final UserDetailsService userDetailsService;

    public static Function<X509CertificateAuthentication, String> patternExtractor(String key, Function<? super X509CertificateAuthentication, String> fallback) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(fallback, "fallback");
        Pattern pattern = Pattern.compile(key + "=(.+?)(?:,|$)", 2);
        return authentication -> {
            X500Principal x500Principal;
            Matcher matcher;
            Object principal = authentication.getPrincipal();
            if (principal instanceof X500Principal && (matcher = pattern.matcher((x500Principal = (X500Principal)principal).getName())).find()) {
                return matcher.group(1);
            }
            return (String)fallback.apply((X509CertificateAuthentication)((Object)authentication));
        };
    }

    public X509CertificateAuthenticationProvider(UserDetailsService userDetailsService) {
        this(CN_USERNAME_EXTRACTOR, userDetailsService);
    }

    public X509CertificateAuthenticationProvider(Function<? super X509CertificateAuthentication, String> usernameExtractor, UserDetailsService userDetailsService) {
        this.usernameExtractor = Objects.requireNonNull(usernameExtractor, "usernameExtractor");
        this.userDetailsService = Objects.requireNonNull(userDetailsService, "userDetailsService");
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!(authentication instanceof X509CertificateAuthentication)) {
            throw new IllegalArgumentException("Unsupported authentication type: " + authentication.getClass().getName() + ". Only X509CertificateAuthentication is supported!");
        }
        X509CertificateAuthentication auth = (X509CertificateAuthentication)authentication;
        String username = this.usernameExtractor.apply(auth);
        if (username == null) {
            log.debug("Could not find username");
            throw new UsernameNotFoundException("No username provided");
        }
        UserDetails user = this.userDetailsService.loadUserByUsername(username);
        if (user == null) {
            log.debug("Could not find user '{}'", (Object)username);
            throw new UsernameNotFoundException("Unknown username: " + username);
        }
        log.debug("Authenticated as '{}'", (Object)username);
        return new X509CertificateAuthentication(user, auth.getCredentials(), user.getAuthorities());
    }

    public boolean supports(Class<?> authentication) {
        return X509CertificateAuthentication.class.isAssignableFrom(authentication);
    }
}

