/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.advice;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import net.devh.boot.grpc.server.advice.GrpcExceptionHandlerMethodResolver;
import net.devh.boot.grpc.server.error.GrpcExceptionResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class GrpcAdviceExceptionHandler
implements GrpcExceptionResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(GrpcAdviceExceptionHandler.class);
    private final GrpcExceptionHandlerMethodResolver grpcExceptionHandlerMethodResolver;

    public GrpcAdviceExceptionHandler(GrpcExceptionHandlerMethodResolver grpcExceptionHandlerMethodResolver) {
        this.grpcExceptionHandlerMethodResolver = Objects.requireNonNull(grpcExceptionHandlerMethodResolver, "grpcExceptionHandlerMethodResolver");
    }

    @Override
    public void handleError(ServerCall<?, ?> serverCall, Throwable error) {
        try {
            Object mappedReturnType = this.handleThrownException(error);
            Status status = this.resolveStatus(mappedReturnType);
            Metadata metadata = this.resolveMetadata(mappedReturnType);
            serverCall.close(status, metadata);
        }
        catch (Throwable errorWhileResolving) {
            if (errorWhileResolving != error) {
                errorWhileResolving.addSuppressed(error);
            }
            this.handleThrownExceptionByImplementation(serverCall, errorWhileResolving);
        }
    }

    protected Status resolveStatus(Object mappedReturnType) {
        if (mappedReturnType instanceof Status) {
            return (Status)mappedReturnType;
        }
        if (mappedReturnType instanceof Throwable) {
            return Status.fromThrowable((Throwable)((Throwable)mappedReturnType));
        }
        throw new IllegalStateException(String.format("Error for mapped return type [%s] inside @GrpcAdvice, it has to be of type: [Status, StatusException, StatusRuntimeException, Throwable] ", mappedReturnType));
    }

    protected Metadata resolveMetadata(Object mappedReturnType) {
        Metadata result = null;
        if (mappedReturnType instanceof StatusException) {
            StatusException statusException = (StatusException)mappedReturnType;
            result = statusException.getTrailers();
        } else if (mappedReturnType instanceof StatusRuntimeException) {
            StatusRuntimeException statusException = (StatusRuntimeException)mappedReturnType;
            result = statusException.getTrailers();
        }
        return result == null ? new Metadata() : result;
    }

    protected void handleThrownExceptionByImplementation(ServerCall<?, ?> serverCall, Throwable throwable) {
        log.error("Exception thrown during invocation of annotated @GrpcExceptionHandler method: ", throwable);
        serverCall.close(Status.INTERNAL.withCause(throwable).withDescription("There was a server error trying to handle an exception"), new Metadata());
    }

    @Nullable
    protected Object handleThrownException(Throwable exception) throws Throwable {
        log.debug("Exception caught during gRPC execution: ", exception);
        Class<?> exceptionClass = exception.getClass();
        boolean exceptionIsMapped = this.grpcExceptionHandlerMethodResolver.isMethodMappedForException(exceptionClass);
        if (!exceptionIsMapped) {
            throw exception;
        }
        Map.Entry<Object, Method> methodWithInstance = this.grpcExceptionHandlerMethodResolver.resolveMethodWithInstance(exceptionClass);
        Method mappedMethod = methodWithInstance.getValue();
        Object instanceOfMappedMethod = methodWithInstance.getKey();
        Object[] instancedParams = this.determineInstancedParameters(mappedMethod, exception);
        return this.invokeMappedMethodSafely(mappedMethod, instanceOfMappedMethod, instancedParams);
    }

    private Object[] determineInstancedParameters(Method mappedMethod, Throwable exception) {
        Parameter[] parameters = mappedMethod.getParameters();
        Object[] instancedParams = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> parameterClass = this.convertToClass(parameters[i]);
            if (!parameterClass.isAssignableFrom(exception.getClass())) continue;
            instancedParams[i] = exception;
            break;
        }
        return instancedParams;
    }

    private Class<?> convertToClass(Parameter parameter) {
        Type paramType = parameter.getParameterizedType();
        if (paramType instanceof Class) {
            return (Class)paramType;
        }
        throw new IllegalStateException("Parameter type of method has to be from Class, it was: " + paramType);
    }

    private Object invokeMappedMethodSafely(Method mappedMethod, Object instanceOfMappedMethod, Object[] instancedParams) throws Throwable {
        try {
            return mappedMethod.invoke(instanceOfMappedMethod, instancedParams);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

