/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.error;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.util.Objects;
import net.devh.boot.grpc.server.error.GrpcExceptionListener;
import net.devh.boot.grpc.server.error.GrpcExceptionResponseHandler;
import net.devh.boot.grpc.server.error.GrpcExceptionServerCall;

public class GrpcExceptionInterceptor
implements ServerInterceptor {
    private final GrpcExceptionResponseHandler exceptionHandler;

    public GrpcExceptionInterceptor(GrpcExceptionResponseHandler grpcAdviceExceptionHandler) {
        this.exceptionHandler = Objects.requireNonNull(grpcAdviceExceptionHandler, "grpcAdviceExceptionHandler");
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        try {
            GrpcExceptionServerCall<ReqT, RespT> handledCall = new GrpcExceptionServerCall<ReqT, RespT>(call, this.exceptionHandler);
            ServerCall.Listener delegate = next.startCall(handledCall, headers);
            return new GrpcExceptionListener<ReqT, RespT>(delegate, call, this.exceptionHandler);
        }
        catch (Throwable error) {
            this.exceptionHandler.handleError(call, error);
            return this.noOpCallListener();
        }
    }

    protected <ReqT> ServerCall.Listener<ReqT> noOpCallListener() {
        return new ServerCall.Listener<ReqT>(){};
    }
}

