/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.security.authentication;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class X509CertificateAuthentication
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = -5783300616514990238L;
    private final Object principal;
    private X509Certificate certificate;

    public X509CertificateAuthentication(X509Certificate certificate) {
        super(Collections.emptyList());
        Objects.requireNonNull(certificate, "certificate");
        this.principal = certificate.getSubjectX500Principal();
        this.certificate = certificate;
        this.setAuthenticated(false);
    }

    public X509CertificateAuthentication(Object principal, X509Certificate certificate, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.principal = Objects.requireNonNull(principal, "principal");
        this.certificate = Objects.requireNonNull(certificate, "certificate");
        super.setAuthenticated(true);
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public X509Certificate getCredentials() {
        return this.certificate;
    }

    public void eraseCredentials() {
        this.certificate = null;
        super.eraseCredentials();
    }

    public void setAuthenticated(boolean authenticated) {
        if (authenticated) {
            throw new IllegalArgumentException("Cannot set this token to trusted - use constructor which takes a GrantedAuthority list instead");
        }
        super.setAuthenticated(false);
    }
}

