/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.autoconfigure;

import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import io.grpc.protobuf.services.ProtoReflectionService;
import io.grpc.services.HealthStatusManager;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import net.devh.boot.grpc.common.util.GrpcUtils;
import net.devh.boot.grpc.server.autoconfigure.GrpcServerAutoConfiguration;
import net.devh.boot.grpc.server.config.GrpcServerProperties;
import net.devh.boot.grpc.server.metric.MetricCollectingServerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.boot.actuate.info.SimpleInfoContributor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={CompositeMeterRegistryAutoConfiguration.class})
@AutoConfigureBefore(value={GrpcServerAutoConfiguration.class})
@ConditionalOnBean(value={MeterRegistry.class})
public class GrpcServerMetricAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GrpcServerMetricAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public MetricCollectingServerInterceptor metricCollectingServerInterceptor(MeterRegistry registry, Collection<BindableService> services) {
        MetricCollectingServerInterceptor metricCollector = new MetricCollectingServerInterceptor(registry);
        log.debug("Pre-Registering service metrics");
        for (BindableService service : services) {
            log.debug("- {}", (Object)service);
            metricCollector.preregisterService(service);
        }
        return metricCollector;
    }

    @Bean
    @Lazy
    InfoContributor grpcInfoContributor(GrpcServerProperties properties, Collection<BindableService> grpcServices, HealthStatusManager healthStatusManager) {
        LinkedHashMap<String, Serializable> details = new LinkedHashMap<String, Serializable>();
        details.put("port", Integer.valueOf(properties.getPort()));
        if (properties.isReflectionServiceEnabled()) {
            TreeMap<String, List<String>> services = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            details.put("services", services);
            ArrayList<BindableService> mutableGrpcServiceList = new ArrayList<BindableService>(grpcServices);
            mutableGrpcServiceList.add(ProtoReflectionService.newInstance());
            if (properties.isHealthServiceEnabled()) {
                mutableGrpcServiceList.add(healthStatusManager.getHealthService());
            }
            for (BindableService grpcService : mutableGrpcServiceList) {
                ServiceDescriptor serviceDescriptor = grpcService.bindService().getServiceDescriptor();
                List<String> methods = this.collectMethodNamesForService(serviceDescriptor);
                services.put(serviceDescriptor.getName(), methods);
            }
        }
        return new SimpleInfoContributor("grpc.server", details);
    }

    protected List<String> collectMethodNamesForService(ServiceDescriptor serviceDescriptor) {
        ArrayList<String> methods = new ArrayList<String>();
        for (MethodDescriptor grpcMethod : serviceDescriptor.getMethods()) {
            methods.add(GrpcUtils.extractMethodName((MethodDescriptor)grpcMethod));
        }
        methods.sort(String.CASE_INSENSITIVE_ORDER);
        return methods;
    }
}

