/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.autoconfigure;

import com.alibaba.cloud.nacos.registry.NacosRegistration;
import javax.annotation.PostConstruct;
import net.devh.boot.grpc.server.config.GrpcServerProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties
@ConditionalOnClass(value={NacosRegistration.class})
public class GrpcMetadataNacosConfiguration {
    @Autowired(required=false)
    private NacosRegistration nacosRegistration;
    @Autowired
    private GrpcServerProperties grpcProperties;

    @PostConstruct
    public void init() {
        int port;
        if (this.nacosRegistration != null && -1 != (port = this.grpcProperties.getPort())) {
            this.nacosRegistration.getMetadata().put("gRPC.port", Integer.toString(port));
        }
    }
}

