/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.server.security.authentication;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import net.devh.boot.grpc.common.security.SecurityConstants;
import net.devh.boot.grpc.server.security.authentication.GrpcAuthenticationReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class BasicGrpcAuthenticationReader
implements GrpcAuthenticationReader {
    private static final Logger log = LoggerFactory.getLogger(BasicGrpcAuthenticationReader.class);
    private static final String PREFIX = "Basic ".toLowerCase();
    private static final int PREFIX_LENGTH = PREFIX.length();

    @Override
    public Authentication readAuthentication(ServerCall<?, ?> call, Metadata headers) throws AuthenticationException {
        String header = (String)headers.get(SecurityConstants.AUTHORIZATION_HEADER);
        if (header == null || !header.toLowerCase().startsWith(PREFIX)) {
            log.debug("No basic auth header found");
            return null;
        }
        String[] decoded = this.extractAndDecodeHeader(header);
        return new UsernamePasswordAuthenticationToken((Object)decoded[0], (Object)decoded[1]);
    }

    private String[] extractAndDecodeHeader(String header) {
        byte[] decoded;
        byte[] base64Token = header.substring(PREFIX_LENGTH).getBytes(StandardCharsets.UTF_8);
        try {
            decoded = Base64.getDecoder().decode(base64Token);
        }
        catch (IllegalArgumentException e) {
            throw new BadCredentialsException("Failed to decode basic authentication token", (Throwable)e);
        }
        String token = new String(decoded, StandardCharsets.UTF_8);
        int delim = token.indexOf(58);
        if (delim == -1) {
            throw new BadCredentialsException("Invalid basic authentication token");
        }
        return new String[]{token.substring(0, delim), token.substring(delim + 1)};
    }
}

