/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.server;

import com.google.common.collect.Lists;
import io.grpc.ServerInterceptor;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import net.devh.springboot.autoconfigure.grpc.server.GlobalServerInterceptorConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GlobalServerInterceptorRegistry
implements ApplicationContextAware {
    private final List<ServerInterceptor> serverInterceptors = Lists.newArrayList();
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        Map map = this.applicationContext.getBeansOfType(GlobalServerInterceptorConfigurer.class);
        for (GlobalServerInterceptorConfigurer globalServerInterceptorConfigurerAdapter : map.values()) {
            globalServerInterceptorConfigurerAdapter.addServerInterceptors(this);
        }
    }

    public GlobalServerInterceptorRegistry addServerInterceptors(ServerInterceptor interceptor) {
        this.serverInterceptors.add(interceptor);
        return this;
    }

    public List<ServerInterceptor> getServerInterceptors() {
        return this.serverInterceptors;
    }
}

