/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.server;

import brave.Tracing;
import brave.grpc.GrpcTracing;
import io.grpc.Server;
import io.grpc.services.HealthStatusManager;
import io.netty.channel.Channel;
import net.devh.springboot.autoconfigure.grpc.server.AnnotationGrpcServiceDiscoverer;
import net.devh.springboot.autoconfigure.grpc.server.GlobalServerInterceptorConfigurerAdapter;
import net.devh.springboot.autoconfigure.grpc.server.GlobalServerInterceptorRegistry;
import net.devh.springboot.autoconfigure.grpc.server.GrpcServerFactory;
import net.devh.springboot.autoconfigure.grpc.server.GrpcServerLifecycle;
import net.devh.springboot.autoconfigure.grpc.server.GrpcServerProperties;
import net.devh.springboot.autoconfigure.grpc.server.GrpcServiceDefinition;
import net.devh.springboot.autoconfigure.grpc.server.GrpcServiceDiscoverer;
import net.devh.springboot.autoconfigure.grpc.server.NettyGrpcServerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
@ConditionalOnClass(value={Server.class, GrpcServerFactory.class})
public class GrpcServerAutoConfiguration {
    @ConditionalOnMissingBean
    @Bean
    public GrpcServerProperties defaultGrpcServerProperties() {
        return new GrpcServerProperties();
    }

    @Bean
    public GlobalServerInterceptorRegistry globalServerInterceptorRegistry() {
        return new GlobalServerInterceptorRegistry();
    }

    @ConditionalOnMissingBean
    @Bean
    public AnnotationGrpcServiceDiscoverer defaultGrpcServiceFinder() {
        return new AnnotationGrpcServiceDiscoverer();
    }

    @ConditionalOnMissingBean
    @Bean
    public HealthStatusManager healthStatusManager() {
        return new HealthStatusManager();
    }

    @ConditionalOnMissingBean
    @ConditionalOnClass(value={Channel.class})
    @Bean
    public NettyGrpcServerFactory nettyGrpcServiceFactory(GrpcServerProperties properties, GrpcServiceDiscoverer discoverer) {
        NettyGrpcServerFactory factory = new NettyGrpcServerFactory(properties);
        for (GrpcServiceDefinition service : discoverer.findGrpcServices()) {
            factory.addService(service);
        }
        return factory;
    }

    @ConditionalOnMissingBean
    @Bean
    public GrpcServerLifecycle grpcServerLifecycle(GrpcServerFactory factory) {
        return new GrpcServerLifecycle(factory);
    }

    @Configuration
    @ConditionalOnProperty(value={"spring.sleuth.scheduled.enabled"}, matchIfMissing=true)
    @AutoConfigureAfter(value={TraceAutoConfiguration.class})
    @ConditionalOnClass(value={Tracing.class, GrpcTracing.class})
    protected static class TraceServerAutoConfiguration {
        protected TraceServerAutoConfiguration() {
        }

        @Bean
        public GrpcTracing grpcTracing(Tracing tracing) {
            return GrpcTracing.create((Tracing)tracing);
        }

        @Bean
        public GlobalServerInterceptorConfigurerAdapter globalTraceServerInterceptorConfigurerAdapter(final GrpcTracing grpcTracing) {
            return new GlobalServerInterceptorConfigurerAdapter(){

                @Override
                public void addServerInterceptors(GlobalServerInterceptorRegistry registry) {
                    registry.addServerInterceptors(grpcTracing.newServerInterceptor());
                }
            };
        }
    }
}

