/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.metric;

import io.grpc.ClientCall;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.Status;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.function.Function;
import net.devh.boot.grpc.client.metric.MetricCollectingClientCallListener;

class MetricCollectingClientCall<Q, A>
extends ForwardingClientCall.SimpleForwardingClientCall<Q, A> {
    private final MeterRegistry registry;
    private final Counter requestCounter;
    private final Counter responseCounter;
    private final Function<Status.Code, Timer> timerFunction;

    public MetricCollectingClientCall(ClientCall<Q, A> delegate, MeterRegistry registry, Counter requestCounter, Counter responseCounter, Function<Status.Code, Timer> timerFunction) {
        super(delegate);
        this.registry = registry;
        this.requestCounter = requestCounter;
        this.responseCounter = responseCounter;
        this.timerFunction = timerFunction;
    }

    public void start(ClientCall.Listener<A> responseListener, Metadata metadata) {
        super.start(new MetricCollectingClientCallListener<A>(responseListener, this.registry, this.responseCounter, this.timerFunction), metadata);
    }

    public void sendMessage(Q requestMessage) {
        this.requestCounter.increment();
        super.sendMessage(requestMessage);
    }
}

