/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.nameresolver;

import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import java.net.URI;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.devh.boot.grpc.client.config.GrpcChannelProperties;
import net.devh.boot.grpc.client.config.GrpcChannelsProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMappedNameResolverFactory
extends NameResolver.Factory {
    private static final Logger log = LoggerFactory.getLogger(ConfigMappedNameResolverFactory.class);
    private final GrpcChannelsProperties config;
    private final NameResolver.Factory delegate;
    private final Function<String, URI> defaultUriMapper;

    public ConfigMappedNameResolverFactory(GrpcChannelsProperties config, Function<String, URI> defaultUriMapper) {
        this(config, NameResolverProvider.asFactory(), defaultUriMapper);
    }

    public ConfigMappedNameResolverFactory(GrpcChannelsProperties config, NameResolver.Factory delegate, Function<String, URI> defaultUriMapper) {
        this.config = Objects.requireNonNull(config, "config");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.defaultUriMapper = Objects.requireNonNull(defaultUriMapper, "defaultUriMapper");
    }

    @Nullable
    @Deprecated
    public NameResolver newNameResolver(URI targetUri, NameResolver.Helper helper) {
        String clientName = targetUri.toString();
        GrpcChannelProperties clientConfig = this.config.getChannel(clientName);
        URI remappedUri = clientConfig.getAddress();
        if (remappedUri == null && (remappedUri = this.defaultUriMapper.apply(clientName)) == null) {
            throw new IllegalStateException("No targetUri provided for '" + clientName + "' and defaultUri mapper returned null.");
        }
        log.debug("Remapping target URI for {} to {} via {}", new Object[]{clientName, remappedUri, this.delegate});
        return this.delegate.newNameResolver(remappedUri, helper);
    }

    public String getDefaultScheme() {
        return "";
    }

    public String toString() {
        return "ConfigMappedNameResolverFactory [config=" + this.config + ", delegate=" + this.delegate + "]";
    }
}

