/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.metric;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.devh.boot.grpc.client.interceptor.GrpcGlobalClientInterceptor;
import net.devh.boot.grpc.client.metric.MetricCollectingClientCall;
import net.devh.boot.grpc.common.metric.AbstractMetricCollectingInterceptor;
import net.devh.boot.grpc.common.metric.MetricUtils;
import org.springframework.beans.factory.annotation.Autowired;

@GrpcGlobalClientInterceptor
public class MetricCollectingClientInterceptor
extends AbstractMetricCollectingInterceptor
implements ClientInterceptor {
    @Autowired
    public MetricCollectingClientInterceptor(MeterRegistry registry) {
        super(registry);
    }

    public MetricCollectingClientInterceptor(MeterRegistry registry, UnaryOperator<Counter.Builder> counterCustomizer, UnaryOperator<Timer.Builder> timerCustomizer, Status.Code ... eagerInitializedCodes) {
        super(registry, counterCustomizer, timerCustomizer, eagerInitializedCodes);
    }

    protected Counter newRequestCounterFor(MethodDescriptor<?, ?> method) {
        return ((Counter.Builder)this.counterCustomizer.apply(MetricUtils.prepareCounterFor(method, (String)"grpc.client.requests.sent", (String)"The total number of requests sent"))).register(this.registry);
    }

    protected Counter newResponseCounterFor(MethodDescriptor<?, ?> method) {
        return ((Counter.Builder)this.counterCustomizer.apply(MetricUtils.prepareCounterFor(method, (String)"grpc.client.responses.received", (String)"The total number of responses received"))).register(this.registry);
    }

    protected Function<Status.Code, Timer> newTimerFunction(MethodDescriptor<?, ?> method) {
        return this.asTimerFunction(() -> (Timer.Builder)this.timerCustomizer.apply(MetricUtils.prepareTimerFor((MethodDescriptor)method, (String)"grpc.client.processing.duration", (String)"The total time taken for the server to process the requests including network delay as observed by the client")));
    }

    public <Q, A> ClientCall<Q, A> interceptCall(MethodDescriptor<Q, A> methodDescriptor, CallOptions callOptions, Channel channel) {
        AbstractMetricCollectingInterceptor.MetricSet metrics = this.metricsFor(methodDescriptor);
        return new MetricCollectingClientCall(channel.newCall(methodDescriptor, callOptions), this.registry, metrics.getRequestCounter(), metrics.getResponseCounter(), metrics.getTimerFunction());
    }
}

