/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.channelfactory;

import com.google.common.collect.Lists;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import net.devh.boot.grpc.client.channelfactory.GrpcChannelConfigurer;
import net.devh.boot.grpc.client.channelfactory.GrpcChannelFactory;
import net.devh.boot.grpc.client.config.GrpcChannelProperties;
import net.devh.boot.grpc.client.config.GrpcChannelsProperties;
import net.devh.boot.grpc.client.config.NegotiationType;
import net.devh.boot.grpc.client.interceptor.GlobalClientInterceptorRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannelFactory<T extends ManagedChannelBuilder<T>>
implements GrpcChannelFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractChannelFactory.class);
    private final GrpcChannelsProperties properties;
    protected final GlobalClientInterceptorRegistry globalClientInterceptorRegistry;
    protected final List<GrpcChannelConfigurer> channelConfigurers;
    @GuardedBy(value="this")
    private final Map<String, ManagedChannel> channels = new ConcurrentHashMap<String, ManagedChannel>();
    private boolean shutdown = false;

    public AbstractChannelFactory(GrpcChannelsProperties properties, GlobalClientInterceptorRegistry globalClientInterceptorRegistry, List<GrpcChannelConfigurer> channelConfigurers) {
        this.properties = Objects.requireNonNull(properties, "properties");
        this.globalClientInterceptorRegistry = Objects.requireNonNull(globalClientInterceptorRegistry, "globalClientInterceptorRegistry");
        this.channelConfigurers = Objects.requireNonNull(channelConfigurers, "channelConfigurers");
    }

    @Override
    public final Channel createChannel(String name) {
        return this.createChannel(name, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel createChannel(String name, List<ClientInterceptor> customInterceptors) {
        Channel channel;
        AbstractChannelFactory abstractChannelFactory = this;
        synchronized (abstractChannelFactory) {
            if (this.shutdown) {
                throw new IllegalStateException("GrpcChannelFactory is already closed!");
            }
            channel = (Channel)this.channels.computeIfAbsent(name, this::newManagedChannel);
        }
        ArrayList interceptors = Lists.newArrayList();
        List<ClientInterceptor> globalInterceptors = this.globalClientInterceptorRegistry.getClientInterceptors();
        if (!globalInterceptors.isEmpty()) {
            interceptors.addAll(globalInterceptors);
        }
        if (!customInterceptors.isEmpty()) {
            interceptors.addAll(customInterceptors);
        }
        return ClientInterceptors.intercept((Channel)channel, (List)interceptors);
    }

    protected abstract T newChannelBuilder(String var1);

    protected ManagedChannel newManagedChannel(String name) {
        T builder = this.newChannelBuilder(name);
        this.configure(builder, name);
        return builder.build();
    }

    protected final GrpcChannelProperties getPropertiesFor(String name) {
        return this.properties.getChannel(name);
    }

    protected void configure(T builder, String name) {
        this.configureKeepAlive(builder, name);
        this.configureSecurity(builder, name);
        this.configureLimits(builder, name);
        this.configureCompression(builder, name);
        for (GrpcChannelConfigurer channelConfigurer : this.channelConfigurers) {
            channelConfigurer.accept(builder, name);
        }
    }

    protected void configureKeepAlive(T builder, String name) {
        GrpcChannelProperties properties = this.getPropertiesFor(name);
        if (properties.isEnableKeepAlive()) {
            builder.keepAliveTime(properties.getKeepAliveTime().toNanos(), TimeUnit.NANOSECONDS).keepAliveTimeout(properties.getKeepAliveTimeout().toNanos(), TimeUnit.NANOSECONDS).keepAliveWithoutCalls(properties.isKeepAliveWithoutCalls());
        }
    }

    protected void configureSecurity(T builder, String name) {
        GrpcChannelProperties properties = this.getPropertiesFor(name);
        GrpcChannelProperties.Security security = properties.getSecurity();
        if (properties.getNegotiationType() != NegotiationType.TLS || this.isNonNullAndNonBlank(security.getAuthorityOverride()) || this.isNonNullAndNonBlank(security.getCertificateChainPath()) || this.isNonNullAndNonBlank(security.getPrivateKeyPath()) || this.isNonNullAndNonBlank(security.getTrustCertCollectionPath())) {
            throw new IllegalStateException("Security is configured but this implementation does not support security!");
        }
    }

    protected File toCheckedFile(String context, String path) {
        if (!this.isNonNullAndNonBlank(path)) {
            throw new IllegalArgumentException(context + " path cannot be null or blank");
        }
        File file = new File(path);
        if (!file.isFile()) {
            String message = context + " file does not exist or path does not refer to a file: '" + file.getPath() + "'";
            if (!file.isAbsolute()) {
                message = message + " (" + file.getAbsolutePath() + ")";
            }
            throw new IllegalArgumentException(message);
        }
        return file;
    }

    protected boolean isNonNullAndNonBlank(String value) {
        return value != null && !value.trim().isEmpty();
    }

    protected void configureLimits(T builder, String name) {
        GrpcChannelProperties properties = this.getPropertiesFor(name);
        Integer maxInboundMessageSize = properties.getMaxInboundMessageSize();
        if (maxInboundMessageSize != null) {
            builder.maxInboundMessageSize(maxInboundMessageSize.intValue());
        }
    }

    protected void configureCompression(T builder, String name) {
        GrpcChannelProperties properties = this.getPropertiesFor(name);
        if (properties.isFullStreamDecompression()) {
            builder.enableFullStreamDecompression();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreDestroy
    public synchronized void close() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        for (ManagedChannel channel : this.channels.values()) {
            channel.shutdown();
        }
        try {
            long waitLimit = System.currentTimeMillis() + 60000L;
            for (ManagedChannel channel : this.channels.values()) {
                int i = 0;
                do {
                    log.debug("Awaiting channel shutdown: {} ({}s)", (Object)channel, (Object)i++);
                } while (System.currentTimeMillis() < waitLimit && !channel.awaitTermination(1L, TimeUnit.SECONDS));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.debug("We got interrupted - Speeding up shutdown process");
        }
        finally {
            for (ManagedChannel channel : this.channels.values()) {
                if (channel.isTerminated()) continue;
                log.debug("Channel not terminated yet - force shutdown now: {} ", (Object)channel);
                channel.shutdownNow();
            }
        }
        int channelCount = this.channels.size();
        this.channels.clear();
        log.debug("GrpcCannelFactory closed (including {} channels)", (Object)channelCount);
    }
}

