/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.channelfactory;

import io.grpc.LoadBalancer;
import io.grpc.NameResolver;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLException;
import net.devh.boot.grpc.client.channelfactory.AbstractChannelFactory;
import net.devh.boot.grpc.client.channelfactory.GrpcChannelConfigurer;
import net.devh.boot.grpc.client.config.GrpcChannelProperties;
import net.devh.boot.grpc.client.config.GrpcChannelsProperties;
import net.devh.boot.grpc.client.interceptor.GlobalClientInterceptorRegistry;

public class ShadedNettyChannelFactory
extends AbstractChannelFactory<NettyChannelBuilder> {
    private final LoadBalancer.Factory loadBalancerFactory;
    private final NameResolver.Factory nameResolverFactory;

    public ShadedNettyChannelFactory(GrpcChannelsProperties properties, LoadBalancer.Factory loadBalancerFactory, NameResolver.Factory nameResolverFactory, GlobalClientInterceptorRegistry globalClientInterceptorRegistry, List<GrpcChannelConfigurer> channelConfigurers) {
        super(properties, globalClientInterceptorRegistry, channelConfigurers);
        this.loadBalancerFactory = Objects.requireNonNull(loadBalancerFactory, "loadBalancerFactory");
        this.nameResolverFactory = Objects.requireNonNull(nameResolverFactory, "nameResolverFactory");
    }

    @Override
    protected NettyChannelBuilder newChannelBuilder(String name) {
        return (NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)name).loadBalancerFactory(this.loadBalancerFactory)).nameResolverFactory(this.nameResolverFactory);
    }

    @Override
    protected void configureSecurity(NettyChannelBuilder builder, String name) {
        GrpcChannelProperties properties = this.getPropertiesFor(name);
        net.devh.boot.grpc.client.config.NegotiationType negotiationType = properties.getNegotiationType();
        builder.negotiationType(ShadedNettyChannelFactory.of(negotiationType));
        if (negotiationType != net.devh.boot.grpc.client.config.NegotiationType.PLAINTEXT) {
            String trustCertCollectionPath;
            GrpcChannelProperties.Security security = properties.getSecurity();
            String authorityOverwrite = security.getAuthorityOverride();
            if (authorityOverwrite != null && !authorityOverwrite.isEmpty()) {
                builder.overrideAuthority(authorityOverwrite);
            }
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
            if (security.isClientAuthEnabled()) {
                File keyCertChainFile = this.toCheckedFile("keyCertChain", security.getCertificateChainPath());
                File privateKeyFile = this.toCheckedFile("privateKey", security.getPrivateKeyPath());
                sslContextBuilder.keyManager(keyCertChainFile, privateKeyFile);
            }
            if ((trustCertCollectionPath = security.getTrustCertCollectionPath()) != null && !trustCertCollectionPath.isEmpty()) {
                File trustCertCollectionFile = this.toCheckedFile("trustCertCollection", trustCertCollectionPath);
                sslContextBuilder.trustManager(trustCertCollectionFile);
            }
            try {
                builder.sslContext(sslContextBuilder.build());
            }
            catch (SSLException e) {
                throw new IllegalStateException("Failed to create ssl context for grpc client", e);
            }
        }
    }

    protected static NegotiationType of(net.devh.boot.grpc.client.config.NegotiationType negotiationType) {
        switch (negotiationType) {
            case PLAINTEXT: {
                return NegotiationType.PLAINTEXT;
            }
            case PLAINTEXT_UPGRADE: {
                return NegotiationType.PLAINTEXT_UPGRADE;
            }
            case TLS: {
                return NegotiationType.TLS;
            }
        }
        throw new IllegalArgumentException("Unsupported NegotiationType: " + (Object)((Object)negotiationType));
    }
}

