/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.nameresolver;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.SharedResourceHolder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.devh.boot.grpc.client.nameresolver.DiscoveryClientResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.util.CollectionUtils;

public class DiscoveryClientNameResolver
extends NameResolver {
    private static final Logger log = LoggerFactory.getLogger(DiscoveryClientNameResolver.class);
    @Deprecated
    private static final String LEGACY_CLOUD_DISCOVERY_METADATA_PORT = "gRPC.port";
    private static final List<ServiceInstance> KEEP_PREVIOUS = null;
    private final String name;
    private final DiscoveryClient client;
    private final SynchronizationContext syncContext;
    private final Consumer<DiscoveryClientNameResolver> shutdownHook;
    private final SharedResourceHolder.Resource<Executor> executorResource;
    private final boolean usingExecutorResource;
    private NameResolver.Listener2 listener;
    private Executor executor;
    private boolean resolving;
    private List<ServiceInstance> instanceList = Lists.newArrayList();

    public DiscoveryClientNameResolver(String name, DiscoveryClient client, NameResolver.Args args, SharedResourceHolder.Resource<Executor> executorResource, Consumer<DiscoveryClientNameResolver> shutdownHook) {
        this.name = name;
        this.client = client;
        this.syncContext = Objects.requireNonNull(args.getSynchronizationContext(), "syncContext");
        this.shutdownHook = shutdownHook;
        this.executor = args.getOffloadExecutor();
        this.usingExecutorResource = this.executor == null;
        this.executorResource = executorResource;
    }

    protected final String getName() {
        return this.name;
    }

    protected final boolean isActive() {
        return this.listener != null;
    }

    public final String getServiceAuthority() {
        return this.name;
    }

    public void start(NameResolver.Listener2 listener) {
        Preconditions.checkState((!this.isActive() ? 1 : 0) != 0, (Object)"already started");
        if (this.usingExecutorResource) {
            this.executor = (Executor)SharedResourceHolder.get(this.executorResource);
        }
        this.listener = (NameResolver.Listener2)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        this.resolve();
    }

    public void refresh() {
        Preconditions.checkState((boolean)this.isActive(), (Object)"not started");
        this.resolve();
    }

    public void refreshFromExternal() {
        this.syncContext.execute(() -> {
            if (this.isActive()) {
                this.resolve();
            }
        });
    }

    protected List<ServiceInstance> discoverServers() {
        return this.client.getInstances(this.name);
    }

    protected int getGrpcPort(ServiceInstance instance) {
        Map metadata = instance.getMetadata();
        if (metadata == null || metadata.isEmpty()) {
            return instance.getPort();
        }
        String portString = (String)metadata.get("gRPC_port");
        if (portString == null) {
            portString = (String)metadata.get(LEGACY_CLOUD_DISCOVERY_METADATA_PORT);
            if (portString == null) {
                return instance.getPort();
            }
            log.warn("Found legacy grpc port metadata '{}' for client '{}' use '{}' instead", new Object[]{LEGACY_CLOUD_DISCOVERY_METADATA_PORT, this.getName(), "gRPC_port"});
        }
        try {
            return Integer.parseInt(portString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse gRPC port information from: " + instance, e);
        }
    }

    protected Attributes getAttributes(ServiceInstance serviceInstance) {
        Attributes.Builder builder = Attributes.newBuilder();
        builder.set(DiscoveryClientResolverFactory.DISCOVERY_SERVICE_NAME_KEY, (Object)this.name);
        builder.set(DiscoveryClientResolverFactory.DISCOVERY_INSTANCE_ID_KEY, (Object)serviceInstance.getInstanceId());
        return builder.build();
    }

    protected boolean needsToUpdateConnections(List<ServiceInstance> newInstanceList) {
        if (this.instanceList.size() != newInstanceList.size()) {
            return true;
        }
        for (ServiceInstance instance : this.instanceList) {
            int port = this.getGrpcPort(instance);
            boolean isSame = false;
            for (ServiceInstance newInstance : newInstanceList) {
                int newPort = this.getGrpcPort(newInstance);
                if (!newInstance.getHost().equals(instance.getHost()) || port != newPort) continue;
                isSame = true;
                break;
            }
            if (isSame) continue;
            return true;
        }
        return false;
    }

    private void resolve() {
        log.debug("Scheduled resolve for {}", (Object)this.name);
        if (this.resolving) {
            return;
        }
        this.resolving = true;
        this.executor.execute(new Resolve(this.listener));
    }

    public void shutdown() {
        this.listener = null;
        if (this.executor != null && this.usingExecutorResource) {
            this.executor = (Executor)SharedResourceHolder.release(this.executorResource, (Object)this.executor);
        }
        this.instanceList = Lists.newArrayList();
        if (this.shutdownHook != null) {
            this.shutdownHook.accept(this);
        }
    }

    public String toString() {
        return "DiscoveryClientNameResolver [name=" + this.name + ", discoveryClient=" + this.client + "]";
    }

    private final class Resolve
    implements Runnable {
        private final NameResolver.Listener2 savedListener;

        Resolve(NameResolver.Listener2 listener) {
            this.savedListener = Objects.requireNonNull(listener, "listener");
        }

        @Override
        public void run() {
            AtomicReference<List> resultContainer = new AtomicReference<List>(KEEP_PREVIOUS);
            try {
                resultContainer.set(this.resolveInternal());
            }
            catch (Exception e) {
                this.savedListener.onError(Status.UNAVAILABLE.withCause((Throwable)e).withDescription("Failed to update server list for " + DiscoveryClientNameResolver.this.getName()));
                resultContainer.set(Lists.newArrayList());
            }
            finally {
                DiscoveryClientNameResolver.this.syncContext.execute(() -> {
                    DiscoveryClientNameResolver.this.resolving = false;
                    List result = (List)resultContainer.get();
                    if (result != KEEP_PREVIOUS && DiscoveryClientNameResolver.this.isActive()) {
                        DiscoveryClientNameResolver.this.instanceList = result;
                    }
                });
            }
        }

        private List<ServiceInstance> resolveInternal() {
            List<ServiceInstance> newInstanceList = DiscoveryClientNameResolver.this.discoverServers();
            if (CollectionUtils.isEmpty(newInstanceList)) {
                log.error("No servers found for {}", (Object)DiscoveryClientNameResolver.this.getName());
                this.savedListener.onError(Status.UNAVAILABLE.withDescription("No servers found for " + DiscoveryClientNameResolver.this.getName()));
                return Lists.newArrayList();
            }
            log.debug("Got {} candidate servers for {}", (Object)newInstanceList.size(), (Object)DiscoveryClientNameResolver.this.getName());
            if (!DiscoveryClientNameResolver.this.needsToUpdateConnections(newInstanceList)) {
                log.debug("Nothing has changed... skipping update for {}", (Object)DiscoveryClientNameResolver.this.getName());
                return KEEP_PREVIOUS;
            }
            log.debug("Ready to update server list for {}", (Object)DiscoveryClientNameResolver.this.getName());
            this.savedListener.onResult(NameResolver.ResolutionResult.newBuilder().setAddresses(this.toTargets(newInstanceList)).build());
            log.info("Done updating server list for {}", (Object)DiscoveryClientNameResolver.this.getName());
            return newInstanceList;
        }

        private List<EquivalentAddressGroup> toTargets(List<ServiceInstance> newInstanceList) {
            ArrayList targets = Lists.newArrayList();
            for (ServiceInstance instance : newInstanceList) {
                targets.add(this.toTarget(instance));
            }
            return targets;
        }

        private EquivalentAddressGroup toTarget(ServiceInstance instance) {
            String host = instance.getHost();
            int port = DiscoveryClientNameResolver.this.getGrpcPort(instance);
            Attributes attributes = DiscoveryClientNameResolver.this.getAttributes(instance);
            log.debug("Found gRPC server {}:{} for {}", new Object[]{host, port, DiscoveryClientNameResolver.this.getName()});
            return new EquivalentAddressGroup((SocketAddress)new InetSocketAddress(host, port), attributes);
        }
    }
}

