/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.channelfactory;

import com.google.common.collect.Lists;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import net.devh.boot.grpc.client.channelfactory.GrpcChannelConfigurer;
import net.devh.boot.grpc.client.channelfactory.GrpcChannelFactory;
import net.devh.boot.grpc.client.config.GrpcChannelProperties;
import net.devh.boot.grpc.client.config.GrpcChannelsProperties;
import net.devh.boot.grpc.client.config.NegotiationType;
import net.devh.boot.grpc.client.interceptor.GlobalClientInterceptorRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.unit.DataSize;

public abstract class AbstractChannelFactory<T extends ManagedChannelBuilder<T>>
implements GrpcChannelFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractChannelFactory.class);
    private final GrpcChannelsProperties properties;
    protected final GlobalClientInterceptorRegistry globalClientInterceptorRegistry;
    protected final List<GrpcChannelConfigurer> channelConfigurers;
    @GuardedBy(value="this")
    private final Map<String, ManagedChannel> channels = new ConcurrentHashMap<String, ManagedChannel>();
    private final Map<String, ConnectivityState> channelStates = new ConcurrentHashMap<String, ConnectivityState>();
    private boolean shutdown = false;

    public AbstractChannelFactory(GrpcChannelsProperties properties, GlobalClientInterceptorRegistry globalClientInterceptorRegistry, List<GrpcChannelConfigurer> channelConfigurers) {
        this.properties = Objects.requireNonNull(properties, "properties");
        this.globalClientInterceptorRegistry = Objects.requireNonNull(globalClientInterceptorRegistry, "globalClientInterceptorRegistry");
        this.channelConfigurers = Objects.requireNonNull(channelConfigurers, "channelConfigurers");
    }

    @Override
    public final Channel createChannel(String name) {
        return this.createChannel(name, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel createChannel(String name, List<ClientInterceptor> customInterceptors, boolean sortInterceptors) {
        Channel channel;
        AbstractChannelFactory abstractChannelFactory = this;
        synchronized (abstractChannelFactory) {
            if (this.shutdown) {
                throw new IllegalStateException("GrpcChannelFactory is already closed!");
            }
            channel = (Channel)this.channels.computeIfAbsent(name, this::newManagedChannel);
        }
        ArrayList interceptors = Lists.newArrayList(this.globalClientInterceptorRegistry.getClientInterceptors());
        interceptors.addAll(customInterceptors);
        if (sortInterceptors) {
            this.globalClientInterceptorRegistry.sortInterceptors(interceptors);
        }
        return ClientInterceptors.interceptForward((Channel)channel, (List)interceptors);
    }

    protected abstract T newChannelBuilder(String var1);

    protected ManagedChannel newManagedChannel(String name) {
        T builder = this.newChannelBuilder(name);
        this.configure(builder, name);
        ManagedChannel channel = builder.build();
        Duration timeout = this.properties.getChannel(name).getImmediateConnectTimeout();
        if (!timeout.isZero()) {
            this.connectOnStartup(name, channel, timeout);
        }
        this.watchConnectivityState(name, channel);
        return channel;
    }

    protected final GrpcChannelProperties getPropertiesFor(String name) {
        return this.properties.getChannel(name);
    }

    protected void configure(T builder, String name) {
        this.configureKeepAlive(builder, name);
        this.configureSecurity(builder, name);
        this.configureLimits(builder, name);
        this.configureCompression(builder, name);
        for (GrpcChannelConfigurer channelConfigurer : this.channelConfigurers) {
            channelConfigurer.accept(builder, name);
        }
    }

    protected void configureKeepAlive(T builder, String name) {
        GrpcChannelProperties properties = this.getPropertiesFor(name);
        if (properties.isEnableKeepAlive()) {
            builder.keepAliveTime(properties.getKeepAliveTime().toNanos(), TimeUnit.NANOSECONDS).keepAliveTimeout(properties.getKeepAliveTimeout().toNanos(), TimeUnit.NANOSECONDS).keepAliveWithoutCalls(properties.isKeepAliveWithoutCalls());
        }
    }

    protected void configureSecurity(T builder, String name) {
        GrpcChannelProperties properties = this.getPropertiesFor(name);
        GrpcChannelProperties.Security security = properties.getSecurity();
        if (properties.getNegotiationType() != NegotiationType.TLS || this.isNonNullAndNonBlank(security.getAuthorityOverride()) || security.getCertificateChain() != null || security.getPrivateKey() != null || security.getTrustCertCollection() != null) {
            throw new IllegalStateException("Security is configured but this implementation does not support security!");
        }
    }

    protected boolean isNonNullAndNonBlank(String value) {
        return value != null && !value.trim().isEmpty();
    }

    protected void configureLimits(T builder, String name) {
        GrpcChannelProperties properties = this.getPropertiesFor(name);
        DataSize maxInboundMessageSize = properties.getMaxInboundMessageSize();
        if (maxInboundMessageSize != null) {
            builder.maxInboundMessageSize((int)maxInboundMessageSize.toBytes());
        }
    }

    protected void configureCompression(T builder, String name) {
        GrpcChannelProperties properties = this.getPropertiesFor(name);
        if (properties.isFullStreamDecompression()) {
            builder.enableFullStreamDecompression();
        }
    }

    @Override
    public Map<String, ConnectivityState> getConnectivityState() {
        return Collections.unmodifiableMap(this.channelStates);
    }

    protected void watchConnectivityState(String name, ManagedChannel channel) {
        ConnectivityState state = channel.getState(false);
        this.channelStates.put(name, state);
        if (state != ConnectivityState.SHUTDOWN) {
            channel.notifyWhenStateChanged(state, () -> this.watchConnectivityState(name, channel));
        }
    }

    private void connectOnStartup(String name, ManagedChannel channel, Duration timeout) {
        boolean connected;
        log.debug("Initiating connection to channel {}", (Object)name);
        channel.getState(true);
        CountDownLatch readyLatch = new CountDownLatch(1);
        this.waitForReady(channel, readyLatch);
        try {
            log.debug("Waiting for connection to channel {}", (Object)name);
            connected = !readyLatch.await(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            connected = false;
        }
        if (connected) {
            throw new IllegalStateException("Can't connect to channel " + name);
        }
        log.info("Successfully connected to channel {}", (Object)name);
    }

    private void waitForReady(ManagedChannel channel, CountDownLatch readySignal) {
        ConnectivityState state = channel.getState(false);
        log.debug("Waiting for ready state. Currently in {}", (Object)state);
        if (state == ConnectivityState.READY) {
            readySignal.countDown();
        } else {
            channel.notifyWhenStateChanged(state, () -> this.waitForReady(channel, readySignal));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreDestroy
    public synchronized void close() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        ArrayList<ShutdownRecord> shutdownEntries = new ArrayList<ShutdownRecord>();
        for (Map.Entry<String, ManagedChannel> entry : this.channels.entrySet()) {
            ManagedChannel channel = entry.getValue();
            channel.shutdown();
            long gracePeriod = this.properties.getChannel(entry.getKey()).getShutdownGracePeriod().toMillis();
            shutdownEntries.add(new ShutdownRecord(entry.getKey(), channel, gracePeriod));
        }
        try {
            long start = System.currentTimeMillis();
            shutdownEntries.sort(Comparator.comparingLong(ShutdownRecord::getGracePeriod));
            for (ShutdownRecord entry : shutdownEntries) {
                if (!entry.channel.isTerminated()) {
                    log.debug("Awaiting channel termination: {}", (Object)entry.name);
                    long waitedTime = System.currentTimeMillis() - start;
                    long waitTime = entry.gracePeriod - waitedTime;
                    if (waitTime > 0L) {
                        entry.channel.awaitTermination(waitTime, TimeUnit.MILLISECONDS);
                    }
                    entry.channel.shutdownNow();
                }
                log.debug("Completed channel termination: {}", (Object)entry.name);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.debug("We got interrupted - Speeding up shutdown process");
        }
        finally {
            for (ManagedChannel channel : this.channels.values()) {
                if (channel.isTerminated()) continue;
                log.debug("Channel not terminated yet - force shutdown now: {} ", (Object)channel);
                channel.shutdownNow();
            }
        }
        int channelCount = this.channels.size();
        this.channels.clear();
        this.channelStates.clear();
        log.debug("GrpcChannelFactory closed (including {} channels)", (Object)channelCount);
    }

    private static class ShutdownRecord {
        private final String name;
        private final ManagedChannel channel;
        private final long gracePeriod;

        public ShutdownRecord(String name, ManagedChannel channel, long gracePeriod) {
            this.name = name;
            this.channel = channel;
            this.gracePeriod = gracePeriod < 0L ? Long.MAX_VALUE : gracePeriod;
        }

        long getGracePeriod() {
            return this.gracePeriod;
        }
    }
}

