/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.nameresolver;

import com.google.common.collect.ImmutableList;
import io.grpc.NameResolverProvider;
import io.grpc.NameResolverRegistry;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class NameResolverRegistration
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(NameResolverRegistration.class);
    private final List<NameResolverRegistry> registries = new ArrayList<NameResolverRegistry>(1);
    private final List<NameResolverProvider> providers;

    public NameResolverRegistration(List<NameResolverProvider> providers) {
        this.providers = providers == null ? ImmutableList.of() : ImmutableList.copyOf(providers);
    }

    public void register(NameResolverRegistry registry) {
        this.registries.add(registry);
        for (NameResolverProvider provider : this.providers) {
            try {
                registry.register(provider);
                log.debug("{} is available -> Added to the NameResolverRegistry", (Object)provider);
            }
            catch (IllegalArgumentException e) {
                log.debug("{} is not available -> Not added to the NameResolverRegistry", (Object)provider);
            }
        }
    }

    public void destroy() {
        for (NameResolverRegistry registry : this.registries) {
            for (NameResolverProvider provider : this.providers) {
                registry.deregister(provider);
                log.debug("{} was removed from the NameResolverRegistry", (Object)provider);
            }
        }
        this.registries.clear();
    }
}

