/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.config;

import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import net.devh.boot.grpc.client.config.NegotiationType;
import org.springframework.boot.convert.DataSizeUnit;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.core.io.Resource;
import org.springframework.util.unit.DataSize;
import org.springframework.util.unit.DataUnit;

public class GrpcChannelProperties {
    private URI address = null;
    private String defaultLoadBalancingPolicy;
    private static final String DEFAULT_DEFAULT_LOAD_BALANCING_POLICY = "round_robin";
    private Boolean enableKeepAlive;
    private static final boolean DEFAULT_ENABLE_KEEP_ALIVE = false;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration keepAliveTime;
    private static final Duration DEFAULT_KEEP_ALIVE_TIME = Duration.of(60L, ChronoUnit.SECONDS);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration keepAliveTimeout;
    private static final Duration DEFAULT_KEEP_ALIVE_TIMEOUT = Duration.of(20L, ChronoUnit.SECONDS);
    private Boolean keepAliveWithoutCalls;
    private static final boolean DEFAULT_KEEP_ALIVE_WITHOUT_CALLS = false;
    @DataSizeUnit(value=DataUnit.BYTES)
    private DataSize maxInboundMessageSize = null;
    private Boolean fullStreamDecompression;
    private static final boolean DEFAULT_FULL_STREAM_DECOMPRESSION = false;
    private NegotiationType negotiationType;
    private static final NegotiationType DEFAULT_NEGOTIATION_TYPE = NegotiationType.TLS;
    private Duration immediateConnectTimeout;
    private static final Duration DEFAULT_IMMEDIATE_CONNECT = Duration.ZERO;
    private final Security security = new Security();

    public URI getAddress() {
        return this.address;
    }

    public void setAddress(URI address) {
        this.address = address;
    }

    public void setAddress(String address) {
        this.address = address == null ? null : URI.create(address);
    }

    public String getDefaultLoadBalancingPolicy() {
        return this.defaultLoadBalancingPolicy == null ? DEFAULT_DEFAULT_LOAD_BALANCING_POLICY : this.defaultLoadBalancingPolicy;
    }

    public void setDefaultLoadBalancingPolicy(String defaultLoadBalancingPolicy) {
        this.defaultLoadBalancingPolicy = defaultLoadBalancingPolicy;
    }

    public boolean isEnableKeepAlive() {
        return this.enableKeepAlive == null ? false : this.enableKeepAlive;
    }

    public void setEnableKeepAlive(Boolean enableKeepAlive) {
        this.enableKeepAlive = enableKeepAlive;
    }

    public Duration getKeepAliveTime() {
        return this.keepAliveTime == null ? DEFAULT_KEEP_ALIVE_TIME : this.keepAliveTime;
    }

    public void setKeepAliveTime(Duration keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public Duration getKeepAliveTimeout() {
        return this.keepAliveTimeout == null ? DEFAULT_KEEP_ALIVE_TIMEOUT : this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(Duration keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public boolean isKeepAliveWithoutCalls() {
        return this.keepAliveWithoutCalls == null ? false : this.keepAliveWithoutCalls;
    }

    public void setKeepAliveWithoutCalls(Boolean keepAliveWithoutCalls) {
        this.keepAliveWithoutCalls = keepAliveWithoutCalls;
    }

    public DataSize getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public void setMaxInboundMessageSize(DataSize maxInboundMessageSize) {
        if (maxInboundMessageSize == null || maxInboundMessageSize.toBytes() >= 0L) {
            this.maxInboundMessageSize = maxInboundMessageSize;
        } else if (maxInboundMessageSize.toBytes() == -1L) {
            this.maxInboundMessageSize = DataSize.ofBytes((long)Integer.MAX_VALUE);
        } else {
            throw new IllegalArgumentException("Unsupported maxInboundMessageSize: " + maxInboundMessageSize);
        }
    }

    public boolean isFullStreamDecompression() {
        return this.fullStreamDecompression == null ? false : this.fullStreamDecompression;
    }

    public void setFullStreamDecompression(Boolean fullStreamDecompression) {
        this.fullStreamDecompression = fullStreamDecompression;
    }

    public NegotiationType getNegotiationType() {
        return this.negotiationType == null ? DEFAULT_NEGOTIATION_TYPE : this.negotiationType;
    }

    public void setNegotiationType(NegotiationType negotiationType) {
        this.negotiationType = negotiationType;
    }

    public Duration getImmediateConnectTimeout() {
        return this.immediateConnectTimeout == null ? DEFAULT_IMMEDIATE_CONNECT : this.immediateConnectTimeout;
    }

    public void setImmediateConnectTimeout(Duration immediateConnectTimeout) {
        if (immediateConnectTimeout.isNegative()) {
            throw new IllegalArgumentException("Timeout can't be negative");
        }
        this.immediateConnectTimeout = immediateConnectTimeout;
    }

    public Security getSecurity() {
        return this.security;
    }

    public void copyDefaultsFrom(GrpcChannelProperties config) {
        if (this == config) {
            return;
        }
        if (this.address == null) {
            this.address = config.address;
        }
        if (this.defaultLoadBalancingPolicy == null) {
            this.defaultLoadBalancingPolicy = config.defaultLoadBalancingPolicy;
        }
        if (this.enableKeepAlive == null) {
            this.enableKeepAlive = config.enableKeepAlive;
        }
        if (this.keepAliveTime == null) {
            this.keepAliveTime = config.keepAliveTime;
        }
        if (this.keepAliveTimeout == null) {
            this.keepAliveTimeout = config.keepAliveTimeout;
        }
        if (this.keepAliveWithoutCalls == null) {
            this.keepAliveWithoutCalls = config.keepAliveWithoutCalls;
        }
        if (this.maxInboundMessageSize == null) {
            this.maxInboundMessageSize = config.maxInboundMessageSize;
        }
        if (this.fullStreamDecompression == null) {
            this.fullStreamDecompression = config.fullStreamDecompression;
        }
        if (this.negotiationType == null) {
            this.negotiationType = config.negotiationType;
        }
        if (this.immediateConnectTimeout == null) {
            this.immediateConnectTimeout = config.immediateConnectTimeout;
        }
        this.security.copyDefaultsFrom(config.security);
    }

    public String toString() {
        return "GrpcChannelProperties(address=" + this.getAddress() + ", defaultLoadBalancingPolicy=" + this.getDefaultLoadBalancingPolicy() + ", enableKeepAlive=" + this.enableKeepAlive + ", keepAliveTime=" + this.getKeepAliveTime() + ", keepAliveTimeout=" + this.getKeepAliveTimeout() + ", keepAliveWithoutCalls=" + this.keepAliveWithoutCalls + ", maxInboundMessageSize=" + this.getMaxInboundMessageSize() + ", fullStreamDecompression=" + this.fullStreamDecompression + ", negotiationType=" + (Object)((Object)this.getNegotiationType()) + ", immediateConnectTimeout=" + this.getImmediateConnectTimeout() + ", security=" + this.getSecurity() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrpcChannelProperties)) {
            return false;
        }
        GrpcChannelProperties other = (GrpcChannelProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        URI this$address = this.getAddress();
        URI other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        String this$defaultLoadBalancingPolicy = this.getDefaultLoadBalancingPolicy();
        String other$defaultLoadBalancingPolicy = other.getDefaultLoadBalancingPolicy();
        if (this$defaultLoadBalancingPolicy == null ? other$defaultLoadBalancingPolicy != null : !this$defaultLoadBalancingPolicy.equals(other$defaultLoadBalancingPolicy)) {
            return false;
        }
        Boolean this$enableKeepAlive = this.enableKeepAlive;
        Boolean other$enableKeepAlive = other.enableKeepAlive;
        if (this$enableKeepAlive == null ? other$enableKeepAlive != null : !((Object)this$enableKeepAlive).equals(other$enableKeepAlive)) {
            return false;
        }
        Duration this$keepAliveTime = this.getKeepAliveTime();
        Duration other$keepAliveTime = other.getKeepAliveTime();
        if (this$keepAliveTime == null ? other$keepAliveTime != null : !((Object)this$keepAliveTime).equals(other$keepAliveTime)) {
            return false;
        }
        Duration this$keepAliveTimeout = this.getKeepAliveTimeout();
        Duration other$keepAliveTimeout = other.getKeepAliveTimeout();
        if (this$keepAliveTimeout == null ? other$keepAliveTimeout != null : !((Object)this$keepAliveTimeout).equals(other$keepAliveTimeout)) {
            return false;
        }
        Boolean this$keepAliveWithoutCalls = this.keepAliveWithoutCalls;
        Boolean other$keepAliveWithoutCalls = other.keepAliveWithoutCalls;
        if (this$keepAliveWithoutCalls == null ? other$keepAliveWithoutCalls != null : !((Object)this$keepAliveWithoutCalls).equals(other$keepAliveWithoutCalls)) {
            return false;
        }
        DataSize this$maxInboundMessageSize = this.getMaxInboundMessageSize();
        DataSize other$maxInboundMessageSize = other.getMaxInboundMessageSize();
        if (this$maxInboundMessageSize == null ? other$maxInboundMessageSize != null : !this$maxInboundMessageSize.equals(other$maxInboundMessageSize)) {
            return false;
        }
        Boolean this$fullStreamDecompression = this.fullStreamDecompression;
        Boolean other$fullStreamDecompression = other.fullStreamDecompression;
        if (this$fullStreamDecompression == null ? other$fullStreamDecompression != null : !((Object)this$fullStreamDecompression).equals(other$fullStreamDecompression)) {
            return false;
        }
        NegotiationType this$negotiationType = this.getNegotiationType();
        NegotiationType other$negotiationType = other.getNegotiationType();
        if (this$negotiationType == null ? other$negotiationType != null : !((Object)((Object)this$negotiationType)).equals((Object)other$negotiationType)) {
            return false;
        }
        Duration this$immediateConnectTimeout = this.getImmediateConnectTimeout();
        Duration other$immediateConnectTimeout = other.getImmediateConnectTimeout();
        if (this$immediateConnectTimeout == null ? other$immediateConnectTimeout != null : !((Object)this$immediateConnectTimeout).equals(other$immediateConnectTimeout)) {
            return false;
        }
        Security this$security = this.getSecurity();
        Security other$security = other.getSecurity();
        return !(this$security == null ? other$security != null : !((Object)this$security).equals(other$security));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GrpcChannelProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        String $defaultLoadBalancingPolicy = this.getDefaultLoadBalancingPolicy();
        result = result * 59 + ($defaultLoadBalancingPolicy == null ? 43 : $defaultLoadBalancingPolicy.hashCode());
        Boolean $enableKeepAlive = this.enableKeepAlive;
        result = result * 59 + ($enableKeepAlive == null ? 43 : ((Object)$enableKeepAlive).hashCode());
        Duration $keepAliveTime = this.getKeepAliveTime();
        result = result * 59 + ($keepAliveTime == null ? 43 : ((Object)$keepAliveTime).hashCode());
        Duration $keepAliveTimeout = this.getKeepAliveTimeout();
        result = result * 59 + ($keepAliveTimeout == null ? 43 : ((Object)$keepAliveTimeout).hashCode());
        Boolean $keepAliveWithoutCalls = this.keepAliveWithoutCalls;
        result = result * 59 + ($keepAliveWithoutCalls == null ? 43 : ((Object)$keepAliveWithoutCalls).hashCode());
        DataSize $maxInboundMessageSize = this.getMaxInboundMessageSize();
        result = result * 59 + ($maxInboundMessageSize == null ? 43 : $maxInboundMessageSize.hashCode());
        Boolean $fullStreamDecompression = this.fullStreamDecompression;
        result = result * 59 + ($fullStreamDecompression == null ? 43 : ((Object)$fullStreamDecompression).hashCode());
        NegotiationType $negotiationType = this.getNegotiationType();
        result = result * 59 + ($negotiationType == null ? 43 : ((Object)((Object)$negotiationType)).hashCode());
        Duration $immediateConnectTimeout = this.getImmediateConnectTimeout();
        result = result * 59 + ($immediateConnectTimeout == null ? 43 : ((Object)$immediateConnectTimeout).hashCode());
        Security $security = this.getSecurity();
        result = result * 59 + ($security == null ? 43 : ((Object)$security).hashCode());
        return result;
    }

    public static class Security {
        private Boolean clientAuthEnabled;
        private static final boolean DEFAULT_CLIENT_AUTH_ENABLED = false;
        private Resource certificateChain = null;
        private Resource privateKey = null;
        private String privateKeyPassword = null;
        private Resource trustCertCollection = null;
        private String authorityOverride = null;
        private List<String> ciphers = null;
        private String[] protocols = null;

        public boolean isClientAuthEnabled() {
            return this.clientAuthEnabled == null ? false : this.clientAuthEnabled;
        }

        public void setClientAuthEnabled(Boolean clientAuthEnabled) {
            this.clientAuthEnabled = clientAuthEnabled;
        }

        public Resource getCertificateChain() {
            return this.certificateChain;
        }

        public void setCertificateChain(Resource certificateChain) {
            this.certificateChain = certificateChain;
        }

        public Resource getPrivateKey() {
            return this.privateKey;
        }

        public void setPrivateKey(Resource privateKey) {
            this.privateKey = privateKey;
        }

        public String getPrivateKeyPassword() {
            return this.privateKeyPassword;
        }

        public void setPrivateKeyPassword(String privateKeyPassword) {
            this.privateKeyPassword = privateKeyPassword;
        }

        public Resource getTrustCertCollection() {
            return this.trustCertCollection;
        }

        public void setTrustCertCollection(Resource trustCertCollection) {
            this.trustCertCollection = trustCertCollection;
        }

        public String getAuthorityOverride() {
            return this.authorityOverride;
        }

        public void setAuthorityOverride(String authorityOverride) {
            this.authorityOverride = authorityOverride;
        }

        public List<String> getCiphers() {
            return this.ciphers;
        }

        public void setCiphers(String ciphers) {
            this.ciphers = ciphers == null ? null : Arrays.asList(ciphers.split("[ :,]"));
        }

        public String[] getProtocols() {
            return this.protocols;
        }

        public void setProtocols(String protocols) {
            this.protocols = protocols == null ? null : protocols.split("[ :,]");
        }

        public void copyDefaultsFrom(Security config) {
            if (this == config) {
                return;
            }
            if (this.clientAuthEnabled == null) {
                this.clientAuthEnabled = config.clientAuthEnabled;
            }
            if (this.certificateChain == null) {
                this.certificateChain = config.certificateChain;
            }
            if (this.privateKey == null) {
                this.privateKey = config.privateKey;
            }
            if (this.privateKeyPassword == null) {
                this.privateKeyPassword = config.privateKeyPassword;
            }
            if (this.trustCertCollection == null) {
                this.trustCertCollection = config.trustCertCollection;
            }
            if (this.authorityOverride == null) {
                this.authorityOverride = config.authorityOverride;
            }
            if (this.ciphers == null) {
                this.ciphers = config.ciphers;
            }
            if (this.protocols == null) {
                this.protocols = config.protocols;
            }
        }

        public String toString() {
            return "GrpcChannelProperties.Security(clientAuthEnabled=" + this.clientAuthEnabled + ", certificateChain=" + this.getCertificateChain() + ", privateKey=" + this.getPrivateKey() + ", privateKeyPassword=" + this.getPrivateKeyPassword() + ", trustCertCollection=" + this.getTrustCertCollection() + ", authorityOverride=" + this.getAuthorityOverride() + ", ciphers=" + this.getCiphers() + ", protocols=" + Arrays.deepToString(this.getProtocols()) + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Security)) {
                return false;
            }
            Security other = (Security)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$clientAuthEnabled = this.clientAuthEnabled;
            Boolean other$clientAuthEnabled = other.clientAuthEnabled;
            if (this$clientAuthEnabled == null ? other$clientAuthEnabled != null : !((Object)this$clientAuthEnabled).equals(other$clientAuthEnabled)) {
                return false;
            }
            Resource this$certificateChain = this.getCertificateChain();
            Resource other$certificateChain = other.getCertificateChain();
            if (this$certificateChain == null ? other$certificateChain != null : !this$certificateChain.equals(other$certificateChain)) {
                return false;
            }
            Resource this$privateKey = this.getPrivateKey();
            Resource other$privateKey = other.getPrivateKey();
            if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
                return false;
            }
            String this$privateKeyPassword = this.getPrivateKeyPassword();
            String other$privateKeyPassword = other.getPrivateKeyPassword();
            if (this$privateKeyPassword == null ? other$privateKeyPassword != null : !this$privateKeyPassword.equals(other$privateKeyPassword)) {
                return false;
            }
            Resource this$trustCertCollection = this.getTrustCertCollection();
            Resource other$trustCertCollection = other.getTrustCertCollection();
            if (this$trustCertCollection == null ? other$trustCertCollection != null : !this$trustCertCollection.equals(other$trustCertCollection)) {
                return false;
            }
            String this$authorityOverride = this.getAuthorityOverride();
            String other$authorityOverride = other.getAuthorityOverride();
            if (this$authorityOverride == null ? other$authorityOverride != null : !this$authorityOverride.equals(other$authorityOverride)) {
                return false;
            }
            List<String> this$ciphers = this.getCiphers();
            List<String> other$ciphers = other.getCiphers();
            if (this$ciphers == null ? other$ciphers != null : !((Object)this$ciphers).equals(other$ciphers)) {
                return false;
            }
            return Arrays.deepEquals(this.getProtocols(), other.getProtocols());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Security;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $clientAuthEnabled = this.clientAuthEnabled;
            result = result * 59 + ($clientAuthEnabled == null ? 43 : ((Object)$clientAuthEnabled).hashCode());
            Resource $certificateChain = this.getCertificateChain();
            result = result * 59 + ($certificateChain == null ? 43 : $certificateChain.hashCode());
            Resource $privateKey = this.getPrivateKey();
            result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
            String $privateKeyPassword = this.getPrivateKeyPassword();
            result = result * 59 + ($privateKeyPassword == null ? 43 : $privateKeyPassword.hashCode());
            Resource $trustCertCollection = this.getTrustCertCollection();
            result = result * 59 + ($trustCertCollection == null ? 43 : $trustCertCollection.hashCode());
            String $authorityOverride = this.getAuthorityOverride();
            result = result * 59 + ($authorityOverride == null ? 43 : $authorityOverride.hashCode());
            List<String> $ciphers = this.getCiphers();
            result = result * 59 + ($ciphers == null ? 43 : ((Object)$ciphers).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getProtocols());
            return result;
        }
    }
}

