/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.autoconfigure;

import com.google.common.collect.ImmutableMap;
import io.grpc.ConnectivityState;
import java.util.Map;
import net.devh.boot.grpc.client.autoconfigure.GrpcClientAutoConfiguration;
import net.devh.boot.grpc.client.channelfactory.GrpcChannelFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={GrpcClientAutoConfiguration.class})
@ConditionalOnClass(name={"org.springframework.boot.actuate.health.HealthIndicator"})
public class GrpcClientHealthAutoConfiguration {
    @Bean
    @Lazy
    public HealthIndicator grpcChannelHealthIndicator(GrpcChannelFactory factory) {
        return () -> {
            ImmutableMap states = ImmutableMap.copyOf(factory.getConnectivityState());
            Health.Builder health = states.containsValue((Object)ConnectivityState.TRANSIENT_FAILURE) ? Health.down() : Health.up();
            return health.withDetails((Map)states).build();
        };
    }
}

