/*
 * Decompiled with CFR 0.152.
 */
package net.devh.springboot.autoconfigure.grpc.client;

import java.util.ArrayList;
import java.util.List;

public class GrpcChannelProperties {
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final Integer DEFAULT_PORT = 9090;
    public static final GrpcChannelProperties DEFAULT = new GrpcChannelProperties();
    private List<String> host = new ArrayList<String>(){
        private static final long serialVersionUID = -8367871342050560040L;
        {
            this.add(GrpcChannelProperties.DEFAULT_HOST);
        }
    };
    private List<Integer> port = new ArrayList<Integer>(){
        private static final long serialVersionUID = 4705083089654936515L;
        {
            this.add(DEFAULT_PORT);
        }
    };
    private boolean plaintext = true;
    private boolean enableKeepAlive = false;
    private boolean keepAliveWithoutCalls = false;
    private long keepAliveTime = 180L;
    private long keepAliveTimeout = 20L;

    public List<String> getHost() {
        return this.host;
    }

    public List<Integer> getPort() {
        return this.port;
    }

    public boolean isPlaintext() {
        return this.plaintext;
    }

    public boolean isEnableKeepAlive() {
        return this.enableKeepAlive;
    }

    public boolean isKeepAliveWithoutCalls() {
        return this.keepAliveWithoutCalls;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setHost(List<String> host) {
        this.host = host;
    }

    public void setPort(List<Integer> port) {
        this.port = port;
    }

    public void setPlaintext(boolean plaintext) {
        this.plaintext = plaintext;
    }

    public void setEnableKeepAlive(boolean enableKeepAlive) {
        this.enableKeepAlive = enableKeepAlive;
    }

    public void setKeepAliveWithoutCalls(boolean keepAliveWithoutCalls) {
        this.keepAliveWithoutCalls = keepAliveWithoutCalls;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void setKeepAliveTimeout(long keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrpcChannelProperties)) {
            return false;
        }
        GrpcChannelProperties other = (GrpcChannelProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$host = this.getHost();
        List<String> other$host = other.getHost();
        if (this$host == null ? other$host != null : !((Object)this$host).equals(other$host)) {
            return false;
        }
        List<Integer> this$port = this.getPort();
        List<Integer> other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        if (this.isPlaintext() != other.isPlaintext()) {
            return false;
        }
        if (this.isEnableKeepAlive() != other.isEnableKeepAlive()) {
            return false;
        }
        if (this.isKeepAliveWithoutCalls() != other.isKeepAliveWithoutCalls()) {
            return false;
        }
        if (this.getKeepAliveTime() != other.getKeepAliveTime()) {
            return false;
        }
        return this.getKeepAliveTimeout() == other.getKeepAliveTimeout();
    }

    protected boolean canEqual(Object other) {
        return other instanceof GrpcChannelProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : ((Object)$host).hashCode());
        List<Integer> $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        result = result * 59 + (this.isPlaintext() ? 79 : 97);
        result = result * 59 + (this.isEnableKeepAlive() ? 79 : 97);
        result = result * 59 + (this.isKeepAliveWithoutCalls() ? 79 : 97);
        long $keepAliveTime = this.getKeepAliveTime();
        result = result * 59 + (int)($keepAliveTime >>> 32 ^ $keepAliveTime);
        long $keepAliveTimeout = this.getKeepAliveTimeout();
        result = result * 59 + (int)($keepAliveTimeout >>> 32 ^ $keepAliveTimeout);
        return result;
    }

    public String toString() {
        return "GrpcChannelProperties(host=" + this.getHost() + ", port=" + this.getPort() + ", plaintext=" + this.isPlaintext() + ", enableKeepAlive=" + this.isEnableKeepAlive() + ", keepAliveWithoutCalls=" + this.isKeepAliveWithoutCalls() + ", keepAliveTime=" + this.getKeepAliveTime() + ", keepAliveTimeout=" + this.getKeepAliveTimeout() + ")";
    }
}

