/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc.base;

import com.kscs.util.plugins.xjc.base.AbstractPlugin;
import com.kscs.util.plugins.xjc.base.Option;
import java.lang.reflect.Field;

public class BooleanOption
extends Option<Boolean> {
    public BooleanOption(String name, AbstractPlugin plugin, Field field) {
        super(name, plugin, field, "{y|n}");
    }

    @Override
    public void setStringValue(String s) {
        this.set(BooleanOption.parseBoolean(s));
    }

    @Override
    public String getStringValue() {
        return (Boolean)this.get() != false ? "y" : "n";
    }

    private static Boolean parseBoolean(String arg) {
        boolean argTrue = BooleanOption.isTrue(arg);
        boolean argFalse = BooleanOption.isFalse(arg);
        if (!argTrue && !argFalse) {
            return null;
        }
        return argTrue;
    }

    private static boolean isTrue(String arg) {
        return arg.endsWith("y") || arg.endsWith("true") || arg.endsWith("on") || arg.endsWith("yes");
    }

    private static boolean isFalse(String arg) {
        return arg.endsWith("n") || arg.endsWith("false") || arg.endsWith("off") || arg.endsWith("no");
    }
}

