/*
 * Decompiled with CFR 0.152.
 */
package net.codebox.javabeantester;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.junit.Assert;

public class JavaBeanTester {
    public static <T> void test(Class<T> clazz, String ... skipThese) throws IntrospectionException {
        PropertyDescriptor[] props;
        block2: for (PropertyDescriptor prop : props = Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
            for (String skipThis : skipThese) {
                if (skipThis.equals(prop.getName())) continue block2;
            }
            Method getter = prop.getReadMethod();
            Method setter = prop.getWriteMethod();
            if (getter == null || setter == null) continue;
            Class<?> returnType = getter.getReturnType();
            Class<?>[] params = setter.getParameterTypes();
            if (params.length != 1 || params[0] != returnType) continue;
            try {
                Object value = JavaBeanTester.buildValue(returnType);
                T bean = clazz.newInstance();
                setter.invoke(bean, value);
                Object expectedValue = value;
                Object actualValue = getter.invoke(bean, new Object[0]);
                Assert.assertEquals((String)String.format("Failed while testing property %s", prop.getName()), (Object)expectedValue, (Object)actualValue);
            }
            catch (Exception ex) {
                Assert.fail((String)String.format("An exception was thrown while testing the property %s: %s", prop.getName(), ex.toString()));
            }
        }
    }

    private static Object buildMockValue(Class<?> clazz) {
        if (!Modifier.isFinal(clazz.getModifiers())) {
            return null;
        }
        return null;
    }

    private static Object buildValue(Class<?> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, SecurityException, InvocationTargetException {
        Constructor<?>[] ctrs;
        Object mockedObject = JavaBeanTester.buildMockValue(clazz);
        if (mockedObject != null) {
            return mockedObject;
        }
        for (Constructor<?> ctr : ctrs = clazz.getConstructors()) {
            if (ctr.getParameterTypes().length != 0) continue;
            return ctr.newInstance(new Object[0]);
        }
        if (clazz == String.class) {
            return "testvalue";
        }
        if (clazz.isArray()) {
            return Array.newInstance(clazz.getComponentType(), 1);
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return true;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return 1;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return 1L;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return 1.0;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return Float.valueOf(1.0f);
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return Character.valueOf('Y');
        }
        if (clazz.isEnum()) {
            return clazz.getEnumConstants()[0];
        }
        Assert.fail((String)("Unable to build an instance of class " + clazz.getName() + ", please add some code to the " + JavaBeanTester.class.getName() + " class to do this."));
        return null;
    }
}

