/*
 * Decompiled with CFR 0.152.
 */
package net.cloudopt.logger.provider;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import net.cloudopt.logger.Colorer;
import net.cloudopt.logger.Logger;
import net.cloudopt.logger.provider.LoggerProvider;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lnet/cloudopt/logger/provider/Slf4jLoggerProvider;", "Lnet/cloudopt/logger/provider/LoggerProvider;", "()V", "getLogger", "Lnet/cloudopt/logger/Logger;", "clazz", "Ljava/lang/Class;", "clazzName", "", "Slf4JLogger", "cloudopt-logger"})
public final class Slf4jLoggerProvider
implements LoggerProvider {
    @Override
    @NotNull
    public Logger getLogger(@NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        org.slf4j.Logger logger = LoggerFactory.getLogger(clazz);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"org.slf4j.LoggerFactory.getLogger(clazz)");
        return new Slf4JLogger(logger);
    }

    @Override
    @NotNull
    public Logger getLogger(@NotNull String clazzName) {
        Intrinsics.checkParameterIsNotNull((Object)clazzName, (String)"clazzName");
        org.slf4j.Logger logger = LoggerFactory.getLogger((String)clazzName);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"org.slf4j.LoggerFactory.getLogger(clazzName)");
        return new Slf4JLogger(logger);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000bH\u0017\u00a2\u0006\u0002\u0010\fJ1\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000bH\u0017\u00a2\u0006\u0002\u0010\u000fJ)\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000bH\u0017\u00a2\u0006\u0002\u0010\fJ1\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000bH\u0017\u00a2\u0006\u0002\u0010\u000fJ)\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000bH\u0017\u00a2\u0006\u0002\u0010\fJ1\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000bH\u0017\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J)\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000bH\u0017\u00a2\u0006\u0002\u0010\fJ1\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000bH\u0017\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/cloudopt/logger/provider/Slf4jLoggerProvider$Slf4JLogger;", "Lnet/cloudopt/logger/Logger;", "logger", "Lorg/slf4j/Logger;", "(Lnet/cloudopt/logger/provider/Slf4jLoggerProvider;Lorg/slf4j/Logger;)V", "debug", "", "message", "", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "t", "", "(Ljava/lang/String;Ljava/lang/Throwable;[Ljava/lang/Object;)V", "error", "info", "isDebugEnabled", "", "isErrorEnabled", "isInfoEnabled", "isWarnEnabled", "warn", "cloudopt-logger"})
    public final class Slf4JLogger
    extends Logger {
        private final org.slf4j.Logger logger;

        @Override
        @JvmOverloads
        public void debug(@NotNull String message, Object ... args) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Object[] objectArray = Arrays.copyOf(args, args.length);
            StringBuilder stringBuilder = new StringBuilder().append(Colorer.INSTANCE.magenta(Logger.Companion.getConfiguration().getDebugPrefix())).append(' ');
            org.slf4j.Logger logger = this.logger;
            String string = String.format(message, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
            String string2 = string;
            logger.debug(stringBuilder.append(string2).toString(), Arrays.copyOf(args, args.length));
        }

        @Override
        @JvmOverloads
        public void debug(@NotNull String message, @NotNull Throwable t, Object ... args) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Object[] objectArray = Arrays.copyOf(args, args.length);
            StringBuilder stringBuilder = new StringBuilder().append(Colorer.INSTANCE.green(Logger.Companion.getConfiguration().getDebugPrefix())).append(' ');
            org.slf4j.Logger logger = this.logger;
            String string = String.format(message, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
            String string2 = string;
            logger.debug(stringBuilder.append(string2).toString(), t);
        }

        @Override
        @JvmOverloads
        public void info(@NotNull String message, Object ... args) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Object[] objectArray = Arrays.copyOf(args, args.length);
            StringBuilder stringBuilder = new StringBuilder().append(Colorer.INSTANCE.blue(Logger.Companion.getConfiguration().getInfoPrefix())).append(' ');
            org.slf4j.Logger logger = this.logger;
            String string = String.format(message, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
            String string2 = string;
            logger.info(stringBuilder.append(string2).toString(), Arrays.copyOf(args, args.length));
        }

        @Override
        @JvmOverloads
        public void info(@NotNull String message, @NotNull Throwable t, Object ... args) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Object[] objectArray = Arrays.copyOf(args, args.length);
            StringBuilder stringBuilder = new StringBuilder().append(Colorer.INSTANCE.blue(Logger.Companion.getConfiguration().getInfoPrefix())).append(' ');
            org.slf4j.Logger logger = this.logger;
            String string = String.format(message, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
            String string2 = string;
            logger.info(stringBuilder.append(string2).toString(), t);
        }

        @Override
        @JvmOverloads
        public void warn(@NotNull String message, Object ... args) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Object[] objectArray = Arrays.copyOf(args, args.length);
            StringBuilder stringBuilder = new StringBuilder().append(Colorer.INSTANCE.yellow(Logger.Companion.getConfiguration().getWarnPrefix())).append(' ');
            org.slf4j.Logger logger = this.logger;
            String string = String.format(message, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
            String string2 = string;
            logger.warn(stringBuilder.append(string2).toString(), Arrays.copyOf(args, args.length));
        }

        @Override
        @JvmOverloads
        public void warn(@NotNull String message, @NotNull Throwable t, Object ... args) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Object[] objectArray = Arrays.copyOf(args, args.length);
            StringBuilder stringBuilder = new StringBuilder().append(Colorer.INSTANCE.yellow(Logger.Companion.getConfiguration().getWarnPrefix())).append(' ');
            org.slf4j.Logger logger = this.logger;
            String string = String.format(message, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
            String string2 = string;
            logger.warn(stringBuilder.append(string2).toString(), t);
        }

        @Override
        @JvmOverloads
        public void error(@NotNull String message, Object ... args) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Object[] objectArray = Arrays.copyOf(args, args.length);
            StringBuilder stringBuilder = new StringBuilder().append(Colorer.INSTANCE.red(Logger.Companion.getConfiguration().getErrorPrefix())).append(' ');
            org.slf4j.Logger logger = this.logger;
            String string = String.format(message, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
            String string2 = string;
            logger.error(stringBuilder.append(string2).toString(), Arrays.copyOf(args, args.length));
        }

        @Override
        @JvmOverloads
        public void error(@NotNull String message, @NotNull Throwable t, Object ... args) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Object[] objectArray = Arrays.copyOf(args, args.length);
            StringBuilder stringBuilder = new StringBuilder().append(Colorer.INSTANCE.red(Logger.Companion.getConfiguration().getErrorPrefix())).append(' ');
            org.slf4j.Logger logger = this.logger;
            String string = String.format(message, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(format, *args)");
            String string2 = string;
            logger.error(stringBuilder.append(string2).toString(), t);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        public Slf4JLogger(org.slf4j.Logger logger) {
            Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
            this.logger = logger;
        }
    }
}

