/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.PackageDefinitionStrategy;

public class ByteArrayClassLoader
extends ClassLoader {
    public static final String URL_SCHEMA = "bytebuddy";
    private static final int FROM_BEGINNING = 0;
    private static final URL NO_URL = null;
    private static final PackageLookupStrategy PACKAGE_LOOKUP_STRATEGY = ByteArrayClassLoader.packageLookupStrategy();
    protected final Map<String, byte[]> typeDefinitions;
    protected final PersistenceHandler persistenceHandler;
    protected final ProtectionDomain protectionDomain;
    protected final PackageDefinitionStrategy packageDefinitionStrategy;
    protected final AccessControlContext accessControlContext;

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
    private static PackageLookupStrategy packageLookupStrategy() {
        try {
            return new PackageLookupStrategy.ForJava9CapableVm(ClassLoader.class.getDeclaredMethod("getDefinedPackage", String.class));
        }
        catch (Exception ignored) {
            return PackageLookupStrategy.ForLegacyVm.INSTANCE;
        }
    }

    public ByteArrayClassLoader(ClassLoader parent, Map<String, byte[]> typeDefinitions, ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, PackageDefinitionStrategy packageDefinitionStrategy) {
        super(parent);
        this.typeDefinitions = new HashMap<String, byte[]>(typeDefinitions);
        this.protectionDomain = protectionDomain;
        this.persistenceHandler = persistenceHandler;
        this.packageDefinitionStrategy = packageDefinitionStrategy;
        this.accessControlContext = AccessController.getContext();
    }

    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="Privilege is explicit user responsibility")
    public static ClassLoader of(ClassLoader parent, Map<TypeDescription, byte[]> typeDefinitions, ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, PackageDefinitionStrategy packageDefinitionStrategy, boolean childFirst) {
        HashMap<String, byte[]> namedTypeDefinitions = new HashMap<String, byte[]>();
        for (Map.Entry<TypeDescription, byte[]> entry : typeDefinitions.entrySet()) {
            namedTypeDefinitions.put(entry.getKey().getName(), entry.getValue());
        }
        return childFirst ? new ChildFirst(parent, namedTypeDefinitions, protectionDomain, persistenceHandler, packageDefinitionStrategy) : new ByteArrayClassLoader(parent, namedTypeDefinitions, protectionDomain, persistenceHandler, packageDefinitionStrategy);
    }

    public static Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types, ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, PackageDefinitionStrategy packageDefinitionStrategy, boolean childFirst, boolean forbidExisting) {
        LinkedHashMap loadedTypes = new LinkedHashMap();
        classLoader = ByteArrayClassLoader.of(classLoader, types, protectionDomain, persistenceHandler, packageDefinitionStrategy, childFirst);
        for (TypeDescription typeDescription : types.keySet()) {
            try {
                Class<?> type = Class.forName(typeDescription.getName(), false, classLoader);
                if (forbidExisting && type.getClassLoader() != classLoader) {
                    throw new IllegalStateException("Class already loaded: " + type);
                }
                loadedTypes.put(typeDescription, type);
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalStateException("Cannot load class " + typeDescription, exception);
            }
        }
        return loadedTypes;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] binaryRepresentation = this.persistenceHandler.lookup(name, this.typeDefinitions);
        if (binaryRepresentation == null) {
            throw new ClassNotFoundException(name);
        }
        return (Class)AccessController.doPrivileged(new ClassDefinitionAction(name, binaryRepresentation), this.accessControlContext);
    }

    @Override
    protected URL findResource(String name) {
        return this.persistenceHandler.url(name, this.typeDefinitions);
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        URL url = this.persistenceHandler.url(name, this.typeDefinitions);
        return url == null ? EmptyEnumeration.INSTANCE : new SingletonEnumeration(url);
    }

    private Package doGetPackage(String name) {
        return this.getPackage(name);
    }

    public String toString() {
        return "ByteArrayClassLoader{typeDefinitions=" + this.typeDefinitions + ", persistenceHandler=" + (Object)((Object)this.persistenceHandler) + ", protectionDomain=" + this.protectionDomain + ", packageDefinitionStrategy=" + this.packageDefinitionStrategy + ", accessControlContext=" + this.accessControlContext + '}';
    }

    protected static class SingletonEnumeration
    implements Enumeration<URL> {
        private URL element;

        protected SingletonEnumeration(URL element) {
            this.element = element;
        }

        @Override
        public boolean hasMoreElements() {
            return this.element != null;
        }

        @Override
        public URL nextElement() {
            if (this.element == null) {
                throw new NoSuchElementException();
            }
            try {
                URL uRL = this.element;
                return uRL;
            }
            finally {
                this.element = null;
            }
        }

        public String toString() {
            return "ByteArrayClassLoader.SingletonEnumeration{element=" + this.element + '}';
        }
    }

    protected static enum EmptyEnumeration implements Enumeration<URL>
    {
        INSTANCE;


        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public URL nextElement() {
            throw new NoSuchElementException();
        }

        public String toString() {
            return "ByteArrayClassLoader.EmptyEnumeration." + this.name();
        }
    }

    public static class ChildFirst
    extends ByteArrayClassLoader {
        private static final String CLASS_FILE_SUFFIX = ".class";
        private static final SynchronizationStrategy SYNCHRONIZATION_STRATEGY;

        public ChildFirst(ClassLoader parent, Map<String, byte[]> typeDefinitions, ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, PackageDefinitionStrategy packageDefinitionStrategy) {
            super(parent, typeDefinitions, protectionDomain, persistenceHandler, packageDefinitionStrategy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Object object = SYNCHRONIZATION_STRATEGY.classLoadingLock(name, this);
            synchronized (object) {
                Class<?> type = this.findLoadedClass(name);
                if (type != null) {
                    return type;
                }
                try {
                    type = this.findClass(name);
                    if (resolve) {
                        this.resolveClass(type);
                    }
                    return type;
                }
                catch (ClassNotFoundException exception) {
                    return super.loadClass(name, resolve);
                }
            }
        }

        @Override
        public URL getResource(String name) {
            URL url = this.persistenceHandler.url(name, this.typeDefinitions);
            return url != null || this.isShadowed(name) ? url : super.getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            URL url = this.persistenceHandler.url(name, this.typeDefinitions);
            return url == null ? super.getResources(name) : new PrependingEnumeration(url, super.getResources(name));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isShadowed(String resourceName) {
            if (this.persistenceHandler.isManifest() || !resourceName.endsWith(CLASS_FILE_SUFFIX)) {
                return false;
            }
            ChildFirst childFirst = this;
            synchronized (childFirst) {
                String typeName = resourceName.replace('/', '.').substring(0, resourceName.length() - CLASS_FILE_SUFFIX.length());
                if (this.typeDefinitions.containsKey(typeName)) {
                    return true;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                Class<?> loadedClass = this.findLoadedClass(typeName);
                return loadedClass != null && loadedClass.getClassLoader() == this;
            }
        }

        @Override
        public String toString() {
            return "ByteArrayClassLoader.ChildFirst{typeDefinitions=" + this.typeDefinitions + ", protectionDomain=" + this.protectionDomain + ", persistenceHandler=" + (Object)((Object)this.persistenceHandler) + ", packageDefinitionStrategy=" + this.packageDefinitionStrategy + ", accessControlContext=" + this.accessControlContext + '}';
        }

        static {
            SynchronizationStrategy synchronizationStrategy;
            try {
                synchronizationStrategy = SynchronizationStrategy.ForJava7CapableVm.resolve();
            }
            catch (Exception ignored) {
                synchronizationStrategy = SynchronizationStrategy.ForLegacyVm.INSTANCE;
            }
            SYNCHRONIZATION_STRATEGY = synchronizationStrategy;
        }

        protected static class PrependingEnumeration
        implements Enumeration<URL> {
            private URL nextElement;
            private final Enumeration<URL> enumeration;

            protected PrependingEnumeration(URL url, Enumeration<URL> enumeration) {
                this.nextElement = url;
                this.enumeration = enumeration;
            }

            @Override
            public boolean hasMoreElements() {
                return this.nextElement != null && this.enumeration.hasMoreElements();
            }

            @Override
            public URL nextElement() {
                if (this.nextElement != null && this.enumeration.hasMoreElements()) {
                    try {
                        URL uRL = this.nextElement;
                        return uRL;
                    }
                    finally {
                        this.nextElement = this.enumeration.nextElement();
                    }
                }
                throw new NoSuchElementException();
            }

            public String toString() {
                return "ByteArrayClassLoader.ChildFirst.PrependingEnumeration{nextElement=" + this.nextElement + ", enumeration=" + this.enumeration + '}';
            }
        }

        protected static interface SynchronizationStrategy {
            public Object classLoadingLock(String var1, ClassLoader var2);

            public static class ForJava7CapableVm
            implements SynchronizationStrategy,
            PrivilegedAction<SynchronizationStrategy> {
                private final Method method;

                protected ForJava7CapableVm(Method method) {
                    this.method = method;
                }

                protected static SynchronizationStrategy resolve() throws NoSuchMethodException {
                    return AccessController.doPrivileged(new ForJava7CapableVm(ClassLoader.class.getDeclaredMethod("getClassLoadingLock", String.class)));
                }

                @Override
                public Object classLoadingLock(String name, ClassLoader classLoader) {
                    try {
                        return this.method.invoke((Object)classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access class loading lock for " + name + " on " + classLoader, exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error when getting " + name + " on " + classLoader, exception);
                    }
                }

                @Override
                public SynchronizationStrategy run() {
                    this.method.setAccessible(true);
                    return this;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.method.equals(((ForJava7CapableVm)other).method);
                }

                public int hashCode() {
                    return this.method.hashCode();
                }

                public String toString() {
                    return "ByteArrayClassLoader.ChildFirst.SynchronizationStrategy.ForJava7CapableVm{method=" + this.method + '}';
                }
            }

            public static enum ForLegacyVm implements SynchronizationStrategy
            {
                INSTANCE;


                @Override
                public Object classLoadingLock(String name, ClassLoader classLoader) {
                    return classLoader;
                }

                public String toString() {
                    return "ByteArrayClassLoader.ChildFirst.SynchronizationStrategy.ForLegacyVm." + this.name();
                }
            }
        }
    }

    public static enum PersistenceHandler {
        MANIFEST(true){

            @Override
            protected byte[] lookup(String name, Map<String, byte[]> typeDefinitions) {
                return typeDefinitions.get(name);
            }

            @Override
            protected URL url(String resourceName, Map<String, byte[]> typeDefinitions) {
                String typeName;
                byte[] binaryRepresentation;
                if (!resourceName.endsWith(PersistenceHandler.CLASS_FILE_SUFFIX)) {
                    return NO_URL;
                }
                if (resourceName.startsWith("/")) {
                    resourceName = resourceName.substring(1);
                }
                return (binaryRepresentation = typeDefinitions.get(typeName = resourceName.replace('/', '.').substring(0, resourceName.length() - PersistenceHandler.CLASS_FILE_SUFFIX.length()))) == null ? NO_URL : AccessController.doPrivileged(new UrlDefinitionAction(resourceName, binaryRepresentation));
            }
        }
        ,
        LATENT(false){

            @Override
            protected byte[] lookup(String name, Map<String, byte[]> typeDefinitions) {
                return typeDefinitions.remove(name);
            }

            @Override
            protected URL url(String resourceName, Map<String, byte[]> typeDefinitions) {
                return NO_URL;
            }
        };

        private static final String CLASS_FILE_SUFFIX = ".class";
        private final boolean manifest;

        private PersistenceHandler(boolean manifest) {
            this.manifest = manifest;
        }

        public boolean isManifest() {
            return this.manifest;
        }

        protected abstract byte[] lookup(String var1, Map<String, byte[]> var2);

        protected abstract URL url(String var1, Map<String, byte[]> var2);

        public String toString() {
            return "ByteArrayClassLoader.PersistenceHandler." + this.name();
        }

        protected static class UrlDefinitionAction
        implements PrivilegedAction<URL> {
            private static final String ENCODING = "UTF-8";
            private static final int NO_PORT = -1;
            private static final String NO_FILE = "";
            private final String typeName;
            private final byte[] binaryRepresentation;

            protected UrlDefinitionAction(String typeName, byte[] binaryRepresentation) {
                this.typeName = typeName;
                this.binaryRepresentation = binaryRepresentation;
            }

            @Override
            public URL run() {
                try {
                    return new URL(ByteArrayClassLoader.URL_SCHEMA, URLEncoder.encode(this.typeName.replace('.', '/'), ENCODING), -1, NO_FILE, new ByteArrayUrlStreamHandler(this.binaryRepresentation));
                }
                catch (MalformedURLException exception) {
                    throw new IllegalStateException("Cannot create URL for " + this.typeName, exception);
                }
                catch (UnsupportedEncodingException exception) {
                    throw new IllegalStateException("Could not find encoding: UTF-8", exception);
                }
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                UrlDefinitionAction that = (UrlDefinitionAction)other;
                return this.typeName.equals(that.typeName) && Arrays.equals(this.binaryRepresentation, that.binaryRepresentation);
            }

            public int hashCode() {
                int result = this.typeName.hashCode();
                result = 31 * result + Arrays.hashCode(this.binaryRepresentation);
                return result;
            }

            public String toString() {
                return "ByteArrayClassLoader.PersistenceHandler.UrlDefinitionAction{typeName='" + this.typeName + '\'' + "binaryRepresentation=<" + this.binaryRepresentation.length + " bytes>" + '}';
            }

            protected static class ByteArrayUrlStreamHandler
            extends URLStreamHandler {
                private final byte[] binaryRepresentation;

                protected ByteArrayUrlStreamHandler(byte[] binaryRepresentation) {
                    this.binaryRepresentation = binaryRepresentation;
                }

                @Override
                protected URLConnection openConnection(URL url) throws IOException {
                    return new ByteArrayUrlConnection(url, new ByteArrayInputStream(this.binaryRepresentation));
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ByteArrayUrlStreamHandler that = (ByteArrayUrlStreamHandler)other;
                    return Arrays.equals(this.binaryRepresentation, that.binaryRepresentation);
                }

                public int hashCode() {
                    return Arrays.hashCode(this.binaryRepresentation);
                }

                public String toString() {
                    return "ByteArrayClassLoader.PersistenceHandler.UrlDefinitionAction.ByteArrayUrlStreamHandler{binaryRepresentation=<" + this.binaryRepresentation.length + " bytes>" + '}';
                }

                protected static class ByteArrayUrlConnection
                extends URLConnection {
                    private final InputStream inputStream;

                    protected ByteArrayUrlConnection(URL url, InputStream inputStream) {
                        super(url);
                        this.inputStream = inputStream;
                    }

                    @Override
                    public void connect() {
                        this.connected = true;
                    }

                    @Override
                    public InputStream getInputStream() {
                        this.connect();
                        return this.inputStream;
                    }

                    @Override
                    public String toString() {
                        return "ByteArrayClassLoader.PersistenceHandler.UrlDefinitionAction.ByteArrayUrlStreamHandler.ByteArrayUrlConnection{inputStream=" + this.inputStream + '}';
                    }
                }
            }
        }
    }

    protected static interface PackageLookupStrategy {
        public Package apply(ByteArrayClassLoader var1, String var2);

        public static class ForJava9CapableVm
        implements PackageLookupStrategy {
            private final Method getDefinedPackage;

            protected ForJava9CapableVm(Method getDefinedPackage) {
                this.getDefinedPackage = getDefinedPackage;
            }

            @Override
            public Package apply(ByteArrayClassLoader classLoader, String name) {
                try {
                    return (Package)this.getDefinedPackage.invoke((Object)classLoader, name);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access " + this.getDefinedPackage, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke " + this.getDefinedPackage, exception.getCause());
                }
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForJava9CapableVm that = (ForJava9CapableVm)object;
                return this.getDefinedPackage.equals(that.getDefinedPackage);
            }

            public int hashCode() {
                return this.getDefinedPackage.hashCode();
            }

            public String toString() {
                return "ByteArrayClassLoader.PackageLookupStrategy.ForJava9CapableVm{getDefinedPackage=" + this.getDefinedPackage + '}';
            }
        }

        public static enum ForLegacyVm implements PackageLookupStrategy
        {
            INSTANCE;


            @Override
            public Package apply(ByteArrayClassLoader classLoader, String name) {
                return classLoader.doGetPackage(name);
            }

            public String toString() {
                return "ByteArrayClassLoader.PackageLookupStrategy.ForLegacyVm." + this.name();
            }
        }
    }

    protected class ClassDefinitionAction
    implements PrivilegedAction<Class<?>> {
        private final String name;
        private final byte[] binaryRepresentation;

        protected ClassDefinitionAction(String name, byte[] binaryRepresentation) {
            this.name = name;
            this.binaryRepresentation = binaryRepresentation;
        }

        @Override
        public Class<?> run() {
            String packageName;
            PackageDefinitionStrategy.Definition definition;
            int packageIndex = this.name.lastIndexOf(46);
            if (packageIndex != -1 && (definition = ByteArrayClassLoader.this.packageDefinitionStrategy.define(ByteArrayClassLoader.this, packageName = this.name.substring(0, packageIndex), this.name)).isDefined()) {
                Package definedPackage = PACKAGE_LOOKUP_STRATEGY.apply(ByteArrayClassLoader.this, packageName);
                if (definedPackage == null) {
                    ByteArrayClassLoader.this.definePackage(packageName, definition.getSpecificationTitle(), definition.getSpecificationVersion(), definition.getSpecificationVendor(), definition.getImplementationTitle(), definition.getImplementationVersion(), definition.getImplementationVendor(), definition.getSealBase());
                } else if (!definition.isCompatibleTo(definedPackage)) {
                    throw new SecurityException("Sealing violation for package " + packageName);
                }
            }
            return ByteArrayClassLoader.this.defineClass(this.name, this.binaryRepresentation, 0, this.binaryRepresentation.length, ByteArrayClassLoader.this.protectionDomain);
        }

        private ByteArrayClassLoader getOuter() {
            return ByteArrayClassLoader.this;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ClassDefinitionAction that = (ClassDefinitionAction)object;
            return this.name.equals(that.name) && ByteArrayClassLoader.this.equals(that.getOuter()) && Arrays.equals(this.binaryRepresentation, that.binaryRepresentation);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + ByteArrayClassLoader.this.hashCode();
            result = 31 * result + Arrays.hashCode(this.binaryRepresentation);
            return result;
        }

        public String toString() {
            return "ByteArrayClassLoader.ClassDefinitionAction{outer=" + ByteArrayClassLoader.this + ", name='" + this.name + '\'' + ", binaryRepresentation=<" + this.binaryRepresentation.length + " bytes>" + '}';
        }
    }
}

