/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.DoubleConstant;
import net.bytebuddy.implementation.bytecode.constant.FloatConstant;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.constant.LongConstant;
import net.bytebuddy.implementation.bytecode.constant.MethodHandleConstant;
import net.bytebuddy.implementation.bytecode.constant.MethodTypeConstant;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaInstance;
import net.bytebuddy.utility.JavaType;

public abstract class FixedValue
implements Implementation {
    protected final Assigner assigner;
    protected final Assigner.Typing typing;

    protected FixedValue(Assigner assigner, Assigner.Typing typing) {
        this.assigner = assigner;
        this.typing = typing;
    }

    public static AssignerConfigurable value(Object fixedValue) {
        Class<?> type = fixedValue.getClass();
        if (type == String.class) {
            return new ForPoolValue(new TextConstant((String)fixedValue), TypeDescription.STRING, Assigner.DEFAULT, Assigner.Typing.STATIC);
        }
        if (type == Class.class) {
            return new ForPoolValue(ClassConstant.of(new TypeDescription.ForLoadedType((Class)fixedValue)), TypeDescription.CLASS, Assigner.DEFAULT, Assigner.Typing.STATIC);
        }
        if (type == Boolean.class) {
            return new ForPoolValue(IntegerConstant.forValue((Boolean)fixedValue), new TypeDescription.ForLoadedType(Boolean.TYPE), Assigner.DEFAULT, Assigner.Typing.STATIC);
        }
        if (type == Byte.class) {
            return new ForPoolValue(IntegerConstant.forValue(((Byte)fixedValue).byteValue()), new TypeDescription.ForLoadedType(Byte.TYPE), Assigner.DEFAULT, Assigner.Typing.STATIC);
        }
        if (type == Short.class) {
            return new ForPoolValue(IntegerConstant.forValue(((Short)fixedValue).shortValue()), new TypeDescription.ForLoadedType(Short.TYPE), Assigner.DEFAULT, Assigner.Typing.STATIC);
        }
        if (type == Character.class) {
            return new ForPoolValue(IntegerConstant.forValue(((Character)fixedValue).charValue()), new TypeDescription.ForLoadedType(Character.TYPE), Assigner.DEFAULT, Assigner.Typing.STATIC);
        }
        if (type == Integer.class) {
            return new ForPoolValue(IntegerConstant.forValue((Integer)fixedValue), new TypeDescription.ForLoadedType(Integer.TYPE), Assigner.DEFAULT, Assigner.Typing.STATIC);
        }
        if (type == Long.class) {
            return new ForPoolValue(LongConstant.forValue((Long)fixedValue), new TypeDescription.ForLoadedType(Long.TYPE), Assigner.DEFAULT, Assigner.Typing.STATIC);
        }
        if (type == Float.class) {
            return new ForPoolValue(FloatConstant.forValue(((Float)fixedValue).floatValue()), new TypeDescription.ForLoadedType(Float.TYPE), Assigner.DEFAULT, Assigner.Typing.STATIC);
        }
        if (type == Double.class) {
            return new ForPoolValue(DoubleConstant.forValue((Double)fixedValue), new TypeDescription.ForLoadedType(Double.TYPE), Assigner.DEFAULT, Assigner.Typing.STATIC);
        }
        if (JavaType.METHOD_HANDLE.getTypeStub().isAssignableFrom(type)) {
            return new ForPoolValue(MethodHandleConstant.of(JavaInstance.MethodHandle.ofLoaded(fixedValue)), new TypeDescription.ForLoadedType(type), Assigner.DEFAULT, Assigner.Typing.STATIC);
        }
        if (JavaType.METHOD_TYPE.getTypeStub().represents(type)) {
            return new ForPoolValue(MethodTypeConstant.of(JavaInstance.MethodType.ofLoaded(fixedValue)), new TypeDescription.ForLoadedType(type), Assigner.DEFAULT, Assigner.Typing.STATIC);
        }
        return FixedValue.reference(fixedValue);
    }

    public static AssignerConfigurable reference(Object fixedValue) {
        return new ForStaticField(fixedValue, Assigner.DEFAULT, Assigner.Typing.STATIC);
    }

    public static AssignerConfigurable reference(Object fixedValue, String fieldName) {
        return new ForStaticField(fieldName, fixedValue, Assigner.DEFAULT, Assigner.Typing.STATIC);
    }

    public static AssignerConfigurable value(TypeDescription fixedValue) {
        return new ForPoolValue(ClassConstant.of(fixedValue), TypeDescription.CLASS, Assigner.DEFAULT, Assigner.Typing.STATIC);
    }

    public static AssignerConfigurable value(JavaInstance fixedValue) {
        return new ForPoolValue(fixedValue.asStackManipulation(), fixedValue.getInstanceType(), Assigner.DEFAULT, Assigner.Typing.STATIC);
    }

    public static Implementation nullValue() {
        return ForNullValue.INSTANCE;
    }

    public static AssignerConfigurable originType() {
        return new ForOriginType(Assigner.DEFAULT, Assigner.Typing.STATIC);
    }

    protected ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod, TypeDescription.Generic fixedValueType, StackManipulation valueLoadingInstruction) {
        StackManipulation assignment = this.assigner.assign(fixedValueType, instrumentedMethod.getReturnType(), this.typing);
        if (!assignment.isValid()) {
            throw new IllegalArgumentException("Cannot return value of type " + fixedValueType + " for " + instrumentedMethod);
        }
        StackManipulation.Size stackSize = new StackManipulation.Compound(valueLoadingInstruction, assignment, MethodReturn.returning(instrumentedMethod.getReturnType().asErasure())).apply(methodVisitor, implementationContext);
        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.typing == ((FixedValue)other).typing && this.assigner.equals(((FixedValue)other).assigner);
    }

    public int hashCode() {
        return 31 * this.assigner.hashCode() + this.typing.hashCode();
    }

    protected static class ForStaticField
    extends FixedValue
    implements AssignerConfigurable {
        private static final String PREFIX = "fixedValue";
        private final String fieldName;
        private final Object fixedValue;
        private final TypeDescription.Generic fieldType;

        protected ForStaticField(Object fixedValue, Assigner assigner, Assigner.Typing typing) {
            this(String.format("%s$%d", PREFIX, Math.abs(fixedValue.hashCode() % Integer.MAX_VALUE)), fixedValue, assigner, typing);
        }

        protected ForStaticField(String fieldName, Object fixedValue, Assigner assigner, Assigner.Typing typing) {
            super(assigner, typing);
            this.fieldName = fieldName;
            this.fixedValue = fixedValue;
            this.fieldType = new TypeDescription.Generic.OfNonGenericType.ForLoadedType(fixedValue.getClass());
        }

        @Override
        public Implementation withAssigner(Assigner assigner, Assigner.Typing typing) {
            return new ForStaticField(this.fieldName, this.fixedValue, assigner, typing);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withField(new FieldDescription.Token(this.fieldName, 4105, this.fieldType)).withInitializer(new LoadedTypeInitializer.ForStaticField(this.fieldName, this.fixedValue));
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new StaticFieldByteCodeAppender(implementationTarget.getInstrumentedType());
        }

        @Override
        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.fieldName.equals(((ForStaticField)other).fieldName) && this.fixedValue.equals(((ForStaticField)other).fixedValue) && super.equals(other);
        }

        @Override
        public int hashCode() {
            return 961 * super.hashCode() + 31 * this.fieldName.hashCode() + this.fixedValue.hashCode();
        }

        public String toString() {
            return "FixedValue.ForStaticField{fieldName='" + this.fieldName + '\'' + ", fieldType=" + this.fieldType + ", fixedValue=" + this.fixedValue + ", assigner=" + this.assigner + ", typing=" + (Object)((Object)this.typing) + '}';
        }

        private class StaticFieldByteCodeAppender
        implements ByteCodeAppender {
            private final StackManipulation fieldGetAccess;

            private StaticFieldByteCodeAppender(TypeDescription instrumentedType) {
                this.fieldGetAccess = FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(ForStaticField.this.fieldName))).getOnly()).getter();
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                return ForStaticField.this.apply(methodVisitor, implementationContext, instrumentedMethod, ForStaticField.this.fieldType, this.fieldGetAccess);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.fieldGetAccess.equals(((StaticFieldByteCodeAppender)other).fieldGetAccess);
            }

            public int hashCode() {
                return this.fieldGetAccess.hashCode();
            }

            public String toString() {
                return "StaticFieldByteCodeAppender{fieldGetAccess=" + this.fieldGetAccess + '}';
            }
        }
    }

    protected static class ForPoolValue
    extends FixedValue
    implements AssignerConfigurable,
    ByteCodeAppender {
        private final StackManipulation valueLoadInstruction;
        private final TypeDescription loadedType;

        private ForPoolValue(StackManipulation valueLoadInstruction, TypeDescription loadedType, Assigner assigner, Assigner.Typing typing) {
            super(assigner, typing);
            this.valueLoadInstruction = valueLoadInstruction;
            this.loadedType = loadedType;
        }

        @Override
        public Implementation withAssigner(Assigner assigner, Assigner.Typing typing) {
            return new ForPoolValue(this.valueLoadInstruction, this.loadedType, assigner, typing);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return this;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            return this.apply(methodVisitor, implementationContext, instrumentedMethod, this.loadedType.asGenericType(), this.valueLoadInstruction);
        }

        @Override
        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.loadedType.equals(((ForPoolValue)other).loadedType) && this.valueLoadInstruction.equals(((ForPoolValue)other).valueLoadInstruction);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.valueLoadInstruction.hashCode();
            result = 31 * result + this.loadedType.hashCode();
            return result;
        }

        public String toString() {
            return "FixedValue.ForPoolValue{valueLoadInstruction=" + this.valueLoadInstruction + ", loadedType=" + this.loadedType + ", assigner=" + this.assigner + ", typing=" + (Object)((Object)this.typing) + '}';
        }
    }

    protected static enum ForNullValue implements Implementation,
    ByteCodeAppender
    {
        INSTANCE;


        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return this;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            if (instrumentedMethod.getReturnType().isPrimitive()) {
                throw new IllegalStateException("Cannot return null from " + instrumentedMethod);
            }
            return new ByteCodeAppender.Simple(NullConstant.INSTANCE, MethodReturn.REFERENCE).apply(methodVisitor, implementationContext, instrumentedMethod);
        }

        public String toString() {
            return "FixedValue.ForNullValue." + this.name();
        }
    }

    protected static class ForOriginType
    extends FixedValue
    implements AssignerConfigurable {
        protected ForOriginType(Assigner assigner, Assigner.Typing typing) {
            super(assigner, typing);
        }

        @Override
        public Implementation withAssigner(Assigner assigner, Assigner.Typing typing) {
            return new ForOriginType(assigner, typing);
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(implementationTarget.getOriginType().asErasure());
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        public String toString() {
            return "FixedValue.ForOriginType{assigner=" + this.assigner + ", typing=" + (Object)((Object)this.typing) + '}';
        }

        protected class Appender
        implements ByteCodeAppender {
            private final TypeDescription originType;

            protected Appender(TypeDescription originType) {
                this.originType = originType;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                return ForOriginType.this.apply(methodVisitor, implementationContext, instrumentedMethod, TypeDescription.CLASS.asGenericType(), ClassConstant.of(this.originType));
            }

            private ForOriginType getOuter() {
                return ForOriginType.this;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Appender appender = (Appender)o;
                return this.originType.equals(appender.originType) && this.getOuter().equals(appender.getOuter());
            }

            public int hashCode() {
                return 31 * this.getOuter().hashCode() + this.originType.hashCode();
            }

            public String toString() {
                return "FixedValue.ForOriginType.Appender{outer=" + this.getOuter() + ", originType=" + this.originType + '}';
            }
        }
    }

    public static interface AssignerConfigurable
    extends Implementation {
        public Implementation withAssigner(Assigner var1, Assigner.Typing var2);
    }
}

