/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.utility.CompoundList;

public interface AsmVisitorWrapper {
    public int mergeWriter(int var1);

    public int mergeReader(int var1);

    public ClassVisitor wrap(TypeDescription var1, ClassVisitor var2);

    public static class Compound
    implements AsmVisitorWrapper {
        private final List<? extends AsmVisitorWrapper> asmVisitorWrappers;

        public Compound(AsmVisitorWrapper ... asmVisitorWrapper) {
            this(Arrays.asList(asmVisitorWrapper));
        }

        public Compound(List<? extends AsmVisitorWrapper> asmVisitorWrappers) {
            this.asmVisitorWrappers = asmVisitorWrappers;
        }

        @Override
        public int mergeWriter(int flags) {
            for (AsmVisitorWrapper asmVisitorWrapper : this.asmVisitorWrappers) {
                flags = asmVisitorWrapper.mergeWriter(flags);
            }
            return flags;
        }

        @Override
        public int mergeReader(int flags) {
            for (AsmVisitorWrapper asmVisitorWrapper : this.asmVisitorWrappers) {
                flags = asmVisitorWrapper.mergeReader(flags);
            }
            return flags;
        }

        @Override
        public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor) {
            for (AsmVisitorWrapper asmVisitorWrapper : this.asmVisitorWrappers) {
                classVisitor = asmVisitorWrapper.wrap(instrumentedType, classVisitor);
            }
            return classVisitor;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.asmVisitorWrappers.equals(((Compound)other).asmVisitorWrappers);
        }

        public int hashCode() {
            return this.asmVisitorWrappers.hashCode();
        }

        public String toString() {
            return "AsmVisitorWrapper.Compound{asmVisitorWrappers=" + this.asmVisitorWrappers + '}';
        }
    }

    public static class ForDeclaredMethods
    extends AbstractBase {
        private final List<Entry> entries;

        public ForDeclaredMethods() {
            this(Collections.emptyList());
        }

        protected ForDeclaredMethods(List<Entry> entries) {
            this.entries = entries;
        }

        public ForDeclaredMethods method(ElementMatcher<? super MethodDescription.InDefinedShape> matcher, MethodVisitorWrapper methodVisitorWrapper) {
            return new ForDeclaredMethods(CompoundList.of(this.entries, new Entry(matcher, methodVisitorWrapper)));
        }

        @Override
        public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor) {
            return new DispatchingVisitor(classVisitor, instrumentedType);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.entries.equals(((ForDeclaredMethods)other).entries);
        }

        public int hashCode() {
            return this.entries.hashCode();
        }

        public String toString() {
            return "AsmVisitorWrapper.ForDeclaredMethods{entries=" + this.entries + '}';
        }

        protected class DispatchingVisitor
        extends ClassVisitor {
            private final TypeDescription instrumentedType;
            private final Map<String, MethodDescription.InDefinedShape> methodsByName;

            protected DispatchingVisitor(ClassVisitor classVisitor, TypeDescription instrumentedType) {
                super(327680, classVisitor);
                this.instrumentedType = instrumentedType;
                this.methodsByName = new HashMap<String, MethodDescription.InDefinedShape>();
                for (MethodDescription.InDefinedShape methodDescription : instrumentedType.getDeclaredMethods()) {
                    this.methodsByName.put(methodDescription.getInternalName() + methodDescription.getDescriptor(), methodDescription);
                }
            }

            @Override
            public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String signature, String[] exceptions) {
                MethodVisitor methodVisitor = super.visitMethod(modifiers, internalName, descriptor, signature, exceptions);
                MethodDescription.InDefinedShape methodDescription = this.methodsByName.get(internalName + descriptor);
                for (Entry entry : ForDeclaredMethods.this.entries) {
                    if (!entry.matches(methodDescription)) continue;
                    methodVisitor = entry.wrap(this.instrumentedType, methodDescription, methodVisitor);
                }
                return methodVisitor;
            }

            private ForDeclaredMethods getOuter() {
                return ForDeclaredMethods.this;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                DispatchingVisitor that = (DispatchingVisitor)other;
                return this.instrumentedType.equals(that.instrumentedType) && this.getOuter().equals(that.getOuter()) && this.cv.equals(that.cv);
            }

            public int hashCode() {
                int result = this.getOuter().hashCode();
                result = 31 * result + this.instrumentedType.hashCode();
                result = 31 * result + this.cv.hashCode();
                return result;
            }

            public String toString() {
                return "AsmVisitorWrapper.ForDeclaredMethods.DispatchingVisitor{outer=" + this.getOuter() + ", instrumentedType=" + this.instrumentedType + ", methodsByName=" + this.methodsByName + '}';
            }
        }

        protected static class Entry
        implements ElementMatcher<MethodDescription.InDefinedShape>,
        MethodVisitorWrapper {
            private final ElementMatcher<? super MethodDescription.InDefinedShape> matcher;
            private final MethodVisitorWrapper methodVisitorWrapper;

            protected Entry(ElementMatcher<? super MethodDescription.InDefinedShape> matcher, MethodVisitorWrapper methodVisitorWrapper) {
                this.matcher = matcher;
                this.methodVisitorWrapper = methodVisitorWrapper;
            }

            @Override
            public boolean matches(MethodDescription.InDefinedShape target) {
                return target != null && this.matcher.matches(target);
            }

            @Override
            public MethodVisitor wrap(TypeDescription instrumentedType, MethodDescription.InDefinedShape methodDescription, MethodVisitor methodVisitor) {
                return this.methodVisitorWrapper.wrap(instrumentedType, methodDescription, methodVisitor);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Entry entry = (Entry)other;
                return this.matcher.equals(entry.matcher) && this.methodVisitorWrapper.equals(entry.methodVisitorWrapper);
            }

            public int hashCode() {
                int result = this.matcher.hashCode();
                result = 31 * result + this.methodVisitorWrapper.hashCode();
                return result;
            }

            public String toString() {
                return "AsmVisitorWrapper.ForDeclaredMethods.Entry{matcher=" + this.matcher + ", methodVisitorWrapper=" + this.methodVisitorWrapper + '}';
            }
        }

        public static interface MethodVisitorWrapper {
            public MethodVisitor wrap(TypeDescription var1, MethodDescription.InDefinedShape var2, MethodVisitor var3);
        }
    }

    public static class ForDeclaredFields
    extends AbstractBase {
        private final List<Entry> entries;

        public ForDeclaredFields() {
            this(Collections.emptyList());
        }

        protected ForDeclaredFields(List<Entry> entries) {
            this.entries = entries;
        }

        public ForDeclaredFields field(ElementMatcher<? super FieldDescription.InDefinedShape> matcher, FieldVisitorWrapper fieldVisitorWrapper) {
            return new ForDeclaredFields(CompoundList.of(this.entries, new Entry(matcher, fieldVisitorWrapper)));
        }

        @Override
        public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor) {
            return new DispatchingVisitor(classVisitor, instrumentedType);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.entries.equals(((ForDeclaredFields)other).entries);
        }

        public int hashCode() {
            return this.entries.hashCode();
        }

        public String toString() {
            return "AsmVisitorWrapper.ForDeclaredFields{entries=" + this.entries + '}';
        }

        protected class DispatchingVisitor
        extends ClassVisitor {
            private final TypeDescription instrumentedType;
            private final Map<String, FieldDescription.InDefinedShape> fieldsByName;

            protected DispatchingVisitor(ClassVisitor classVisitor, TypeDescription instrumentedType) {
                super(327680, classVisitor);
                this.instrumentedType = instrumentedType;
                this.fieldsByName = new HashMap<String, FieldDescription.InDefinedShape>();
                for (FieldDescription.InDefinedShape fieldDescription : instrumentedType.getDeclaredFields()) {
                    this.fieldsByName.put(fieldDescription.getInternalName(), fieldDescription);
                }
            }

            @Override
            public FieldVisitor visitField(int modifiers, String internalName, String descriptor, String signature, Object defaultValue) {
                FieldVisitor fieldVisitor = super.visitField(modifiers, internalName, descriptor, signature, defaultValue);
                FieldDescription.InDefinedShape fieldDescription = this.fieldsByName.get(internalName);
                for (Entry entry : ForDeclaredFields.this.entries) {
                    if (!entry.matches(fieldDescription)) continue;
                    fieldVisitor = entry.wrap(this.instrumentedType, fieldDescription, fieldVisitor);
                }
                return fieldVisitor;
            }

            private ForDeclaredFields getOuter() {
                return ForDeclaredFields.this;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                DispatchingVisitor that = (DispatchingVisitor)other;
                return this.instrumentedType.equals(that.instrumentedType) && this.cv.equals(that.cv) && this.getOuter().equals(that.getOuter());
            }

            public int hashCode() {
                int result = this.getOuter().hashCode();
                result = 31 * result + this.instrumentedType.hashCode();
                result = 31 * result + this.cv.hashCode();
                return result;
            }

            public String toString() {
                return "AsmVisitorWrapper.ForDeclaredFields.DispatchingVisitor{outer=" + this.getOuter() + ", instrumentedType=" + this.instrumentedType + ", fieldsByName=" + this.fieldsByName + '}';
            }
        }

        protected static class Entry
        implements ElementMatcher<FieldDescription.InDefinedShape>,
        FieldVisitorWrapper {
            private final ElementMatcher<? super FieldDescription.InDefinedShape> matcher;
            private final FieldVisitorWrapper fieldVisitorWrapper;

            protected Entry(ElementMatcher<? super FieldDescription.InDefinedShape> matcher, FieldVisitorWrapper fieldVisitorWrapper) {
                this.matcher = matcher;
                this.fieldVisitorWrapper = fieldVisitorWrapper;
            }

            @Override
            public boolean matches(FieldDescription.InDefinedShape target) {
                return target != null && this.matcher.matches(target);
            }

            @Override
            public FieldVisitor wrap(TypeDescription instrumentedType, FieldDescription.InDefinedShape fieldDescription, FieldVisitor fieldVisitor) {
                return this.fieldVisitorWrapper.wrap(instrumentedType, fieldDescription, fieldVisitor);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Entry entry = (Entry)other;
                return this.matcher.equals(entry.matcher) && this.fieldVisitorWrapper.equals(entry.fieldVisitorWrapper);
            }

            public int hashCode() {
                int result = this.matcher.hashCode();
                result = 31 * result + this.fieldVisitorWrapper.hashCode();
                return result;
            }

            public String toString() {
                return "AsmVisitorWrapper.ForDeclaredFields.Entry{matcher=" + this.matcher + ", fieldVisitorWrapper=" + this.fieldVisitorWrapper + '}';
            }
        }

        public static interface FieldVisitorWrapper {
            public FieldVisitor wrap(TypeDescription var1, FieldDescription.InDefinedShape var2, FieldVisitor var3);
        }
    }

    public static abstract class AbstractBase
    implements AsmVisitorWrapper {
        @Override
        public int mergeWriter(int flags) {
            return flags;
        }

        @Override
        public int mergeReader(int flags) {
            return flags;
        }
    }

    public static enum NoOp implements AsmVisitorWrapper
    {
        INSTANCE;


        @Override
        public int mergeWriter(int flags) {
            return flags;
        }

        @Override
        public int mergeReader(int flags) {
            return flags;
        }

        @Override
        public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor) {
            return classVisitor;
        }

        public String toString() {
            return "AsmVisitorWrapper.NoOp." + this.name();
        }
    }
}

