/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public interface LatentMatcher<T> {
    public ElementMatcher<? super T> resolve(TypeDescription var1);

    public static class Compound<S>
    implements LatentMatcher<S> {
        private final List<? extends LatentMatcher<? super S>> matchers;

        public Compound(LatentMatcher<? super S> ... matcher) {
            this(Arrays.asList(matcher));
        }

        public Compound(List<? extends LatentMatcher<? super S>> matchers) {
            this.matchers = matchers;
        }

        @Override
        public ElementMatcher<? super S> resolve(TypeDescription instrumentedType) {
            ElementMatcher.Junction<Object> matcher = ElementMatchers.none();
            for (LatentMatcher<S> latentMatcher : this.matchers) {
                matcher = matcher.or(latentMatcher.resolve(instrumentedType));
            }
            return matcher;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.matchers.equals(((Compound)other).matchers);
        }

        public int hashCode() {
            return this.matchers.hashCode();
        }

        public String toString() {
            return "LatentMatcher.Compound{matchers=" + this.matchers + '}';
        }
    }

    public static class ForMethodToken
    implements LatentMatcher<MethodDescription> {
        private final MethodDescription.Token token;

        public ForMethodToken(MethodDescription.Token token) {
            this.token = token;
        }

        @Override
        public ElementMatcher<? super MethodDescription> resolve(TypeDescription instrumentedType) {
            return new ResolvedMatcher(instrumentedType, this.token);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.token.equals(((ForMethodToken)other).token);
        }

        public int hashCode() {
            return this.token.hashCode();
        }

        public String toString() {
            return "LatentMatcher.ForMethodToken{token=" + this.token + '}';
        }

        protected static class ResolvedMatcher
        implements ElementMatcher<MethodDescription> {
            private final TypeDescription instrumentedType;
            private final MethodDescription.Token token;

            protected ResolvedMatcher(TypeDescription instrumentedType, MethodDescription.Token token) {
                this.instrumentedType = instrumentedType;
                this.token = token;
            }

            @Override
            public boolean matches(MethodDescription target) {
                return ((MethodDescription.Token)target.asToken(ElementMatchers.is(this.instrumentedType))).equals(this.token);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                ResolvedMatcher that = (ResolvedMatcher)other;
                return this.instrumentedType.equals(that.instrumentedType) && this.token.equals(that.token);
            }

            public int hashCode() {
                int result = this.instrumentedType.hashCode();
                result = 31 * result + this.token.hashCode();
                return result;
            }

            public String toString() {
                return "LatentMatcher.ForMethodToken.ResolvedMatcher{instrumentedType=" + this.instrumentedType + ", token=" + this.token + '}';
            }
        }
    }

    public static class ForFieldToken
    implements LatentMatcher<FieldDescription> {
        private final FieldDescription.Token token;

        public ForFieldToken(FieldDescription.Token token) {
            this.token = token;
        }

        @Override
        public ElementMatcher<? super FieldDescription> resolve(TypeDescription instrumentedType) {
            return new ResolvedMatcher(instrumentedType, this.token);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.token.equals(((ForFieldToken)other).token);
        }

        public int hashCode() {
            return this.token.hashCode();
        }

        public String toString() {
            return "LatentMatcher.ForFieldToken{token=" + this.token + '}';
        }

        protected static class ResolvedMatcher
        implements ElementMatcher<FieldDescription> {
            private final TypeDescription instrumentedType;
            private final FieldDescription.Token token;

            protected ResolvedMatcher(TypeDescription instrumentedType, FieldDescription.Token token) {
                this.instrumentedType = instrumentedType;
                this.token = token;
            }

            @Override
            public boolean matches(FieldDescription target) {
                return ((FieldDescription.Token)target.asToken(ElementMatchers.is(this.instrumentedType))).equals(this.token);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                ResolvedMatcher that = (ResolvedMatcher)other;
                return this.instrumentedType.equals(that.instrumentedType) && this.token.equals(that.token);
            }

            public int hashCode() {
                int result = this.instrumentedType.hashCode();
                result = 31 * result + this.token.hashCode();
                return result;
            }

            public String toString() {
                return "LatentMatcher.ForFieldToken.ResolvedMatcher{instrumentedType=" + this.instrumentedType + ", token=" + this.token + '}';
            }
        }
    }

    public static class Resolved<S>
    implements LatentMatcher<S> {
        private final ElementMatcher<? super S> matcher;

        public Resolved(ElementMatcher<? super S> matcher) {
            this.matcher = matcher;
        }

        @Override
        public ElementMatcher<? super S> resolve(TypeDescription instrumentedType) {
            return this.matcher;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.matcher.equals(((Resolved)other).matcher);
        }

        public int hashCode() {
            return this.matcher.hashCode();
        }

        public String toString() {
            return "LatentMatcher.Resolved{matcher=" + this.matcher + '}';
        }
    }
}

