/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic;

import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.matcher.ElementMatchers;

public interface MethodTransformer {
    public MethodDescription transform(TypeDescription var1, MethodDescription var2);

    public static class Compound
    implements MethodTransformer {
        private final List<? extends MethodTransformer> methodTransformers;

        public Compound(MethodTransformer ... methodTransformer) {
            this(Arrays.asList(methodTransformer));
        }

        public Compound(List<? extends MethodTransformer> methodTransformers) {
            this.methodTransformers = methodTransformers;
        }

        @Override
        public MethodDescription transform(TypeDescription instrumentedType, MethodDescription methodDescription) {
            MethodDescription transformed = methodDescription;
            for (MethodTransformer methodTransformer : this.methodTransformers) {
                transformed = methodTransformer.transform(instrumentedType, transformed);
            }
            return transformed;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.methodTransformers.equals(((Compound)other).methodTransformers);
        }

        public int hashCode() {
            return this.methodTransformers.hashCode();
        }

        public String toString() {
            return "MethodTransformer.Compound{methodTransformers=" + this.methodTransformers + '}';
        }
    }

    public static class Simple
    implements MethodTransformer {
        private final TokenTransformer tokenTransformer;

        public Simple(TokenTransformer tokenTransformer) {
            this.tokenTransformer = tokenTransformer;
        }

        public static MethodTransformer withModifiers(ModifierContributor.ForMethod ... modifierTransformer) {
            return new Simple(new TokenTransformer.ForModifierTransformation(Arrays.asList(modifierTransformer)));
        }

        @Override
        public MethodDescription transform(TypeDescription instrumentedType, MethodDescription methodDescription) {
            return new TransformedMethod(methodDescription.getDeclaringType(), this.tokenTransformer.transform((MethodDescription.Token)methodDescription.asToken(ElementMatchers.is(instrumentedType))), (MethodDescription.InDefinedShape)methodDescription.asDefined());
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.tokenTransformer.equals(((Simple)other).tokenTransformer);
        }

        public int hashCode() {
            return this.tokenTransformer.hashCode();
        }

        public String toString() {
            return "MethodTransformer.Simple{tokenTransformer=" + this.tokenTransformer + '}';
        }

        protected static class TransformedMethod
        extends MethodDescription.AbstractBase {
            private final TypeDefinition declaringType;
            private final MethodDescription.Token token;
            private final MethodDescription.InDefinedShape methodDescription;

            protected TransformedMethod(TypeDefinition declaringType, MethodDescription.Token token, MethodDescription.InDefinedShape methodDescription) {
                this.declaringType = declaringType;
                this.token = token;
                this.methodDescription = methodDescription;
            }

            @Override
            public TypeList.Generic getTypeVariables() {
                return TypeList.Generic.ForDetachedTypes.attachVariables(this, this.token.getTypeVariableTokens());
            }

            @Override
            public TypeDescription.Generic getReturnType() {
                return this.token.getReturnType().accept(TypeDescription.Generic.Visitor.Substitutor.ForAttachment.of(this));
            }

            @Override
            public ParameterList<?> getParameters() {
                return new TransformedParameterList();
            }

            @Override
            public TypeList.Generic getExceptionTypes() {
                return TypeList.Generic.ForDetachedTypes.attach(this, (List<? extends TypeDescription.Generic>)this.token.getExceptionTypes());
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return this.token.getAnnotations();
            }

            @Override
            public String getInternalName() {
                return this.token.getName();
            }

            @Override
            public TypeDefinition getDeclaringType() {
                return this.declaringType;
            }

            @Override
            public int getModifiers() {
                return this.token.getModifiers();
            }

            @Override
            public Object getDefaultValue() {
                return this.token.getDefaultValue();
            }

            @Override
            public MethodDescription.InDefinedShape asDefined() {
                return this.methodDescription;
            }

            @Override
            public TypeDescription.Generic getReceiverType() {
                return this.methodDescription.getReceiverType();
            }

            protected class TransformedParameter
            extends ParameterDescription.AbstractBase {
                private final int index;
                private final ParameterDescription.Token parameterToken;

                protected TransformedParameter(int index, ParameterDescription.Token parameterToken) {
                    this.index = index;
                    this.parameterToken = parameterToken;
                }

                @Override
                public TypeDescription.Generic getType() {
                    return this.parameterToken.getType().accept(TypeDescription.Generic.Visitor.Substitutor.ForAttachment.of(this));
                }

                @Override
                public MethodDescription getDeclaringMethod() {
                    return TransformedMethod.this;
                }

                @Override
                public int getIndex() {
                    return this.index;
                }

                @Override
                public boolean isNamed() {
                    return this.parameterToken.getName() != null;
                }

                @Override
                public boolean hasModifiers() {
                    return this.parameterToken.getModifiers() != null;
                }

                @Override
                public String getName() {
                    return this.isNamed() ? this.parameterToken.getName() : super.getName();
                }

                @Override
                public int getModifiers() {
                    return this.hasModifiers() ? this.parameterToken.getModifiers().intValue() : super.getModifiers();
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return this.parameterToken.getAnnotations();
                }

                @Override
                public ParameterDescription.InDefinedShape asDefined() {
                    return (ParameterDescription.InDefinedShape)TransformedMethod.this.methodDescription.getParameters().get(this.index);
                }
            }

            protected class TransformedParameterList
            extends ParameterList.AbstractBase<ParameterDescription> {
                protected TransformedParameterList() {
                }

                @Override
                public ParameterDescription get(int index) {
                    return new TransformedParameter(index, (ParameterDescription.Token)TransformedMethod.this.token.getParameterTokens().get(index));
                }

                @Override
                public int size() {
                    return TransformedMethod.this.token.getParameterTokens().size();
                }
            }
        }

        public static interface TokenTransformer {
            public MethodDescription.Token transform(MethodDescription.Token var1);

            public static class ForModifierTransformation
            implements TokenTransformer {
                private final List<? extends ModifierContributor.ForMethod> modifierContributors;

                public ForModifierTransformation(List<? extends ModifierContributor.ForMethod> modifierContributors) {
                    this.modifierContributors = modifierContributors;
                }

                @Override
                public MethodDescription.Token transform(MethodDescription.Token token) {
                    return new MethodDescription.Token(token.getName(), ModifierContributor.Resolver.of(this.modifierContributors).resolve(token.getModifiers()), token.getTypeVariableTokens(), token.getReturnType(), token.getParameterTokens(), token.getExceptionTypes(), token.getAnnotations(), token.getDefaultValue());
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.modifierContributors.equals(((ForModifierTransformation)other).modifierContributors);
                }

                public int hashCode() {
                    return this.modifierContributors.hashCode();
                }

                public String toString() {
                    return "MethodTransformer.Simple.TokenTransformer.ForModifierTransformation{modifierContributors=" + this.modifierContributors + '}';
                }
            }
        }
    }

    public static enum NoOp implements MethodTransformer
    {
        INSTANCE;


        @Override
        public MethodDescription transform(TypeDescription instrumentedType, MethodDescription methodDescription) {
            return methodDescription;
        }

        public String toString() {
            return "MethodTransformer.NoOp." + this.name();
        }
    }
}

