/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.attribute;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.attribute.AnnotationAppender;
import net.bytebuddy.jar.asm.MethodVisitor;

public interface MethodAttributeAppender {
    public void apply(MethodVisitor var1, MethodDescription var2);

    public static class Compound
    implements MethodAttributeAppender {
        private final MethodAttributeAppender[] methodAttributeAppender;

        public Compound(MethodAttributeAppender ... methodAttributeAppender) {
            this.methodAttributeAppender = methodAttributeAppender;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription) {
            for (MethodAttributeAppender methodAttributeAppender : this.methodAttributeAppender) {
                methodAttributeAppender.apply(methodVisitor, methodDescription);
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.methodAttributeAppender, ((Compound)other).methodAttributeAppender);
        }

        public int hashCode() {
            return Arrays.hashCode(this.methodAttributeAppender);
        }

        public String toString() {
            return "MethodAttributeAppender.Compound{methodAttributeAppender=" + Arrays.toString(this.methodAttributeAppender) + '}';
        }
    }

    public static class ForMethod
    implements MethodAttributeAppender,
    Factory {
        private final MethodDescription methodDescription;
        private final AnnotationAppender.ValueFilter valueFilter;

        public ForMethod(Constructor<?> constructor, AnnotationAppender.ValueFilter valueFilter) {
            this(new MethodDescription.ForLoadedConstructor(constructor), valueFilter);
        }

        public ForMethod(Method method, AnnotationAppender.ValueFilter valueFilter) {
            this(new MethodDescription.ForLoadedMethod(method), valueFilter);
        }

        public ForMethod(MethodDescription methodDescription, AnnotationAppender.ValueFilter valueFilter) {
            this.methodDescription = methodDescription;
            this.valueFilter = valueFilter;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription) {
            if (this.methodDescription.getParameters().size() > methodDescription.getParameters().size()) {
                throw new IllegalArgumentException(this.methodDescription + " has more parameters than the instrumented method " + methodDescription);
            }
            AnnotationAppender.Default methodAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnMethod(methodVisitor), this.valueFilter);
            for (AnnotationDescription annotation : this.methodDescription.getDeclaredAnnotations()) {
                methodAppender.append(annotation, AnnotationAppender.AnnotationVisibility.of(annotation));
            }
            int index = 0;
            for (ParameterDescription parameterDescription : this.methodDescription.getParameters()) {
                AnnotationAppender.Default parameterAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnMethodParameter(methodVisitor, index++), this.valueFilter);
                for (AnnotationDescription annotation : parameterDescription.getDeclaredAnnotations()) {
                    parameterAppender.append(annotation, AnnotationAppender.AnnotationVisibility.of(annotation));
                }
            }
        }

        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.methodDescription.equals(((ForMethod)other).methodDescription) && this.valueFilter.equals(((ForMethod)other).valueFilter);
        }

        public int hashCode() {
            return 31 * this.methodDescription.hashCode() + this.valueFilter.hashCode();
        }

        public String toString() {
            return "MethodAttributeAppender.ForMethod{methodDescription=" + this.methodDescription + ", valueFilter=" + this.valueFilter + '}';
        }
    }

    public static class ForAnnotation
    implements MethodAttributeAppender,
    Factory {
        private final List<? extends AnnotationDescription> annotations;
        private final Target target;
        private final AnnotationAppender.ValueFilter valueFilter;

        public ForAnnotation(int parameterIndex, AnnotationAppender.ValueFilter valueFilter, Annotation ... annotation) {
            this(parameterIndex, new AnnotationList.ForLoadedAnnotation(annotation), valueFilter);
        }

        public ForAnnotation(AnnotationAppender.ValueFilter valueFilter, Annotation ... annotation) {
            this(new AnnotationList.ForLoadedAnnotation(annotation), valueFilter);
        }

        public ForAnnotation(int parameterIndex, List<? extends AnnotationDescription> annotations, AnnotationAppender.ValueFilter valueFilter) {
            this.annotations = annotations;
            this.target = new Target.OnMethodParameter(parameterIndex);
            this.valueFilter = valueFilter;
        }

        public ForAnnotation(List<? extends AnnotationDescription> annotations, AnnotationAppender.ValueFilter valueFilter) {
            this.annotations = annotations;
            this.target = Target.OnMethod.INSTANCE;
            this.valueFilter = valueFilter;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription) {
            AnnotationAppender.Default appender = new AnnotationAppender.Default(this.target.make(methodVisitor, methodDescription), this.valueFilter);
            for (AnnotationDescription annotationDescription : this.annotations) {
                appender.append(annotationDescription, AnnotationAppender.AnnotationVisibility.of(annotationDescription));
            }
        }

        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.annotations.equals(((ForAnnotation)other).annotations) && this.valueFilter.equals(((ForAnnotation)other).valueFilter) && this.target.equals(((ForAnnotation)other).target);
        }

        public int hashCode() {
            return 31 * (31 * this.annotations.hashCode() + this.valueFilter.hashCode()) + this.target.hashCode();
        }

        public String toString() {
            return "MethodAttributeAppender.ForAnnotation{annotations=" + this.annotations + ", valueFilter=" + this.valueFilter + ", target=" + this.target + '}';
        }

        protected static interface Target {
            public AnnotationAppender.Target make(MethodVisitor var1, MethodDescription var2);

            public static class OnMethodParameter
            implements Target {
                private final int parameterIndex;

                protected OnMethodParameter(int parameterIndex) {
                    this.parameterIndex = parameterIndex;
                }

                @Override
                public AnnotationAppender.Target make(MethodVisitor methodVisitor, MethodDescription methodDescription) {
                    if (this.parameterIndex >= methodDescription.getParameters().size()) {
                        throw new IllegalArgumentException("Method " + methodDescription + " has less then " + this.parameterIndex + " parameters");
                    }
                    return new AnnotationAppender.Target.OnMethodParameter(methodVisitor, this.parameterIndex);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.parameterIndex == ((OnMethodParameter)other).parameterIndex;
                }

                public int hashCode() {
                    return this.parameterIndex;
                }

                public String toString() {
                    return "MethodAttributeAppender.ForAnnotation.Target.OnMethodParameter{parameterIndex=" + this.parameterIndex + '}';
                }
            }

            public static enum OnMethod implements Target
            {
                INSTANCE;


                @Override
                public AnnotationAppender.Target make(MethodVisitor methodVisitor, MethodDescription methodDescription) {
                    return new AnnotationAppender.Target.OnMethod(methodVisitor);
                }

                public String toString() {
                    return "MethodAttributeAppender.ForAnnotation.Target.OnMethod." + this.name();
                }
            }
        }
    }

    public static class ForInstrumentedMethod
    implements Factory {
        private final AnnotationAppender.ValueFilter valueFilter;

        public ForInstrumentedMethod(AnnotationAppender.ValueFilter valueFilter) {
            this.valueFilter = valueFilter;
        }

        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return new Appender(typeDescription, this.valueFilter);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.valueFilter.equals(((ForInstrumentedMethod)other).valueFilter);
        }

        public int hashCode() {
            return this.valueFilter.hashCode();
        }

        public String toString() {
            return "MethodAttributeAppender.ForInstrumentedMethod{valueFilter=" + this.valueFilter + '}';
        }

        protected static class Appender
        implements MethodAttributeAppender {
            private final TypeDescription instrumentedType;
            private final AnnotationAppender.ValueFilter valueFilter;

            protected Appender(TypeDescription instrumentedType, AnnotationAppender.ValueFilter valueFilter) {
                this.instrumentedType = instrumentedType;
                this.valueFilter = valueFilter;
            }

            @Override
            public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription) {
                if (methodDescription.getDeclaringType().equals(this.instrumentedType)) {
                    return;
                }
                AnnotationAppender.Default methodAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnMethod(methodVisitor), this.valueFilter);
                for (AnnotationDescription annotation : methodDescription.getDeclaredAnnotations()) {
                    methodAppender.append(annotation, AnnotationAppender.AnnotationVisibility.of(annotation));
                }
                int index = 0;
                for (ParameterDescription parameterDescription : methodDescription.getParameters()) {
                    AnnotationAppender.Default parameterAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnMethodParameter(methodVisitor, index++), this.valueFilter);
                    for (AnnotationDescription annotation : parameterDescription.getDeclaredAnnotations()) {
                        parameterAppender.append(annotation, AnnotationAppender.AnnotationVisibility.of(annotation));
                    }
                }
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Appender appender = (Appender)other;
                return this.instrumentedType.equals(appender.instrumentedType) && this.valueFilter.equals(appender.valueFilter);
            }

            public int hashCode() {
                int result = this.instrumentedType.hashCode();
                result = 31 * result + this.valueFilter.hashCode();
                return result;
            }

            public String toString() {
                return "MethodAttributeAppender.ForInstrumentedMethod.Appender{instrumentedType=" + this.instrumentedType + ", valueFilter=" + this.valueFilter + '}';
            }
        }
    }

    public static interface Factory {
        public MethodAttributeAppender make(TypeDescription var1);

        public static class Compound
        implements Factory {
            private final Factory[] factory;

            public Compound(Factory ... factory) {
                this.factory = factory;
            }

            @Override
            public MethodAttributeAppender make(TypeDescription typeDescription) {
                MethodAttributeAppender[] methodAttributeAppender = new MethodAttributeAppender[this.factory.length];
                int index = 0;
                for (Factory factory : this.factory) {
                    methodAttributeAppender[index++] = factory.make(typeDescription);
                }
                return new net.bytebuddy.implementation.attribute.MethodAttributeAppender$Compound(methodAttributeAppender);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.factory, ((Compound)other).factory);
            }

            public int hashCode() {
                return Arrays.hashCode(this.factory);
            }

            public String toString() {
                return "MethodAttributeAppender.Factory.Compound{factory=" + Arrays.toString(this.factory) + '}';
            }
        }
    }

    public static enum NoOp implements MethodAttributeAppender,
    Factory
    {
        INSTANCE;


        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription) {
        }

        public String toString() {
            return "MethodAttributeAppender.NoOp." + this.name();
        }
    }
}

