/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.type;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.bytebuddy.description.ModifierReviewable;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.PackageDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.description.type.generic.GenericTypeDescription;
import net.bytebuddy.description.type.generic.GenericTypeList;
import net.bytebuddy.description.type.generic.TypeVariableSource;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.jar.asm.signature.SignatureWriter;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.ByteBuddyCommons;
import net.bytebuddy.utility.JavaType;

public interface TypeDescription
extends GenericTypeDescription,
TypeVariableSource {
    public static final TypeDescription OBJECT = new ForLoadedType(Object.class);
    public static final TypeDescription STRING = new ForLoadedType(String.class);
    public static final TypeDescription CLASS = new ForLoadedType(Class.class);
    public static final TypeDescription VOID = new ForLoadedType(Void.TYPE);
    public static final TypeDescription ENUM = new ForLoadedType(Enum.class);
    public static final int ARRAY_MODIFIERS = 1041;
    public static final GenericTypeList ARRAY_INTERFACES = new GenericTypeList.ForLoadedType(new Type[]{Cloneable.class, Serializable.class});
    public static final TypeDescription UNDEFINED = null;

    public FieldList<FieldDescription.InDefinedShape> getDeclaredFields();

    public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods();

    public boolean isInstance(Object var1);

    public boolean isInstanceOrWrapper(Object var1);

    public boolean isAssignableFrom(Class<?> var1);

    public boolean isAssignableFrom(TypeDescription var1);

    public boolean isAssignableTo(Class<?> var1);

    public boolean isAssignableTo(TypeDescription var1);

    @Override
    public TypeDescription getComponentType();

    @Override
    public TypeDescription getOwnerType();

    @Override
    public TypeDescription getDeclaringType();

    public TypeList getDeclaredTypes();

    public MethodDescription getEnclosingMethod();

    public TypeDescription getEnclosingType();

    public int getActualModifiers(boolean var1);

    public String getSimpleName();

    public String getCanonicalName();

    public boolean isAnonymousClass();

    public boolean isLocalClass();

    public boolean isMemberClass();

    public PackageDescription getPackage();

    public AnnotationList getInheritedAnnotations();

    public boolean isSamePackage(TypeDescription var1);

    public boolean isConstantPool();

    public boolean isPrimitiveWrapper();

    public boolean isAnnotationReturnType();

    public boolean isAnnotationValue();

    public boolean isAnnotationValue(Object var1);

    public static class ForPackageDescription
    extends AbstractBase.OfSimpleType {
        private final PackageDescription packageDescription;

        public ForPackageDescription(PackageDescription packageDescription) {
            this.packageDescription = packageDescription;
        }

        @Override
        protected GenericTypeDescription getDeclaredSuperType() {
            return OBJECT;
        }

        @Override
        protected GenericTypeList getDeclaredInterfaces() {
            return new GenericTypeList.Empty();
        }

        @Override
        public MethodDescription getEnclosingMethod() {
            return MethodDescription.UNDEFINED;
        }

        @Override
        public TypeDescription getEnclosingType() {
            return UNDEFINED;
        }

        @Override
        public boolean isAnonymousClass() {
            return false;
        }

        @Override
        public boolean isLocalClass() {
            return false;
        }

        @Override
        public boolean isMemberClass() {
            return false;
        }

        @Override
        public TypeList getDeclaredTypes() {
            return new TypeList.Empty();
        }

        @Override
        public FieldList<FieldDescription.InDefinedShape> getDeclaredFields() {
            return new FieldList.Empty();
        }

        @Override
        public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods() {
            return new MethodList.Empty();
        }

        @Override
        public PackageDescription getPackage() {
            return this.packageDescription;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return this.packageDescription.getDeclaredAnnotations();
        }

        @Override
        public TypeDescription getDeclaringType() {
            return UNDEFINED;
        }

        @Override
        public GenericTypeList getTypeVariables() {
            return new GenericTypeList.Empty();
        }

        @Override
        public int getModifiers() {
            return 5632;
        }

        @Override
        public String getName() {
            return this.packageDescription.getName() + "." + "package-info";
        }
    }

    public static class Latent
    extends AbstractBase.OfSimpleType {
        private final String name;
        private final int modifiers;
        private final GenericTypeDescription superType;
        private final List<? extends GenericTypeDescription> interfaces;

        public Latent(String name, int modifiers, GenericTypeDescription superType, List<? extends GenericTypeDescription> interfaces) {
            this.name = name;
            this.modifiers = modifiers;
            this.superType = superType;
            this.interfaces = interfaces;
        }

        @Override
        protected GenericTypeDescription getDeclaredSuperType() {
            return this.superType;
        }

        @Override
        protected GenericTypeList getDeclaredInterfaces() {
            return new GenericTypeList.Explicit(this.interfaces);
        }

        @Override
        public MethodDescription getEnclosingMethod() {
            throw new IllegalStateException("Cannot resolve enclosing method of a latent type description: " + this);
        }

        @Override
        public TypeDescription getEnclosingType() {
            throw new IllegalStateException("Cannot resolve enclosing type of a latent type description: " + this);
        }

        @Override
        public TypeList getDeclaredTypes() {
            throw new IllegalStateException("Cannot resolve inner types of a latent type description: " + this);
        }

        @Override
        public boolean isAnonymousClass() {
            throw new IllegalStateException("Cannot resolve anonymous type property of a latent type description: " + this);
        }

        @Override
        public boolean isLocalClass() {
            throw new IllegalStateException("Cannot resolve local class property of a latent type description: " + this);
        }

        @Override
        public boolean isMemberClass() {
            throw new IllegalStateException("Cannot resolve member class property of a latent type description: " + this);
        }

        @Override
        public FieldList<FieldDescription.InDefinedShape> getDeclaredFields() {
            throw new IllegalStateException("Cannot resolve declared fields of a latent type description: " + this);
        }

        @Override
        public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods() {
            throw new IllegalStateException("Cannot resolve declared methods of a latent type description: " + this);
        }

        @Override
        public PackageDescription getPackage() {
            String name = this.getName();
            int index = name.lastIndexOf(46);
            return index == -1 ? PackageDescription.UNDEFINED : new PackageDescription.Simple(name.substring(0, index));
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            throw new IllegalStateException("Cannot resolve declared annotations of a latent type description: " + this);
        }

        @Override
        public TypeDescription getDeclaringType() {
            throw new IllegalStateException("Cannot resolve declared type of a latent type description: " + this);
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public GenericTypeList getTypeVariables() {
            throw new IllegalStateException("Cannot resolve type variables of a latent type description: " + this);
        }
    }

    public static class ArrayProjection
    extends AbstractBase {
        private final TypeDescription componentType;
        private final int arity;

        protected ArrayProjection(TypeDescription componentType, int arity) {
            this.componentType = componentType;
            this.arity = arity;
        }

        public static TypeDescription of(TypeDescription componentType, int arity) {
            if (arity < 0) {
                throw new IllegalArgumentException("Arrays cannot have a negative arity");
            }
            while (componentType.isArray()) {
                componentType = componentType.getComponentType();
                ++arity;
            }
            return arity == 0 ? componentType : new ArrayProjection(componentType, arity);
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public TypeDescription getComponentType() {
            return this.arity == 1 ? this.componentType : new ArrayProjection(this.componentType, this.arity - 1);
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        protected GenericTypeDescription getDeclaredSuperType() {
            return OBJECT;
        }

        @Override
        protected GenericTypeList getDeclaredInterfaces() {
            return ARRAY_INTERFACES;
        }

        @Override
        public MethodDescription getEnclosingMethod() {
            return MethodDescription.UNDEFINED;
        }

        @Override
        public TypeDescription getEnclosingType() {
            return UNDEFINED;
        }

        @Override
        public TypeList getDeclaredTypes() {
            return new TypeList.Empty();
        }

        @Override
        public String getSimpleName() {
            StringBuilder stringBuilder = new StringBuilder(this.componentType.getSimpleName());
            for (int i = 0; i < this.arity; ++i) {
                stringBuilder.append("[]");
            }
            return stringBuilder.toString();
        }

        @Override
        public String getCanonicalName() {
            String canonicalName = this.componentType.getCanonicalName();
            if (canonicalName == null) {
                return NO_NAME;
            }
            StringBuilder stringBuilder = new StringBuilder(canonicalName);
            for (int i = 0; i < this.arity; ++i) {
                stringBuilder.append("[]");
            }
            return stringBuilder.toString();
        }

        @Override
        public boolean isAnonymousClass() {
            return false;
        }

        @Override
        public boolean isLocalClass() {
            return false;
        }

        @Override
        public boolean isMemberClass() {
            return false;
        }

        @Override
        public FieldList<FieldDescription.InDefinedShape> getDeclaredFields() {
            return new FieldList.Empty();
        }

        @Override
        public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods() {
            return new MethodList.Empty();
        }

        @Override
        public StackSize getStackSize() {
            return StackSize.SINGLE;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Empty();
        }

        @Override
        public AnnotationList getInheritedAnnotations() {
            return new AnnotationList.Empty();
        }

        @Override
        public PackageDescription getPackage() {
            return PackageDescription.UNDEFINED;
        }

        @Override
        public String getName() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.arity; ++i) {
                stringBuilder.append('[');
            }
            return stringBuilder.append(this.componentType.getDescriptor().replace('/', '.')).toString();
        }

        @Override
        public String getDescriptor() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.arity; ++i) {
                stringBuilder.append('[');
            }
            return stringBuilder.append(this.componentType.getDescriptor()).toString();
        }

        @Override
        public TypeDescription getDeclaringType() {
            return UNDEFINED;
        }

        @Override
        public int getModifiers() {
            return 1041;
        }

        @Override
        public GenericTypeList getTypeVariables() {
            return new GenericTypeList.Empty();
        }
    }

    public static class ForLoadedType
    extends AbstractBase {
        private final Class<?> type;

        public ForLoadedType(Class<?> type) {
            this.type = type;
        }

        @Override
        public boolean isAssignableFrom(Class<?> type) {
            return this.type.isAssignableFrom(type) || this.type.getClassLoader() != type.getClassLoader() && super.isAssignableFrom(type);
        }

        @Override
        public boolean isAssignableTo(Class<?> type) {
            return type.isAssignableFrom(this.type) || this.type.getClassLoader() != type.getClassLoader() && super.isAssignableTo(type);
        }

        @Override
        public boolean represents(Type type) {
            return type == this.type || super.represents(type);
        }

        @Override
        public TypeDescription getComponentType() {
            Class<?> componentType = this.type.getComponentType();
            return componentType == null ? UNDEFINED : new ForLoadedType(componentType);
        }

        @Override
        public boolean isArray() {
            return this.type.isArray();
        }

        @Override
        public boolean isPrimitive() {
            return this.type.isPrimitive();
        }

        @Override
        public boolean isAnnotation() {
            return this.type.isAnnotation();
        }

        @Override
        public GenericTypeDescription getDeclaredSuperType() {
            return this.type.getSuperclass() == null ? UNDEFINED : new GenericTypeDescription.LazyProjection.OfLoadedSuperType(this.type);
        }

        @Override
        public GenericTypeList getDeclaredInterfaces() {
            return this.isArray() ? ARRAY_INTERFACES : new GenericTypeList.OfLoadedInterfaceTypes(this.type);
        }

        @Override
        public TypeDescription getDeclaringType() {
            Class<?> declaringType = this.type.getDeclaringClass();
            return declaringType == null ? UNDEFINED : new ForLoadedType(declaringType);
        }

        @Override
        public MethodDescription getEnclosingMethod() {
            Method enclosingMethod = this.type.getEnclosingMethod();
            Constructor<?> enclosingConstructor = this.type.getEnclosingConstructor();
            if (enclosingMethod != null) {
                return new MethodDescription.ForLoadedMethod(enclosingMethod);
            }
            if (enclosingConstructor != null) {
                return new MethodDescription.ForLoadedConstructor(enclosingConstructor);
            }
            return MethodDescription.UNDEFINED;
        }

        @Override
        public TypeDescription getEnclosingType() {
            Class<?> enclosingType = this.type.getEnclosingClass();
            return enclosingType == null ? UNDEFINED : new ForLoadedType(enclosingType);
        }

        @Override
        public TypeList getDeclaredTypes() {
            return new TypeList.ForLoadedType(this.type.getDeclaredClasses());
        }

        @Override
        public String getSimpleName() {
            String simpleName = this.type.getSimpleName();
            int anonymousLoaderIndex = simpleName.indexOf(47);
            if (anonymousLoaderIndex == -1) {
                return simpleName;
            }
            StringBuilder normalized = new StringBuilder(simpleName.substring(0, anonymousLoaderIndex));
            Class<?> type = this.type;
            while (type.isArray()) {
                normalized.append("[]");
                type = type.getComponentType();
            }
            return normalized.toString();
        }

        @Override
        public boolean isAnonymousClass() {
            return this.type.isAnonymousClass();
        }

        @Override
        public boolean isLocalClass() {
            return this.type.isLocalClass();
        }

        @Override
        public boolean isMemberClass() {
            return this.type.isMemberClass();
        }

        @Override
        public FieldList<FieldDescription.InDefinedShape> getDeclaredFields() {
            return new FieldList.ForLoadedField(this.type.getDeclaredFields());
        }

        @Override
        public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods() {
            return new MethodList.ForLoadedType(this.type);
        }

        @Override
        public PackageDescription getPackage() {
            Package aPackage = this.type.getPackage();
            return aPackage == null ? PackageDescription.UNDEFINED : new PackageDescription.ForLoadedPackage(aPackage);
        }

        @Override
        public StackSize getStackSize() {
            return StackSize.of(this.type);
        }

        @Override
        public String getName() {
            String name = this.type.getName();
            int anonymousLoaderIndex = name.indexOf(47);
            return anonymousLoaderIndex == -1 ? name : name.substring(0, anonymousLoaderIndex);
        }

        @Override
        public String getCanonicalName() {
            String canonicalName = this.type.getCanonicalName();
            if (canonicalName == null) {
                return NO_NAME;
            }
            int anonymousLoaderIndex = canonicalName.indexOf(47);
            if (anonymousLoaderIndex == -1) {
                return canonicalName;
            }
            StringBuilder normalized = new StringBuilder(canonicalName.substring(0, anonymousLoaderIndex));
            Class<?> type = this.type;
            while (type.isArray()) {
                normalized.append("[]");
                type = type.getComponentType();
            }
            return normalized.toString();
        }

        @Override
        public String getDescriptor() {
            String name = this.type.getName();
            int anonymousLoaderIndex = name.indexOf(47);
            return anonymousLoaderIndex == -1 ? net.bytebuddy.jar.asm.Type.getDescriptor(this.type) : "L" + name.substring(0, anonymousLoaderIndex).replace('.', '/') + ";";
        }

        @Override
        public int getModifiers() {
            return this.type.getModifiers();
        }

        @Override
        public GenericTypeList getTypeVariables() {
            return new GenericTypeList.ForLoadedType(this.type.getTypeParameters());
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.ForLoadedAnnotation(this.type.getDeclaredAnnotations());
        }
    }

    public static abstract class AbstractBase
    extends ModifierReviewable.AbstractBase
    implements TypeDescription {
        @Override
        public GenericTypeDescription getSuperType() {
            GenericTypeDescription superType = this.getDeclaredSuperType();
            return superType == null ? UNDEFINED : superType.accept(RawTypeWrapper.INSTANCE);
        }

        protected abstract GenericTypeDescription getDeclaredSuperType();

        @Override
        public GenericTypeList getInterfaces() {
            return new GenericTypeList.ForDetachedTypes(this.getDeclaredInterfaces(), RawTypeWrapper.INSTANCE);
        }

        protected abstract GenericTypeList getDeclaredInterfaces();

        private static boolean isAssignable(TypeDescription sourceType, TypeDescription targetType) {
            if (sourceType.equals(targetType)) {
                return true;
            }
            if (targetType.isArray()) {
                return sourceType.isArray() ? AbstractBase.isAssignable(sourceType.getComponentType(), targetType.getComponentType()) : sourceType.represents((Type)((Object)Object.class)) || ARRAY_INTERFACES.contains(sourceType);
            }
            if (sourceType.represents((Type)((Object)Object.class))) {
                return !targetType.isPrimitive();
            }
            GenericTypeDescription superType = targetType.getSuperType();
            if (superType != null && sourceType.isAssignableFrom(superType.asErasure())) {
                return true;
            }
            if (sourceType.isInterface()) {
                for (TypeDescription interfaceType : targetType.getInterfaces().asErasures()) {
                    if (!sourceType.isAssignableFrom(interfaceType)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isAssignableFrom(Class<?> type) {
            return this.isAssignableFrom(new ForLoadedType(type));
        }

        @Override
        public boolean isAssignableFrom(TypeDescription typeDescription) {
            return AbstractBase.isAssignable(this, typeDescription);
        }

        @Override
        public boolean isAssignableTo(Class<?> type) {
            return this.isAssignableTo(new ForLoadedType(type));
        }

        @Override
        public boolean isAssignableTo(TypeDescription typeDescription) {
            return AbstractBase.isAssignable(typeDescription, this);
        }

        @Override
        public GenericTypeDescription.Sort getSort() {
            return GenericTypeDescription.Sort.NON_GENERIC;
        }

        @Override
        public TypeDescription asErasure() {
            return this;
        }

        @Override
        public GenericTypeList getUpperBounds() {
            throw new IllegalStateException("A non-generic type does not imply upper type bounds: " + this);
        }

        @Override
        public GenericTypeList getLowerBounds() {
            throw new IllegalStateException("A non-generic type does not imply lower type bounds: " + this);
        }

        @Override
        public GenericTypeList getParameters() {
            return new GenericTypeList.Empty();
        }

        @Override
        public String getSymbol() {
            throw new IllegalStateException("A non-generic type does not imply a symbol: " + this);
        }

        @Override
        public TypeDescription getOwnerType() {
            MethodDescription enclosingMethod = this.getEnclosingMethod();
            return enclosingMethod == null ? this.getEnclosingType() : enclosingMethod.getDeclaringType().asErasure();
        }

        @Override
        public boolean isInstance(Object value) {
            return this.isAssignableFrom(value.getClass());
        }

        @Override
        public boolean isInstanceOrWrapper(Object value) {
            return this.isInstance(value) || this.represents(Boolean.TYPE) && value instanceof Boolean || this.represents(Byte.TYPE) && value instanceof Byte || this.represents(Short.TYPE) && value instanceof Short || this.represents(Character.TYPE) && value instanceof Character || this.represents(Integer.TYPE) && value instanceof Integer || this.represents(Long.TYPE) && value instanceof Long || this.represents(Float.TYPE) && value instanceof Float || this.represents(Double.TYPE) && value instanceof Double;
        }

        @Override
        public boolean isAnnotationValue(Object value) {
            if (this.represents((Type)((Object)Class.class)) && value instanceof TypeDescription || value instanceof AnnotationDescription && ((AnnotationDescription)value).getAnnotationType().equals(this) || value instanceof EnumerationDescription && ((EnumerationDescription)value).getEnumerationType().equals(this) || this.represents((Type)((Object)String.class)) && value instanceof String || this.represents(Boolean.TYPE) && value instanceof Boolean || this.represents(Byte.TYPE) && value instanceof Byte || this.represents(Short.TYPE) && value instanceof Short || this.represents(Character.TYPE) && value instanceof Character || this.represents(Integer.TYPE) && value instanceof Integer || this.represents(Long.TYPE) && value instanceof Long || this.represents(Float.TYPE) && value instanceof Float || this.represents(Double.TYPE) && value instanceof Double || this.represents((Type)((Object)String[].class)) && value instanceof String[] || this.represents((Type)((Object)boolean[].class)) && value instanceof boolean[] || this.represents((Type)((Object)byte[].class)) && value instanceof byte[] || this.represents((Type)((Object)short[].class)) && value instanceof short[] || this.represents((Type)((Object)char[].class)) && value instanceof char[] || this.represents((Type)((Object)int[].class)) && value instanceof int[] || this.represents((Type)((Object)long[].class)) && value instanceof long[] || this.represents((Type)((Object)float[].class)) && value instanceof float[] || this.represents((Type)((Object)double[].class)) && value instanceof double[] || this.represents((Type)((Object)Class[].class)) && value instanceof TypeDescription[]) {
                return true;
            }
            if (this.isAssignableTo(Annotation[].class) && value instanceof AnnotationDescription[]) {
                for (AnnotationDescription annotationDescription : (AnnotationDescription[])value) {
                    if (annotationDescription.getAnnotationType().equals(this.getComponentType())) continue;
                    return false;
                }
                return true;
            }
            if (this.isAssignableTo(Enum[].class) && value instanceof EnumerationDescription[]) {
                for (EnumerationDescription enumerationDescription : (EnumerationDescription[])value) {
                    if (enumerationDescription.getEnumerationType().equals(this.getComponentType())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public String getInternalName() {
            return this.getName().replace('.', '/');
        }

        @Override
        public int getActualModifiers(boolean superFlag) {
            int actualModifiers = this.isPrivate() ? this.getModifiers() & 0xFFFFFFF5 : (this.isProtected() ? this.getModifiers() & 0xFFFFFFF3 | 1 : this.getModifiers() & 0xFFFFFFF7);
            return superFlag ? actualModifiers | 0x20 : actualModifiers;
        }

        @Override
        public String getGenericSignature() {
            try {
                SignatureWriter signatureWriter = new SignatureWriter();
                boolean generic = false;
                for (GenericTypeDescription typeVariable : this.getTypeVariables()) {
                    signatureWriter.visitFormalTypeParameter(typeVariable.getSymbol());
                    Iterator iterator = typeVariable.getUpperBounds().iterator();
                    while (iterator.hasNext()) {
                        GenericTypeDescription upperBound;
                        upperBound.accept(new GenericTypeDescription.Visitor.ForSignatureVisitor((upperBound = (GenericTypeDescription)iterator.next()).asErasure().isInterface() ? signatureWriter.visitInterfaceBound() : signatureWriter.visitClassBound()));
                    }
                    generic = true;
                }
                GenericTypeDescription superType = this.getSuperType();
                if (superType == null) {
                    superType = OBJECT;
                }
                superType.accept(new GenericTypeDescription.Visitor.ForSignatureVisitor(signatureWriter.visitSuperclass()));
                generic = generic || !superType.getSort().isNonGeneric();
                for (GenericTypeDescription interfaceType : this.getInterfaces()) {
                    interfaceType.accept(new GenericTypeDescription.Visitor.ForSignatureVisitor(signatureWriter.visitInterface()));
                    generic = generic || !interfaceType.getSort().isNonGeneric();
                }
                return generic ? signatureWriter.toString() : NON_GENERIC_SIGNATURE;
            }
            catch (GenericSignatureFormatError ignored) {
                return NON_GENERIC_SIGNATURE;
            }
        }

        @Override
        public TypeVariableSource getVariableSource() {
            return UNDEFINED;
        }

        @Override
        public boolean isSamePackage(TypeDescription typeDescription) {
            PackageDescription thisPackage = this.getPackage();
            PackageDescription otherPackage = typeDescription.getPackage();
            return thisPackage == null || otherPackage == null ? thisPackage == otherPackage : thisPackage.equals(otherPackage);
        }

        @Override
        public boolean isVisibleTo(TypeDescription typeDescription) {
            return this.isPrimitive() || (this.isArray() ? this.getComponentType().isVisibleTo(typeDescription) : this.isPublic() || this.isProtected() || this.isSamePackage(typeDescription));
        }

        @Override
        public AnnotationList getInheritedAnnotations() {
            AnnotationList declaredAnnotations = this.getDeclaredAnnotations();
            if (this.getSuperType() == null) {
                return declaredAnnotations;
            }
            HashSet<TypeDescription> annotationTypes = new HashSet<TypeDescription>();
            for (AnnotationDescription annotationDescription : declaredAnnotations) {
                annotationTypes.add(annotationDescription.getAnnotationType());
            }
            return new AnnotationList.Explicit(ByteBuddyCommons.join(declaredAnnotations, this.getSuperType().asErasure().getInheritedAnnotations().inherited(annotationTypes)));
        }

        @Override
        public String getSourceCodeName() {
            if (this.isArray()) {
                TypeDescription typeDescription = this;
                int dimensions = 0;
                do {
                    ++dimensions;
                } while ((typeDescription = typeDescription.getComponentType()).isArray());
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(typeDescription.getSourceCodeName());
                for (int i = 0; i < dimensions; ++i) {
                    stringBuilder.append("[]");
                }
                return stringBuilder.toString();
            }
            return this.getName();
        }

        @Override
        public boolean isConstantPool() {
            return this.represents(Integer.TYPE) || this.represents(Long.TYPE) || this.represents(Float.TYPE) || this.represents(Double.TYPE) || this.represents((Type)((Object)String.class)) || this.represents((Type)((Object)Class.class)) || JavaType.METHOD_HANDLE.getTypeStub().equals(this) || JavaType.METHOD_TYPE.getTypeStub().equals(this);
        }

        @Override
        public boolean isPrimitiveWrapper() {
            return this.represents((Type)((Object)Boolean.class)) || this.represents((Type)((Object)Byte.class)) || this.represents((Type)((Object)Short.class)) || this.represents((Type)((Object)Character.class)) || this.represents((Type)((Object)Integer.class)) || this.represents((Type)((Object)Long.class)) || this.represents((Type)((Object)Float.class)) || this.represents((Type)((Object)Double.class));
        }

        @Override
        public boolean isAnnotationReturnType() {
            return this.isPrimitive() || this.represents((Type)((Object)String.class)) || this.isAssignableTo(Enum.class) && !this.represents((Type)((Object)Enum.class)) || this.isAssignableTo(Annotation.class) && !this.represents((Type)((Object)Annotation.class)) || this.represents((Type)((Object)Class.class)) || this.isArray() && !this.getComponentType().isArray() && this.getComponentType().isAnnotationReturnType();
        }

        @Override
        public boolean isAnnotationValue() {
            return this.isPrimitive() || this.represents((Type)((Object)String.class)) || this.isAssignableTo(TypeDescription.class) || this.isAssignableTo(AnnotationDescription.class) || this.isAssignableTo(EnumerationDescription.class) || this.isArray() && !this.getComponentType().isArray() && this.getComponentType().isAnnotationValue();
        }

        @Override
        public boolean represents(Type type) {
            return this.equals(GenericTypeDescription.Sort.describe(type));
        }

        @Override
        public String getTypeName() {
            return this.getName();
        }

        @Override
        public TypeVariableSource getEnclosingSource() {
            MethodDescription enclosingMethod = this.getEnclosingMethod();
            return enclosingMethod == null ? this.getEnclosingType() : enclosingMethod;
        }

        @Override
        public GenericTypeDescription findVariable(String symbol) {
            GenericTypeList typeVariables = (GenericTypeList)this.getTypeVariables().filter(ElementMatchers.named(symbol));
            if (typeVariables.isEmpty()) {
                TypeVariableSource enclosingSource = this.getEnclosingSource();
                return enclosingSource == null ? UNDEFINED : enclosingSource.findVariable(symbol);
            }
            return (GenericTypeDescription)typeVariables.getOnly();
        }

        @Override
        public <T> T accept(TypeVariableSource.Visitor<T> visitor) {
            return visitor.onType(this);
        }

        @Override
        public <T> T accept(GenericTypeDescription.Visitor<T> visitor) {
            return visitor.onNonGenericType(this);
        }

        @Override
        public Iterator<GenericTypeDescription> iterator() {
            return new GenericTypeDescription.SuperTypeIterator(this);
        }

        public boolean equals(Object other) {
            return other == this || other instanceof GenericTypeDescription && ((GenericTypeDescription)other).getSort().isNonGeneric() && this.getInternalName().equals(((GenericTypeDescription)other).asErasure().getInternalName());
        }

        public int hashCode() {
            return this.getInternalName().hashCode();
        }

        public String toString() {
            return (this.isPrimitive() ? "" : (this.isInterface() ? "interface" : "class") + " ") + this.getName();
        }

        public static abstract class OfSimpleType
        extends AbstractBase {
            @Override
            public boolean isPrimitive() {
                return false;
            }

            @Override
            public boolean isArray() {
                return false;
            }

            @Override
            public TypeDescription getComponentType() {
                return UNDEFINED;
            }

            @Override
            public String getDescriptor() {
                return "L" + this.getInternalName() + ";";
            }

            @Override
            public String getCanonicalName() {
                return this.isAnonymousClass() || this.isLocalClass() ? NO_NAME : this.getName().replace('$', '.');
            }

            @Override
            public String getSimpleName() {
                String internalName = this.getInternalName();
                int simpleNameIndex = internalName.lastIndexOf(36);
                int n = simpleNameIndex = simpleNameIndex == -1 ? internalName.lastIndexOf(47) : simpleNameIndex;
                if (simpleNameIndex == -1) {
                    return internalName;
                }
                while (simpleNameIndex < internalName.length() && !Character.isLetter(internalName.charAt(simpleNameIndex))) {
                    ++simpleNameIndex;
                }
                return internalName.substring(simpleNameIndex);
            }

            @Override
            public StackSize getStackSize() {
                return StackSize.SINGLE;
            }
        }

        protected static enum RawTypeWrapper implements GenericTypeDescription.Visitor<GenericTypeDescription>
        {
            INSTANCE;


            @Override
            public GenericTypeDescription onGenericArray(GenericTypeDescription genericArray) {
                return GenericTypeDescription.ForGenericArray.Latent.of(genericArray.getComponentType().accept(this), 1);
            }

            @Override
            public GenericTypeDescription onWildcard(GenericTypeDescription wildcard) {
                GenericTypeList lowerBounds = wildcard.getLowerBounds();
                return lowerBounds.isEmpty() ? GenericTypeDescription.ForWildcardType.Latent.boundedAbove(((GenericTypeDescription)wildcard.getUpperBounds().getOnly()).accept(this)) : GenericTypeDescription.ForWildcardType.Latent.boundedBelow(((GenericTypeDescription)lowerBounds.getOnly()).accept(this));
            }

            @Override
            public GenericTypeDescription onParameterizedType(GenericTypeDescription parameterizedType) {
                ArrayList<GenericTypeDescription> parameters = new ArrayList<GenericTypeDescription>(parameterizedType.getParameters().size());
                for (GenericTypeDescription parameter : parameterizedType.getParameters()) {
                    parameters.add(parameter.accept(this));
                }
                GenericTypeDescription ownerType = parameterizedType.getOwnerType();
                return new GenericTypeDescription.ForParameterizedType.Latent(parameterizedType.asErasure(), parameters, ownerType == null ? UNDEFINED : ownerType.accept(this));
            }

            @Override
            public GenericTypeDescription onTypeVariable(GenericTypeDescription typeVariable) {
                return new RawTypeVariable(typeVariable);
            }

            @Override
            public GenericTypeDescription onNonGenericType(GenericTypeDescription typeDescription) {
                return new GenericTypeDescription.ForNonGenericType.Latent(typeDescription.asErasure());
            }

            public String toString() {
                return "TypeDescription.AbstractBase.RawTypeWrapper." + this.name();
            }

            protected static class RawTypeVariable
            extends GenericTypeDescription.ForTypeVariable {
                private final GenericTypeDescription typeVariable;

                protected RawTypeVariable(GenericTypeDescription typeVariable) {
                    this.typeVariable = typeVariable;
                }

                @Override
                public GenericTypeList getUpperBounds() {
                    return new GenericTypeList.ForDetachedTypes(this.typeVariable.getUpperBounds(), INSTANCE);
                }

                @Override
                public TypeVariableSource getVariableSource() {
                    return this.typeVariable.getVariableSource();
                }

                @Override
                public String getSymbol() {
                    return this.typeVariable.getSymbol();
                }
            }
        }
    }
}

